/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.deepsupervise.impl;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.deepsupervise.IDeepSuperviseApi;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class DeepSuperviseApiImpl
extends CallApi
implements IDeepSuperviseApi {
    @Inject
    private TradeServiceDefines.DeepSuperviseServiceDefine ds;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private MConfService cs;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;

    @Override
    public void userAuthenticateRequest(String brokerId, String extAccntId, String investorId, int type, byte[] info, String appId, String token) throws MException {
        MEvent event = new MEvent();
        PMainTenance.UserAuthenticateRequest.Builder uab = PMainTenance.UserAuthenticateRequest.newBuilder();
        uab.setOpUser(this.baseApi.getOpUser());
        uab.setMarketGrp("FUTURES");
        uab.setSessionUuid(String.valueOf(this.baseApi.getUserId()) + "|" + this.baseApi.getOpUser().getUuid());
        uab.setBrokerId(brokerId);
        uab.setExtAccntId(extAccntId);
        uab.setInvestorId(investorId);
        uab.setAuthTypeValue(type);
        if (type == 1) {
            PMainTenance.UserCertification.Builder certb = PMainTenance.UserCertification.newBuilder();
            certb.setAppId(appId);
            certb.setAuthCode(token);
            certb.setCertInInformationBytes(ByteString.copyFrom((byte[])info));
            uab.setObject(Any.pack((Message)certb.build()));
        } else if (type == 2) {
            PMainTenance.UserSystemInformation.Builder infob = PMainTenance.UserSystemInformation.newBuilder();
            infob.setAppId(appId);
            infob.setAuthCode(token);
            infob.setPublicIp(this.baseApi.getOpUser().getIp());
            infob.setPublicPort(this.eCore.getInt("port") == 0 ? "53460" : "" + this.eCore.get((Object)"port"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            infob.setLoginTime(sdf.format(new Date()));
            infob.setSystemInformation(ByteString.copyFrom((byte[])info));
            uab.setObject(Any.pack((Message)infob.build()));
        }
        event.setObj((Object)uab.build());
        this.action(this.ds, "403", event);
        this.checkStatus(event.getObj());
    }
}

