/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.info;

import cms.tmx.datatype.proto.PBase;
import cms.tmx.utils.StringUtils;

public class MiseGatewayData {
    private String policyId = "policy_id";
    private String postId = "";
    private String currency = "";
    private String portfolioId = "";
    private String investorId = "";
    private String resourceId = "";
    private String instructionId = "";
    private String mac = "";
    private String ip = "";
    private String sn = "";
    private String partyId = "";
    private String regionId = "";
    private String uuid = "";
    private String localIp = "";
    private String cpu = "";
    private String sno = "";
    private String pcn = "";
    private String pi = "";
    private String vol = "";
    private String osv = "";
    private String terminalType = "";
    private String trail = "";

    public MiseGatewayData(PBase.OpUser user, String currency, String portfolioId, String investorId, String resourceId, String instructionId) {
        this.parseUser(user);
        this.setCurrency(currency);
        this.setPortfolioId(portfolioId);
        this.setInvestorId(investorId);
        this.setResourceId(resourceId);
        this.setInstructionId(instructionId);
    }

    private void parseUser(PBase.OpUser user) {
        this.postId = user.getPostId();
        this.mac = user.getMac();
        this.ip = user.getIp();
        this.sn = user.getSn();
        this.partyId = user.getPartyId();
        this.regionId = String.valueOf(user.getRegionId());
        this.uuid = user.getUuid();
        this.localIp = user.getLocalIp();
        this.cpu = user.getCpu();
        this.sno = user.getSno();
        this.pcn = user.getPcn();
        this.pi = user.getPi();
        if (!StringUtils.isEmpty((String)this.pi)) {
            this.pi = this.pi.replace(",", "$");
        }
        this.vol = user.getVol();
        this.osv = user.getOsv();
        this.terminalType = user.getTerminalType();
        this.trail = user.getText();
    }

    public String toString() {
        String gatewayData = String.join((CharSequence)"#", this.policyId, this.postId, this.currency, this.portfolioId, this.investorId, this.resourceId, this.instructionId, this.mac, this.ip, this.sn, this.partyId, this.regionId, this.uuid, this.localIp, this.cpu, this.sno, this.pcn, this.pi, this.vol, this.osv, this.terminalType, this.trail);
        return gatewayData;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public String getPostId() {
        return this.postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(String instructionId) {
        this.instructionId = instructionId;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getSno() {
        return this.sno;
    }

    public void setSno(String sno) {
        this.sno = sno;
    }

    public String getPcn() {
        return this.pcn;
    }

    public void setPcn(String pcn) {
        this.pcn = pcn;
    }

    public String getPi() {
        return this.pi;
    }

    public void setPi(String pi) {
        this.pi = pi;
    }

    public String getVol() {
        return this.vol;
    }

    public void setVol(String vol) {
        this.vol = vol;
    }

    public String getOsv() {
        return this.osv;
    }

    public void setOsv(String osv) {
        this.osv = osv;
    }

    public String getTerminalType() {
        return this.terminalType;
    }

    public void setTerminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    public String getTrail() {
        return this.trail;
    }

    public void setTrail(String trail) {
        this.trail = trail;
    }
}

