/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.ITransferFundApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.datatype.proto.PBase;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TransferFundApiImpl
extends CallApi
implements ITransferFundApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.OrderServiceDefine os;

    @Override
    public void TransferFund(String marketGrp, String investorId, String currencyId, double amount, int fundId, int operationType) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMainTenance.TransferFundRequest.Builder builder = PMainTenance.TransferFundRequest.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        builder.setInvestorId(investorId);
        builder.setCurrency(currencyId);
        builder.setAmount(amount);
        builder.setSeq(fundId);
        builder.setOperationType(operationType);
        event.setObj((Object)builder.build());
        this.action(this.os, "280", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }

    @Override
    public void TransferPosi(String marketGrp, String investorId, String secAccountId, int volume, int posiId, int operationType, PComponent.Instrument instrument) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMainTenance.TransferPositionRequest.Builder builder = PMainTenance.TransferPositionRequest.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        builder.setInvestorId(investorId);
        builder.setSecAccntId(secAccountId);
        builder.setVolume(volume);
        builder.setInstrument(instrument);
        builder.setSeq(posiId);
        builder.setOperationType(operationType);
        event.setObj((Object)builder.build());
        this.action(this.os, "281", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }

    @Override
    public void getTransferFund(String marketGrp, String investorId, String currencyId, int avaId) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMainTenance.GetTransferFundRequest.Builder builder = PMainTenance.GetTransferFundRequest.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        builder.setInvestorId(investorId);
        builder.setCurrency(currencyId);
        builder.setSeq(avaId);
        event.setObj((Object)builder.build());
        this.action(this.os, "288", event);
    }

    @Override
    public void getTransferPosi(String investorId, String marketGrp, int posiAvaId) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMainTenance.GetTransferPositionRequest.Builder builder = PMainTenance.GetTransferPositionRequest.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        builder.setInvestorId(investorId);
        builder.setSeq(posiAvaId);
        event.setObj((Object)builder.build());
        this.action(this.os, "289", event);
    }

    @Override
    public void getTransferPosition(String code, String market, String investorId, String marketGrp, int posiAvaId) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PComponent.Instrument.Builder instBuilder = PComponent.Instrument.newBuilder();
        instBuilder.setSecurityId(code);
        instBuilder.setMarket(market);
        PMainTenance.GetTransferPositionRequest.Builder builder = PMainTenance.GetTransferPositionRequest.newBuilder();
        builder.setOpUser(opUser);
        builder.setInstrument(instBuilder);
        builder.setMarketGrp(marketGrp);
        builder.setInvestorId(investorId);
        builder.setSeq(posiAvaId);
        event.setObj((Object)builder.build());
        this.action(this.os, "289", event);
    }

    @Override
    public void getTransferResult(String investorId, String marketGrp) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMainTenance.SyncAccountingRequest.Builder builder = PMainTenance.SyncAccountingRequest.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        builder.setInvestorId(investorId);
        event.setObj((Object)builder.build());
        this.action(this.os, "293", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }

    @Override
    public void TransferAllPosi(String marketGrp, String investorId, int volume, int posiId, int operationType) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMainTenance.TransferPositionRequest.Builder builder = PMainTenance.TransferPositionRequest.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        builder.setInvestorId(investorId);
        builder.setVolume(volume);
        builder.setSeq(posiId);
        builder.setOperationType(operationType);
        event.setObj((Object)builder.build());
        this.action(this.os, "281", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }
}

