/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.IQueryQuoteApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.message.PQuote;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class QueryQuoteApiImpl
extends CallApi
implements IQueryQuoteApi {
    @Inject
    private TradeServiceDefines.QuoteServiceDefine quoteSeviceService;
    @Inject
    private TradeServiceDefines.QuoteServiceDefine quoteService;
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;

    private void queryQuoteByPage(String clOrdID, String quoteStatus, String quoteId, List<PQuote.Quote> quoteList, PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        POrderService.GetQuotesReq.Builder builder = POrderService.GetQuotesReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setPage(defPage);
        builder.setMarketGrp("IB");
        if (clOrdID != null && !"".equals(clOrdID)) {
            builder.setClOrdId(clOrdID);
        }
        if (quoteId != null && !"".equals(quoteId)) {
            builder.setQuoteId(quoteId);
        }
        if (quoteStatus != null && !"".equals(quoteStatus)) {
            builder.setQuoteStatus(PField.QuoteStatus.forNumber((int)Integer.valueOf(quoteStatus)));
        }
        event.setObj((Object)builder.build());
        this.action(this.queryService, "400", event);
        POrderService.GetQuotesResp resp = (POrderService.GetQuotesResp)event.getObj(POrderService.GetQuotesResp.class);
        this.checkStatus(resp.getStatus());
        quoteList.addAll(resp.getQuoteList());
    }

    @Override
    public void submit(PQuote.QuoteCancel quoteCancel) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)quoteCancel);
        this.action(this.quoteService, "231", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }

    @Override
    public void addQuoteOrder(PQuote.Quote data) throws MException {
        MEvent event = new MEvent();
        event.put((Object)"user_id", (Object)this.baseApi.getOpUser().getUserId());
        event.setObj((Object)data);
        this.action(this.quoteSeviceService, "230", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PQuote.Quote> queryQuote(String clOrdID, String quoteStatus, String quoteId) throws MException {
        LinkedList<PQuote.Quote> quoteList = new LinkedList<PQuote.Quote>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryQuoteByPage(clOrdID, quoteStatus, quoteId, quoteList, defPage, i);
        return quoteList;
    }

    @Override
    public List<PQuote.Quote> queryQuote() throws MException {
        LinkedList<PQuote.Quote> quoteList = new LinkedList<PQuote.Quote>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryQuoteByPage("", "", "", quoteList, defPage, i);
        return quoteList;
    }

    @Override
    public void quoteCancelReplace(PQuote.QuoteCancelReplaceRequest quoteCancelReplaceRequest) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)quoteCancelReplaceRequest);
        this.action(this.quoteService, "236", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }
}

