/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.IQueryPositionsApi;
import cms.tmx.api.trade.info.ICcsPortfPostQueryInfo;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.api.trade.info.IPositionQueryInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.datatype.proto.PBase;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class QueryPositionsApiImpl
extends CallApi
implements IQueryPositionsApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine qs;

    @Override
    public List<PPositionService.ExtPosition> query(String acc, String marketGrp) throws MException {
        return this.query(acc, marketGrp, null);
    }

    @Override
    public List<PPositionService.ExtPosition> query(IPositionQueryInfo queryInfo) throws MException {
        return this.query("", "", queryInfo);
    }

    private List<PPositionService.ExtPosition> query(String acc, String marketGrp, IPositionQueryInfo queryInfo) throws MException {
        LinkedList<PPositionService.ExtPosition> extPositionList = new LinkedList<PPositionService.ExtPosition>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.queryExtPositionsByPage(acc, marketGrp, queryInfo, extPositionList, defPage, i);
        return extPositionList;
    }

    private void queryExtPositionsByPage(String acc, String marketGrp, IPositionQueryInfo queryInfo, List<PPositionService.ExtPosition> extPositionList, PBase.Page page, int i) throws MException {
        MEvent event = new MEvent();
        PPositionService.GetExtPositionsReq.Builder builder = PPositionService.GetExtPositionsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        if (queryInfo == null) {
            builder.setOpUser(this.bmi.getOpUser());
            builder.setMarketGrp(marketGrp);
            builder.setExtAccntId(acc);
            builder.setPage(page);
        } else {
            builder.setMarketGrp(queryInfo.getMktGroupInfo());
            builder.setExtAccntId(queryInfo.getExtAccntIdInfo());
            builder.setInstrument(queryInfo.getSecIdInfo());
            builder.setMarket(queryInfo.getMktInfo());
            builder.setExtSecAccntId(queryInfo.getExtSecAccIdInfo());
            builder.setPage(page);
            PCtpExtra.CTPExtPositionReq message = null;
            if (queryInfo.getMktGroupInfo().equals("FUTURES")) {
                PCtpExtra.CTPExtPositionReq.Builder extra = PCtpExtra.CTPExtPositionReq.newBuilder();
                if (!queryInfo.getHedgeFlagInfo().equals("")) {
                    extra.setHedgeFlag(Integer.parseInt(queryInfo.getHedgeFlagInfo()));
                }
                if (!queryInfo.getPstDirInfo().equals("")) {
                    extra.setPosiDirection(Integer.parseInt(queryInfo.getPstDirInfo()));
                }
                message = extra.build();
                builder.setObject(Any.pack((Message)message));
            }
        }
        PField.PositionSettingType set = PField.PositionSettingType.forNumber((int)1);
        builder.setSettingType(set);
        event.setObj((Object)builder.build());
        this.action(this.qs, "256", event);
        PPositionService.GetExtPositionsResp resp = (PPositionService.GetExtPositionsResp)event.getObj(PPositionService.GetExtPositionsResp.class);
        extPositionList.addAll(resp.getPositionList());
        if (resp.getPage().getTotalRow() > page.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = page.toBuilder();
            pageBuilder.setStartRow(page.getPageSize() * i + 1);
            this.queryExtPositionsByPage(acc, marketGrp, queryInfo, extPositionList, pageBuilder.build(), i);
        }
    }

    @Override
    public List<PPositionService.SubPosition> portfQuery(String subFundAccntId, String subSecAccntId, String marketGrp) throws MException {
        return this.portfQuery(subFundAccntId, subSecAccntId, marketGrp, null);
    }

    @Override
    public List<PPositionService.SubPosition> portfQuery(ICcsPortfPostQueryInfo queryInfo) throws MException {
        return this.portfQuery("", "", "", queryInfo);
    }

    private List<PPositionService.SubPosition> portfQuery(String subFundAccntId, String subSecAccntId, String marketGrp, ICcsPortfPostQueryInfo queryInfo) throws MException {
        LinkedList<PPositionService.SubPosition> subPositionList = new LinkedList<PPositionService.SubPosition>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.portfQuerySubPositionsByPage(subFundAccntId, subSecAccntId, marketGrp, queryInfo, subPositionList, defPage, i);
        return subPositionList;
    }

    private void portfQuerySubPositionsByPage(String subFundAccntId, String subSecAccntId, String marketGrp, ICcsPortfPostQueryInfo queryInfo, List<PPositionService.SubPosition> extPositionList, PBase.Page page, int i) throws MException {
        MEvent event = new MEvent();
        PPositionService.GetSubPositionsReq.Builder builder = PPositionService.GetSubPositionsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        PField.PositionSettingType set = PField.PositionSettingType.forNumber((int)1);
        if (subSecAccntId.contains("_rs")) {
            set = PField.PositionSettingType.forNumber((int)3);
        }
        builder.setSettingType(set);
        if (queryInfo == null) {
            builder.setOpUser(this.bmi.getOpUser());
            builder.setMarketGrp(marketGrp);
            if (!subFundAccntId.isEmpty()) {
                builder.setSubAccntId(subFundAccntId);
            }
            if (!subSecAccntId.isEmpty()) {
                if (subSecAccntId.contains("_rs")) {
                    subSecAccntId = subSecAccntId.replace("_rs", "");
                }
                builder.setSubSecAccntId(subSecAccntId);
            }
        } else {
            builder.setMarketGrp(queryInfo.getMktGroupInfo());
            builder.setPortfolioId(queryInfo.getPortfolioId());
            builder.setSubAccntId(queryInfo.getSubAccntId());
            builder.setSubSecAccntId(queryInfo.getSubSecAccntId());
            builder.setInstrument(queryInfo.getSecIdInfo());
            builder.setMarket(queryInfo.getMktInfo());
        }
        builder.setPage(page);
        event.setObj((Object)builder.build());
        this.action(this.qs, "257", event);
        PPositionService.GetSubPositionsResp resp = (PPositionService.GetSubPositionsResp)event.getObj(PPositionService.GetSubPositionsResp.class);
        extPositionList.addAll(resp.getPositionList());
        if (resp.getPage().getTotalRow() > page.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = page.toBuilder();
            pageBuilder.setStartRow(page.getPageSize() * i + 1);
            this.portfQuerySubPositionsByPage(subFundAccntId, subSecAccntId, marketGrp, queryInfo, extPositionList, pageBuilder.build(), i);
        }
    }

    @Override
    public void queryPositionsInTurn(IPageInTurn<String, String, PPositionService.ExtPosition> page, String extAccntId, String marketGrp) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        MEvent event = new MEvent();
        PPositionService.GetExtPositionsReq.Builder builder = PPositionService.GetExtPositionsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setExtAccntId(extAccntId);
        builder.setPage(this.buildPage(page));
        PField.PositionSettingType set = PField.PositionSettingType.forNumber((int)1);
        builder.setSettingType(set);
        event.setObj((Object)builder.build());
        this.action(this.qs, "256", event);
        PPositionService.GetExtPositionsResp resp = (PPositionService.GetExtPositionsResp)event.getObj(PPositionService.GetExtPositionsResp.class);
        page.getResList().addAll(resp.getPositionList());
        page.setTotalRow(resp.getPage().getTotalRow());
    }

    @Override
    public void querySubPositionsInTurn(IPageInTurn<String, String, PPositionService.SubPosition> page, String subAccntId, String marketGrp) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        MEvent event = new MEvent();
        PPositionService.GetSubPositionsReq.Builder builder = PPositionService.GetSubPositionsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setSubAccntId(subAccntId);
        builder.setPage(this.buildPage(page));
        PField.PositionSettingType set = PField.PositionSettingType.forNumber((int)1);
        builder.setSettingType(set);
        event.setObj((Object)builder.build());
        this.action(this.qs, "257", event);
        PPositionService.GetSubPositionsResp resp = (PPositionService.GetSubPositionsResp)event.getObj(PPositionService.GetSubPositionsResp.class);
        page.setTotalRow(resp.getPage().getTotalRow());
        page.getResList().addAll(resp.getPositionList());
    }
}

