/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.IQueryOrderApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.strategy.PStrategy;
import com.google.protobuf.Any;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class QueryOrderApiImpl
extends CallApi
implements IQueryOrderApi {
    private static final Logger logger = LogManager.getLogger(QueryOrderApiImpl.class);
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;
    @Inject
    private TradeServiceDefines.FutureStrategyServiceDefine futureService;

    @Override
    public List<POrderService.SingleOrder> queryOrders(String marketGrp, String extAccntId, String subAccId, String resourceId, String reference) throws MException {
        LinkedList<POrderService.SingleOrder> singleOrderList = new LinkedList<POrderService.SingleOrder>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryOrdersByPage(marketGrp, extAccntId, subAccId, resourceId, reference, singleOrderList, defPage, i);
        return singleOrderList;
    }

    private void queryOrdersByPage(String marketGrp, String extAccntId, String subAccId, String resourceId, String reference, List<POrderService.SingleOrder> singleOrderList, PBase.Page defPage, int i) throws MException {
        PCtpExtra.CTPSingleOrdersReq.Builder extra;
        MEvent event = new MEvent();
        POrderService.GetSingleOrdersReq.Builder builder = POrderService.GetSingleOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setPage(defPage);
        builder.setResourceId(resourceId);
        builder.setReference(reference);
        PCtpExtra.CTPSingleOrdersReq message = null;
        if ("FUTURES".equals(marketGrp)) {
            extra = PCtpExtra.CTPSingleOrdersReq.newBuilder();
            extra.setExtAccntId(extAccntId);
            message = extra.build();
        } else if ("CCS".equals(marketGrp)) {
            extra = PCcsExtra.CcsSingleOrdersReq.newBuilder();
            extra.setExtAccntId(extAccntId);
            extra.setSubAccntId(subAccId);
            message = extra.build();
        }
        builder.setObject(Any.pack(message));
        event.setObj((Object)builder.build());
        this.action(this.queryService, "265", event);
        POrderService.GetSingleOrdersResp resp = (POrderService.GetSingleOrdersResp)event.getObj(POrderService.GetSingleOrdersResp.class);
        this.checkStatus(resp.getStatus());
        singleOrderList.addAll(resp.getOrderList());
        if (resp.getPage().getPageSize() == 0) {
            return;
        }
        if (resp.getPage().getTotalRow() > defPage.getStartRow() + resp.getPage().getPageSize() - 1) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getStartRow() + resp.getPage().getPageSize());
            this.queryOrdersByPage(marketGrp, extAccntId, subAccId, resourceId, reference, singleOrderList, pageBuilder.build(), i);
        }
    }

    private void queryEtfOrdersByPage(List<POrderService.CrossOrder> list, PBase.Page defPage, int i, boolean flag, String extAccntId) throws MException {
        MEvent event = new MEvent();
        POrderService.GetCrossOrdersReq.Builder hBuilder = POrderService.GetCrossOrdersReq.newBuilder();
        hBuilder.setOpUser(this.baseApi.getOpUser());
        hBuilder.setMarketGrp("CCS");
        hBuilder.setExtAccntId(extAccntId);
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.queryService, "264", event);
        POrderService.GetCrossOrdersResp resp = (POrderService.GetCrossOrdersResp)event.getObj(POrderService.GetCrossOrdersResp.class);
        this.checkStatus(resp.getStatus());
        list.addAll(resp.getCrossOrderList());
        if (!flag) {
            return;
        }
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryEtfOrdersByPage(list, pageBuilder.build(), i, flag, extAccntId);
        }
    }

    private void queryFutureCrossOrderByPage(List<POrderService.CrossOrder> list, PBase.Page defPage, int i, String extAccntId, String extSecAccntId, boolean flag) throws MException {
        MEvent event = new MEvent();
        POrderService.GetCrossOrdersReq.Builder hBuilder = POrderService.GetCrossOrdersReq.newBuilder();
        hBuilder.setOpUser(this.baseApi.getOpUser());
        hBuilder.setMarketGrp("FUTURES");
        hBuilder.setExtAccntId(extAccntId);
        hBuilder.setExtSecAccntId(extSecAccntId);
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.queryService, "264", event);
        POrderService.GetCrossOrdersResp resp = (POrderService.GetCrossOrdersResp)event.getObj(POrderService.GetCrossOrdersResp.class);
        this.checkStatus(resp.getStatus());
        list.addAll(resp.getCrossOrderList());
        if (!flag) {
            return;
        }
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryFutureCrossOrderByPage(list, pageBuilder.build(), i, extAccntId, extSecAccntId, flag);
        }
    }

    @Override
    public List<POrderService.SingleOrder> queryOrders(String marketGrp, String extAccntId, List<String> listOrderIds) throws MException {
        ArrayList<POrderService.SingleOrder> liste = new ArrayList<POrderService.SingleOrder>();
        int m = listOrderIds.size() / 150;
        int n = listOrderIds.size() % 150;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            list = i == m ? listOrderIds.subList(m * 150, m * 150 + n) : listOrderIds.subList(i * 150, (i + 1) * 150);
            liste.addAll(this.queryTwoHundredOrders(marketGrp, extAccntId, list));
            ++i;
        }
        return liste;
    }

    private List<POrderService.SingleOrder> queryTwoHundredOrders(String marketGrp, String extAccntId, List<String> listOrderIds) throws MException {
        PCtpExtra.CTPSingleOrdersReq.Builder extra;
        MEvent event = new MEvent();
        PBase.Page defPage = this.baseApi.getDefPage();
        POrderService.GetSingleOrdersReq.Builder builder = POrderService.GetSingleOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.addAllOrderId(listOrderIds);
        builder.setPage(defPage);
        PCtpExtra.CTPSingleOrdersReq message = null;
        if ("FUTURES".equals(marketGrp)) {
            extra = PCtpExtra.CTPSingleOrdersReq.newBuilder();
            extra.setExtAccntId(extAccntId);
            message = extra.build();
        } else if ("CCS".equals(marketGrp)) {
            extra = PCcsExtra.CcsSingleOrdersReq.newBuilder();
            extra.setExtAccntId(extAccntId);
            message = extra.build();
        }
        builder.setObject(Any.pack(message));
        event.setObj((Object)builder.build());
        System.err.println(listOrderIds);
        this.action(this.queryService, "265", event);
        POrderService.GetSingleOrdersResp resp = (POrderService.GetSingleOrdersResp)event.getObj(POrderService.GetSingleOrdersResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getOrderList();
    }

    @Override
    public List<POrderService.CrossOrder> queryEtfOrders(boolean flag, String extAccntId) throws MException {
        LinkedList<POrderService.CrossOrder> list = new LinkedList<POrderService.CrossOrder>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryEtfOrdersByPage(list, defPage, i, flag, extAccntId);
        return list;
    }

    @Override
    public List<POrderService.CrossOrder> queryFutureCrossOrder(String extAccntId, String extSecAccntId, boolean flag) throws MException {
        LinkedList<POrderService.CrossOrder> list = new LinkedList<POrderService.CrossOrder>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryFutureCrossOrderByPage(list, defPage, i, extAccntId, extSecAccntId, flag);
        return list;
    }

    @Override
    public List<POrderService.CrossOrder> queryOneFutureCrossOrder(List<String> crossId, boolean flag, String extAccntId, String extSecAccntId) throws MException {
        LinkedList<POrderService.CrossOrder> list = new LinkedList<POrderService.CrossOrder>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryOneFutureCrossOrderByPage(crossId, list, defPage, i, flag, extAccntId, extSecAccntId);
        return list;
    }

    @Override
    public POrderService.CrossOrder queryOneEtfOrder(String crossId, boolean flag, String extAccntId) throws MException {
        LinkedList<POrderService.CrossOrder> list = new LinkedList<POrderService.CrossOrder>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryOneEtfOrderByPage(crossId, list, defPage, i, flag, extAccntId);
        if (list.size() > 0) {
            return (POrderService.CrossOrder)list.get(0);
        }
        return null;
    }

    private void queryOneEtfOrderByPage(String crossId, List<POrderService.CrossOrder> list, PBase.Page defPage, int i, boolean flag, String extAccntId) throws MException {
        MEvent event = new MEvent();
        POrderService.GetCrossOrdersReq.Builder hBuilder = POrderService.GetCrossOrdersReq.newBuilder();
        hBuilder.setOpUser(this.baseApi.getOpUser());
        hBuilder.setMarketGrp("CCS");
        hBuilder.setPage(defPage);
        hBuilder.addCrossId(crossId);
        hBuilder.setExtAccntId(extAccntId);
        event.setObj((Object)hBuilder.build());
        this.action(this.queryService, "264", event);
        POrderService.GetCrossOrdersResp resp = (POrderService.GetCrossOrdersResp)event.getObj(POrderService.GetCrossOrdersResp.class);
        this.checkStatus(resp.getStatus());
        list.addAll(resp.getCrossOrderList());
        if (!flag) {
            return;
        }
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryOneEtfOrderByPage(crossId, list, pageBuilder.build(), i, flag, extAccntId);
        }
    }

    private void queryOneFutureCrossOrderByPage(List<String> crossIds, List<POrderService.CrossOrder> list, PBase.Page defPage, int i, boolean flag, String extAccntId, String extSecAccntId) throws MException {
        MEvent event = new MEvent();
        POrderService.GetCrossOrdersReq.Builder hBuilder = POrderService.GetCrossOrdersReq.newBuilder();
        hBuilder.setOpUser(this.baseApi.getOpUser());
        hBuilder.setMarketGrp("FUTURES");
        hBuilder.setPage(defPage);
        hBuilder.addAllCrossId(crossIds);
        hBuilder.setExtAccntId(extAccntId);
        hBuilder.setExtSecAccntId(extSecAccntId);
        event.setObj((Object)hBuilder.build());
        long start = System.currentTimeMillis();
        this.action(this.queryService, "264", event);
        logger.error("\u505a\u5e02\u5355\u63a8\u9001\u67e5\u8be2\uff0c\u7eaf\u63a5\u53e3\uff1a" + (System.currentTimeMillis() - start) + ", crossIdList: " + crossIds);
        POrderService.GetCrossOrdersResp resp = (POrderService.GetCrossOrdersResp)event.getObj(POrderService.GetCrossOrdersResp.class);
        this.checkStatus(resp.getStatus());
        list.addAll(resp.getCrossOrderList());
        if (!flag) {
            return;
        }
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryOneFutureCrossOrderByPage(crossIds, list, pageBuilder.build(), i, flag, extAccntId, extSecAccntId);
        }
    }

    @Override
    public void queryOrdersInTurn(IPageInTurn<String, String, POrderService.SingleOrder> page, String marketGrp, String extAccntId, String subAccId, String resourceId, String reference, boolean isUnfinishedOrder) throws MException {
        PCtpExtra.CTPSingleOrdersReq.Builder extra;
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        MEvent event = new MEvent();
        POrderService.GetSingleOrdersReq.Builder builder = POrderService.GetSingleOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setPage(this.buildPage(page));
        builder.setResourceId(resourceId);
        builder.setReference(reference);
        if (isUnfinishedOrder) {
            builder.setEndOrdStatus(2);
        }
        PCtpExtra.CTPSingleOrdersReq message = null;
        if ("FUTURES".equals(marketGrp)) {
            extra = PCtpExtra.CTPSingleOrdersReq.newBuilder();
            extra.setExtAccntId(extAccntId);
            message = extra.build();
        } else if ("CCS".equals(marketGrp)) {
            extra = PCcsExtra.CcsSingleOrdersReq.newBuilder();
            extra.setExtAccntId(extAccntId);
            extra.setSubAccntId(subAccId);
            message = extra.build();
        }
        builder.setObject(Any.pack(message));
        event.setObj((Object)builder.build());
        this.action(this.queryService, "265", event);
        POrderService.GetSingleOrdersResp resp = (POrderService.GetSingleOrdersResp)event.getObj(POrderService.GetSingleOrdersResp.class);
        int size = resp.getOrderList().size();
        page.getResList().addAll(resp.getOrderList());
        page.setTotalRow(resp.getPage().getTotalRow());
        if (size == 0 || page.getResList().size() == resp.getPage().getTotalRow()) {
            return;
        }
        if (size < page.getPageSize()) {
            page.setStartRow(page.getStartRow() + size);
            page.setPageSize(page.getPageSize() - size);
            this.queryOrdersInTurn(page, marketGrp, extAccntId, subAccId, resourceId, reference, isUnfinishedOrder);
        }
    }

    @Override
    public void queryHedgeOrdersInTurn(IPageInTurn<String, String, PStrategy.SingleOrder> page, List<String> extSecAcct, int selectFlag) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        MEvent event = new MEvent();
        PStrategy.GetSingleOrdersReq.Builder builder = PStrategy.GetSingleOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setPage(this.buildPage(page));
        builder.addAllExtSecAccntId(extSecAcct);
        builder.setSelectOrderFlag(selectFlag);
        event.setObj((Object)builder.build());
        this.action(this.futureService, "010", event);
        PStrategy.GetSingleOrdersResp resp = (PStrategy.GetSingleOrdersResp)event.getObj(PStrategy.GetSingleOrdersResp.class);
        int size = resp.getSingleOrderList().size();
        page.getResList().addAll(resp.getSingleOrderList());
        page.setTotalRow(resp.getPage().getTotalRow());
        if (size == 0 || page.getResList().size() == resp.getPage().getTotalRow()) {
            return;
        }
        if (size < page.getPageSize()) {
            page.setStartRow(page.getStartRow() + size);
            page.setPageSize(page.getPageSize() - size);
            this.queryHedgeOrdersInTurn(page, extSecAcct, selectFlag);
        }
    }
}

