/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.IQueryDealApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PCtpExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class QueryDealApiImpl
extends CallApi
implements IQueryDealApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;

    @Override
    public List<POrderService.Execution> queryDeals(String marketGrp, String extAccntId) throws MException {
        LinkedList<POrderService.Execution> executionList = new LinkedList<POrderService.Execution>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryDealsByPage(marketGrp, extAccntId, "", executionList, defPage, i);
        return executionList;
    }

    @Override
    public List<POrderService.Execution> queryPortfDeals(String marketGrp, String extAccntId, String subExcAccntId) throws MException {
        LinkedList<POrderService.Execution> executionList = new LinkedList<POrderService.Execution>();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryDealsByPage(marketGrp, extAccntId, subExcAccntId, executionList, defPage, i);
        return executionList;
    }

    private void queryDealsByPage(String marketGrp, String extAccntId, String subExcAccntId, List<POrderService.Execution> executionList, PBase.Page defPage, int i) throws MException {
        PCtpExtra.CTPExecutionReq.Builder builderEx;
        MEvent event = new MEvent();
        POrderService.GetExecutionsReq.Builder builder = POrderService.GetExecutionsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setExtAccntId(extAccntId);
        builder.setPage(defPage);
        PCtpExtra.CTPExecutionReq message = null;
        if ("FUTURES".equals(marketGrp)) {
            builderEx = PCtpExtra.CTPExecutionReq.newBuilder();
            message = builderEx.build();
        } else {
            builderEx = PCcsExtra.CcsExecutionReq.newBuilder();
            builderEx.setSubAccntId(subExcAccntId);
            message = builderEx.build();
        }
        if (message != null) {
            builder.setObject(Any.pack((Message)message));
        }
        event.setObj((Object)builder.build());
        this.action(this.queryService, "263", event);
        POrderService.GetExecutionsResp resp = (POrderService.GetExecutionsResp)event.getObj(POrderService.GetExecutionsResp.class);
        this.checkStatus(resp.getStatus());
        executionList.addAll(resp.getExecutionList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryDealsByPage(marketGrp, extAccntId, subExcAccntId, executionList, pageBuilder.build(), i);
        }
    }

    @Override
    public List<POrderService.Execution> queryDeals(String marketGrp, String extAccntId, String id) throws MException {
        PCtpExtra.CTPExecutionReq.Builder builderEx;
        MEvent event = new MEvent();
        PBase.Page defPage = this.baseApi.getDefPage();
        POrderService.GetExecutionsReq.Builder builder = POrderService.GetExecutionsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setExtAccntId(extAccntId);
        builder.setExecId(id);
        builder.setPage(defPage);
        PCtpExtra.CTPExecutionReq message = null;
        if ("FUTURES".equals(marketGrp)) {
            builderEx = PCtpExtra.CTPExecutionReq.newBuilder();
            message = builderEx.build();
        } else {
            builderEx = PCcsExtra.CcsExecutionReq.newBuilder();
            message = builderEx.build();
        }
        if (message != null) {
            builder.setObject(Any.pack((Message)message));
        }
        event.setObj((Object)builder.build());
        this.action(this.queryService, "263", event);
        POrderService.GetExecutionsResp resp = (POrderService.GetExecutionsResp)event.getObj(POrderService.GetExecutionsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getExecutionList();
    }

    @Override
    public void queryDealsInTurn(IPageInTurn<String, String, POrderService.Execution> page, String marketGrp, String extAccntId, String subExcAccntId) throws MException {
        PCtpExtra.CTPExecutionReq.Builder builderEx;
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        MEvent event = new MEvent();
        POrderService.GetExecutionsReq.Builder builder = POrderService.GetExecutionsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setExtAccntId(extAccntId);
        builder.setPage(this.buildPage(page));
        PCtpExtra.CTPExecutionReq message = null;
        if ("FUTURES".equals(marketGrp)) {
            builderEx = PCtpExtra.CTPExecutionReq.newBuilder();
            message = builderEx.build();
        } else {
            builderEx = PCcsExtra.CcsExecutionReq.newBuilder();
            builderEx.setSubAccntId(subExcAccntId);
            message = builderEx.build();
        }
        if (message != null) {
            builder.setObject(Any.pack((Message)message));
        }
        event.setObj((Object)builder.build());
        this.action(this.queryService, "263", event);
        POrderService.GetExecutionsResp resp = (POrderService.GetExecutionsResp)event.getObj(POrderService.GetExecutionsResp.class);
        this.checkStatus(resp.getStatus());
        int size = resp.getExecutionList().size();
        page.getResList().addAll(resp.getExecutionList());
        page.setTotalRow(resp.getPage().getTotalRow());
        if (size == 0 || page.getResList().size() == resp.getPage().getTotalRow()) {
            return;
        }
        if (size < page.getPageSize()) {
            page.setStartRow(page.getStartRow() + size);
            page.setPageSize(page.getPageSize() - size);
            this.queryDealsInTurn(page, marketGrp, extAccntId, subExcAccntId);
        }
    }
}

