/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.ExtPositionsHisReq;
import cms.tmx.api.ExtPositionsHisResp;
import cms.tmx.api.SubPositionsHisResp;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IPositionHisQueryApi;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PositionHisQueryApiImpl<T>
extends CallApi
implements IPositionHisQueryApi<T> {
    private static final Logger logger = LogManager.getLogger(PositionHisQueryApiImpl.class);
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine qs;

    @Override
    public ExtPositionsHisResp queryHisPositions(IHisQueryPageInfo<T> info) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PPositionService.GetExtPositionsHisReq.Builder builder = PPositionService.GetExtPositionsHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(info.getMarketGrp());
        builder.setBeginDate(info.getBeginDate());
        builder.setEndDate(info.getEndDate());
        builder.setFilterClose(info.isContainsClose() ? 1 : 0);
        String dimension = info.getDimension();
        if (dimension.equals("1")) {
            builder.addAllExtAccntId(info.getExtAccntIdList());
        } else if (dimension.equals("6")) {
            builder.addAllAccntGroupId(info.getAssetGrpIdList());
            builder.setQueryDimensionsValue(6);
        }
        builder.setSecurityId(info.getSecurityId());
        if ("REPO".equals(info.getPositionType())) {
            builder.setPositionType("REPO");
        }
        builder.setSettingTypeValue(1);
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<PPositionService.ExtPosition> list = new LinkedList<PPositionService.ExtPosition>();
        ExtPositionsHisResp extPositionsHisResp = new ExtPositionsHisResp();
        PPositionService.GetExtPositionsHisResp resp = null;
        info.initParam();
        do {
            info.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "352", event);
            resp = (PPositionService.GetExtPositionsHisResp)event.getObj(PPositionService.GetExtPositionsHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getPositionList());
        } while (info.hasNext(resp.getTotalCount()));
        extPositionsHisResp.setList(list);
        extPositionsHisResp.setCollect(resp.getCollect());
        return extPositionsHisResp;
    }

    @Override
    public ExtPositionsHisResp queryPositionForward(IPageInTurn<String, String, PPositionService.ExtPosition> page, ExtPositionsHisReq req) throws MException {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        logger.info("\u80a1\u4efd\u67e5\u8be2\u6309\u5e74\u7ed3\u8f6c\u67e5\u8be2");
        LinkedList<PPositionService.ExtPosition> list = new LinkedList<PPositionService.ExtPosition>();
        ExtPositionsHisResp extPositionsHisResp = new ExtPositionsHisResp();
        PPositionService.GetExtPositionsHisResp resp = null;
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PPositionService.GetExtPositionsHisReq.Builder builder = PPositionService.GetExtPositionsHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(req.getMarketGrp());
        builder.setBeginDate(req.getBeginDate());
        builder.setEndDate(req.getEndDate());
        builder.setFilterClose(1);
        builder.addAllExtAccntId(req.getExtAccntId());
        builder.setSettingTypeValue(1);
        builder.setPage(this.buildPage(page));
        event.setObj((Object)builder.build());
        this.action(this.qs, "352", event);
        resp = (PPositionService.GetExtPositionsHisResp)event.getObj(PPositionService.GetExtPositionsHisResp.class);
        this.checkStatus(resp.getStatus());
        list.addAll(resp.getPositionList());
        page.getResList().addAll(resp.getPositionList());
        page.setTotalRow(resp.getTotalCount());
        logger.info("\u80a1\u4efd\u67e5\u8be2\u6309\u5e74\u7ed3\u8f6c" + resp.getTotalCount() + "   " + resp.getPositionList().size());
        extPositionsHisResp.setList(list);
        extPositionsHisResp.setCollect(resp.getCollect());
        return extPositionsHisResp;
    }

    @Override
    public SubPositionsHisResp queryHisPosiPort(IHisQueryPageInfo<T> info) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PPositionService.GetSubPositionsHisReq.Builder builder = PPositionService.GetSubPositionsHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setFilterClose(info.isContainsClose() ? 1 : 0);
        builder.setMarketGrp(info.getMarketGrp());
        builder.setBeginDate(info.getBeginDate());
        builder.setEndDate(info.getEndDate());
        String dimension = info.getDimension();
        if (dimension.equals("7")) {
            builder.addAllPortfolioGroupId(info.getAssetsGrpIdList());
            builder.setQueryDimensionsValue(7);
        } else {
            builder.addAllSubAccntId(info.getSubAccntIdList());
        }
        builder.setSecurityId(info.getSecurityId());
        if ("REPO".equals(info.getPositionType())) {
            builder.setPositionType("REPO");
        }
        builder.setSettingTypeValue(1);
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<PPositionService.SubPosition> list = new LinkedList<PPositionService.SubPosition>();
        SubPositionsHisResp subPositionsHisResp = new SubPositionsHisResp();
        PPositionService.GetSubPositionsHisResp resp = null;
        info.initParam();
        do {
            info.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "355", event);
            resp = (PPositionService.GetSubPositionsHisResp)event.getObj(PPositionService.GetSubPositionsHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getPositionList());
        } while (info.hasNext(resp.getTotalCount()));
        subPositionsHisResp.setList(list);
        subPositionsHisResp.setCollect(resp.getCollect());
        return subPositionsHisResp;
    }
}

