/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IOrderHisQueryApi;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OrderNewHisQueryApiImpl<T>
extends CallApi
implements IOrderHisQueryApi<T> {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine qs;

    @Override
    public List<POrderService.SingleOrder> queryHisOrders(IHisQueryPageInfo<T> page, Integer i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        POrderService.GetSingleOrdersHisReq.Builder builder = POrderService.GetSingleOrdersHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDate(page.getBeginDate());
        builder.setEndDate(page.getEndDate());
        builder.setSecurityId(page.getSecurityId());
        String dimension = page.getDimension();
        if (dimension.equals("1")) {
            builder.addAllExtAccntId(page.getExtAccntIdList());
        } else if (dimension.equals("2")) {
            builder.addAllSubAccntId(page.getSubAccntIdList());
        } else if (dimension.equals("6")) {
            builder.addAllAccntGroupId(page.getAssetGrpIdList());
        } else if (dimension.equals("7")) {
            builder.addAllPortfolioGroupId(page.getAssetsGrpIdList());
        }
        builder.setQueryDimensionsValue(Integer.parseInt(dimension));
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<POrderService.SingleOrder> list = new LinkedList<POrderService.SingleOrder>();
        POrderService.GetSingleOrdersHisResp resp = null;
        page.initParam();
        do {
            page.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "350", event);
            resp = (POrderService.GetSingleOrdersHisResp)event.getObj(POrderService.GetSingleOrdersHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getOrderList());
            page.setMod(page.getMod() + pageBuilder.getPageSize() - resp.getPage().getPageSize());
            page.setStart(page.getStart() - pageBuilder.getPageSize() + resp.getPage().getPageSize());
        } while (page.hasNext(resp.getTotalCount()));
        return list;
    }

    @Override
    public List<POrderService.SingleOrder> queryHisInstructionOrders(List<String> accId, String dimension, String marketGrp, String resourceId, String reference, String beginDate, String endDate) throws MException {
        LinkedList<POrderService.SingleOrder> singleOrderList = new LinkedList<POrderService.SingleOrder>();
        PBase.Page defPage = this.baseApi.getDefPage();
        this.queryOrdersByPage(accId, resourceId, reference, dimension, marketGrp, singleOrderList, defPage, beginDate, endDate);
        return singleOrderList;
    }

    private void queryOrdersByPage(List<String> accId, String resourceId, String reference, String dimension, String marketGrp, List<POrderService.SingleOrder> singleOrderList, PBase.Page defPage, String beginDate, String endDate) throws MException {
        MEvent event = new MEvent();
        POrderService.GetSingleOrdersHisReq.Builder builder = POrderService.GetSingleOrdersHisReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setPage(defPage);
        builder.setMarketGrp(marketGrp);
        builder.setReference(reference);
        builder.setResourceId(resourceId);
        builder.setQueryDimensionsValue(Integer.parseInt(dimension));
        builder.setBeginDate(beginDate);
        builder.setEndDate(endDate);
        if (dimension.equals("1")) {
            builder.addAllExtAccntId(accId);
        } else if (dimension.equals("2")) {
            builder.addAllSubAccntId(accId);
        }
        event.setObj((Object)builder.build());
        this.action(this.qs, "350", event);
        POrderService.GetSingleOrdersHisResp resp = (POrderService.GetSingleOrdersHisResp)event.getObj(POrderService.GetSingleOrdersHisResp.class);
        this.checkStatus(resp.getStatus());
        singleOrderList.addAll(resp.getOrderList());
        if (resp.getPage().getPageSize() == 0) {
            return;
        }
        if (resp.getPage().getTotalRow() > defPage.getStartRow() + resp.getPage().getPageSize() - 1) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getStartRow() + resp.getPage().getPageSize());
            this.queryOrdersByPage(accId, resourceId, reference, dimension, marketGrp, singleOrderList, pageBuilder.build(), beginDate, endDate);
        }
    }

    @Override
    public List<POrderService.CrossOrder> queryEtfHisOrders(IHisQueryPageInfo<T> queryPage, Integer i) throws MException {
        PBase.OpUser opUser = this.baseApi.getOpUser();
        POrderService.GetCrossOrdersHisReq.Builder builder = POrderService.GetCrossOrdersHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(queryPage.getMarketGrp());
        builder.setBeginDate(queryPage.getBeginDate());
        builder.setEndDate(queryPage.getEndDate());
        builder.addAllExtAccntId(queryPage.getExtAccntIdList());
        builder.setSecurityId(queryPage.getSecurityId());
        builder.setQueryScope(queryPage.isSum() ? PField.QueryScope.QS_COLLECT : PField.QueryScope.QS_DETAILS);
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<POrderService.CrossOrder> list = new LinkedList<POrderService.CrossOrder>();
        POrderService.GetCrossOrdersHisResp resp = null;
        queryPage.initParam();
        do {
            queryPage.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.qs, "354", event);
            resp = (POrderService.GetCrossOrdersHisResp)event.getObj(POrderService.GetCrossOrdersHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getCrossOrderList());
        } while (queryPage.hasNext(resp.getPage().getTotalRow()));
        return list;
    }

    @Override
    public List<POrderService.SingleOrder> queryOneHisOrders(IHisQueryPageInfo<T> orderPage, String parentId) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        POrderService.GetSingleOrdersHisReq.Builder builder = POrderService.GetSingleOrdersHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(orderPage.getMarketGrp());
        builder.addAllExtAccntId(orderPage.getExtAccntIdList());
        builder.setBeginDate(orderPage.getBeginDate());
        builder.setEndDate(orderPage.getEndDate());
        builder.setParentId(parentId);
        builder.setQueryDimensionsValue(1);
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        orderPage.initParam();
        orderPage.updatePage(pageBuilder);
        builder.setPage(pageBuilder.build());
        event.setObj((Object)builder.build());
        this.action(this.qs, "350", event);
        POrderService.GetSingleOrdersHisResp resp = (POrderService.GetSingleOrdersHisResp)event.getObj(POrderService.GetSingleOrdersHisResp.class);
        this.checkStatus(resp.getStatus());
        orderPage.setTotalCount(resp.getTotalCount());
        return resp.getOrderList();
    }

    @Override
    public List<POrderService.SingleOrder> queryAlgoOrders(IHisQueryPageInfo<T> info) throws MException {
        PBase.OpUser opUser = this.baseApi.getOpUser();
        POrderService.GetSingleOrdersHisReq.Builder builder = POrderService.GetSingleOrdersHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(info.getMarketGrp());
        builder.setBeginDate(info.getBeginDate());
        builder.setEndDate(info.getEndDate());
        PComponent.ExecMode.Builder mode = PComponent.ExecMode.newBuilder();
        mode.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_ALGORITHM);
        mode.setEmName(info.getId());
        builder.setExecMode(mode);
        builder.setQueryDimensionsValue(4);
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setPageSize(150);
        page.setStartRow(1);
        LinkedList<POrderService.SingleOrder> list = new LinkedList<POrderService.SingleOrder>();
        POrderService.GetSingleOrdersHisResp resp = null;
        do {
            builder.setPage(page);
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.qs, "350", event);
            resp = (POrderService.GetSingleOrdersHisResp)event.getObj(POrderService.GetSingleOrdersHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getOrderList());
            page.setStartRow(resp.getPage().getStartRow() + resp.getPage().getPageSize());
        } while (resp.getPage().getTotalRow() >= page.getStartRow());
        return list;
    }
}

