/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.IOrderCancelReplaceApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OrderCancelReplaceApiImpl
extends CallApi
implements IOrderCancelReplaceApi {
    @Inject
    private TradeServiceDefines.OrderServiceDefine hs;
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private TradeServiceDefines.EtfTradeServiceDefine etf;

    @Override
    public void submit(PMessage.OrderCancelReplaceRequest orderCancelReplace) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)orderCancelReplace);
        this.action(this.hs, "212", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }

    @Override
    public synchronized int etfCancelReplaceOrder(String accntId, String secAccntId, double buyprice, int buynum, double sellprice, int sellnum, PComponent.Instrument instrument, POrderService.CrossOrder order, PComponent.ExecMode mode) throws MException {
        PComponent.SideCrossOrdMod.Builder sb1 = PComponent.SideCrossOrdMod.newBuilder();
        sb1.setSide(PField.Side.SIDE_BUY);
        sb1.setPrice(buyprice);
        sb1.setOrderQty((double)buynum);
        PComponent.SideCrossOrdMod s1 = sb1.build();
        PComponent.SideCrossOrdMod.Builder sb2 = PComponent.SideCrossOrdMod.newBuilder();
        sb2.setSide(PField.Side.SIDE_SELL);
        sb2.setPrice(sellprice);
        sb2.setOrderQty((double)sellnum);
        PComponent.SideCrossOrdMod s2 = sb2.build();
        LinkedList<PComponent.SideCrossOrdMod> modSitList = new LinkedList<PComponent.SideCrossOrdMod>();
        modSitList.add(s1);
        modSitList.add(s2);
        PMessage.CrossOrderCancelReplaceRequest.Builder ccsBuilder = PMessage.CrossOrderCancelReplaceRequest.newBuilder();
        ccsBuilder.setOpUser(this.bmi.getOpUser());
        ccsBuilder.setCrossId(order.getCrossId());
        ccsBuilder.setHostCrossId(order.getCrossId());
        ccsBuilder.setCrossType(order.getCrossType());
        ccsBuilder.addAllModSide(modSitList);
        ccsBuilder.setOrdType(PField.OrdType.ORD_TYPE_LIMIT);
        ccsBuilder.setInstrument(instrument);
        ccsBuilder.setExtAccntId(accntId);
        ccsBuilder.setExtSecAccntId(secAccntId);
        ccsBuilder.setExecMode(mode);
        PMessage.CrossOrderCancelReplaceRequest req = ccsBuilder.build();
        MEvent event = new MEvent();
        event.put((Object)"user_id", (Object)this.bmi.getOpUser().getUserId());
        event.setObj((Object)req);
        this.action(this.etf, "222", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getStatus();
    }
}

