/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.INewStockApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.utils.MarketUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NewStockApiImpl
extends CallApi
implements INewStockApi {
    @Inject
    private IBaseApi iba;
    @Inject
    private TradeServiceDefines.TransPosiServiceDefine define;
    private DateFormat format = new SimpleDateFormat("yyyyMMdd");

    @Override
    public PCashService.ApplyLimit getSubLine(String code, String market, String fundAcct, String secAcct) throws MException {
        if (market.equals("") || fundAcct.equals("") || secAcct.equals("")) {
            return null;
        }
        PCashService.GetApplyLimitReq.Builder builder = PCashService.GetApplyLimitReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setExtAccntId(fundAcct);
        builder.setExtSecAccntId(secAcct);
        PCashService.Instrument.Builder iBuilder = PCashService.Instrument.newBuilder();
        iBuilder.setMarket(market);
        iBuilder.setMarketGroup(MarketUtils.getMarketGroup((String)market));
        builder.setInstrument(iBuilder.build());
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.define, "031", event);
        PCashService.GetApplyLimitResp resp = (PCashService.GetApplyLimitResp)event.getObj(PCashService.GetApplyLimitResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getApplyLimitCount() > 0) {
            return resp.getApplyLimit(0);
        }
        return null;
    }

    @Override
    public List<PCashService.ApplyNumber> getResult(String fundAcct, String secAcct, String market) throws MException {
        PCashService.GetApplyNumberReq.Builder builder = PCashService.GetApplyNumberReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setExtAccntId(fundAcct);
        builder.setExtSecAccntId(secAcct);
        builder.setIndexDay(this.format.format(new Date()));
        builder.setQueryFlag(1);
        PCashService.Instrument.Builder ibuilder = PCashService.Instrument.newBuilder();
        ibuilder.setMarketGroup("CCS");
        ibuilder.setMarket(market);
        builder.setInstrument(ibuilder.build());
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.define, "032", event);
        PCashService.GetApplyNumberResp resp = (PCashService.GetApplyNumberResp)event.getObj(PCashService.GetApplyNumberResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getApplyNumerList();
    }

    @Override
    public List<PCashService.ApplyNumber> getNumber(String fundAcct, String secAcct, String market) throws MException {
        PCashService.GetApplyNumberReq.Builder builder = PCashService.GetApplyNumberReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setExtAccntId(fundAcct);
        builder.setExtSecAccntId(secAcct);
        builder.setIndexDay(this.format.format(new Date()));
        builder.setQueryFlag(0);
        PCashService.Instrument.Builder ibuilder = PCashService.Instrument.newBuilder();
        ibuilder.setMarketGroup("CCS");
        ibuilder.setMarket(market);
        builder.setInstrument(ibuilder.build());
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.define, "032", event);
        PCashService.GetApplyNumberResp resp = (PCashService.GetApplyNumberResp)event.getObj(PCashService.GetApplyNumberResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getApplyNumerList();
    }
}

