/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.PBase;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NewOrderSingleApiImpl
extends CallApi
implements INewOrderSingleApi {
    @Inject
    private TradeServiceDefines.OrderServiceDefine hs;
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private TradeServiceDefines.EtfTradeServiceDefine etf;
    @Inject
    private TradeServiceDefines.OrderServiceDefine single;

    @Override
    public String submit(PMessage.NewOrderSingle newOrder) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)newOrder);
        this.action(this.hs, "210", event);
        PBase.OpStatus cast = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        this.checkStatus(cast);
        return cast.getAttachment();
    }

    @Override
    public void batchSubmit(PMessage.NewOrderBatchRequest newOrder) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)newOrder);
        this.action(this.hs, "230", event);
        PMessage.NewOrderBatchResponse resp = (PMessage.NewOrderBatchResponse)PMessage.NewOrderBatchResponse.class.cast(event.getObj());
        this.checkStatus(resp.getStatus());
    }

    @Override
    public synchronized void etfNewOrder(String accntId, String secAccntId, double buyprice, int buynum, double sellprice, int sellnum, PComponent.Instrument instrument, PComponent.ExecMode mode) throws MException {
        PMessage.NewOrderCross.Builder data = PMessage.NewOrderCross.newBuilder();
        data.setOpUser(this.bmi.getOpUser());
        data.setInstrument(instrument);
        data.setOrdType(PField.OrdType.ORD_TYPE_LIMIT);
        data.setCrossType(1);
        data.setExtAccntId(accntId);
        data.setExtSecAccntId(secAccntId);
        data.setExecMode(mode);
        PComponent.SideCrossOrdMod.Builder sb1 = PComponent.SideCrossOrdMod.newBuilder();
        sb1.setSide(PField.Side.SIDE_BUY);
        sb1.setPrice(buyprice);
        sb1.setOrderQty((double)buynum);
        PComponent.SideCrossOrdMod s1 = sb1.build();
        data.addModSide(s1);
        PComponent.SideCrossOrdMod.Builder sb2 = PComponent.SideCrossOrdMod.newBuilder();
        sb2.setSide(PField.Side.SIDE_SELL);
        sb2.setPrice(sellprice);
        sb2.setOrderQty((double)sellnum);
        PComponent.SideCrossOrdMod s2 = sb2.build();
        data.addModSide(s2);
        PMessage.NewOrderCross req = data.build();
        MEvent event = new MEvent();
        event.put((Object)"user_id", (Object)this.bmi.getOpUser().getUserId());
        event.setObj((Object)req);
        this.action(this.etf, "220", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public synchronized void newFutureOrder(PMessage.NewOrderCross req) throws MException {
        MEvent event = new MEvent();
        event.put((Object)"user_id", (Object)this.bmi.getOpUser().getUserId());
        event.setObj((Object)req);
        this.action(this.etf, "220", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public synchronized void CancelReplaceFutureOrder(PMessage.CrossOrderCancelReplaceRequest req) throws MException {
        MEvent event = new MEvent();
        event.put((Object)"user_id", (Object)this.bmi.getOpUser().getUserId());
        event.setObj((Object)req);
        this.action(this.etf, "222", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public synchronized void newFutureOrder(PMessage.NewOrderSingle req) throws MException {
        MEvent event = new MEvent();
        event.put((Object)"user_id", (Object)this.bmi.getOpUser().getUserId());
        event.setObj((Object)req);
        this.action(this.single, "210", event);
        this.checkStatus(event.getObj());
    }
}

