/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IMonthReportHisQueryApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.trade.PCashService;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MonthReportHisQueryApiImpl<T>
extends CallApi
implements IMonthReportHisQueryApi<T> {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.TransPosiServiceDefine qs;

    @Override
    public List<PCashService.ExtMonthReport> queryHisMonthReport(String beginDate, String endDate, String marketGrp, List<String> productIdList, int reportType) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PCashService.GetExtMonthReportReq.Builder builder = PCashService.GetExtMonthReportReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        builder.setBeginDate(beginDate);
        builder.setEndDate(endDate);
        if (productIdList.size() > 0) {
            builder.addAllProductId(productIdList);
        }
        builder.setReportTypeValue(reportType);
        LinkedList<PCashService.ExtMonthReport> list = new LinkedList<PCashService.ExtMonthReport>();
        PCashService.GetExtMonthReportResp resp = null;
        PBase.Page.Builder pageBuilder = this.baseApi.getDefPage().toBuilder();
        boolean flag = false;
        do {
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "285", event);
            resp = (PCashService.GetExtMonthReportResp)event.getObj(PCashService.GetExtMonthReportResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getExtMonthReportList());
            boolean bl = flag = resp.getPage().getTotalRow() > pageBuilder.getStartRow() + resp.getPage().getPageSize() - 1;
            if (!flag) continue;
            pageBuilder.setStartRow(pageBuilder.getStartRow() + resp.getPage().getPageSize());
        } while (flag);
        return list;
    }

    @Override
    public List<PCashService.ExtMonthReportDate> queryHisMonthReportDate(String marketGrp, List<String> productIdList, int reportType) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PCashService.GetExtMonthReportDateReq.Builder builder = PCashService.GetExtMonthReportDateReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(marketGrp);
        if (productIdList.size() > 0) {
            builder.addAllProductId(productIdList);
        }
        builder.setReportTypeValue(reportType);
        LinkedList<PCashService.ExtMonthReportDate> list = new LinkedList<PCashService.ExtMonthReportDate>();
        PCashService.GetExtMonthReportDateResp resp = null;
        PBase.Page defPage = this.baseApi.getDefPage();
        PBase.Page.Builder pageBuilder = defPage.toBuilder();
        builder.setPage(pageBuilder.build());
        do {
            if (resp != null) {
                pageBuilder.setStartRow(pageBuilder.getStartRow() + resp.getPage().getPageSize());
                builder.setPage(pageBuilder.build());
            }
            event.setObj((Object)builder.build());
            this.action(this.qs, "287", event);
            resp = (PCashService.GetExtMonthReportDateResp)event.getObj(PCashService.GetExtMonthReportDateResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getExtMonthReportDateList());
            if (resp.getPage().getPageSize() != 0) continue;
            return list;
        } while (resp.getPage().getTotalRow() > pageBuilder.getStartRow() + resp.getPage().getPageSize() - 1);
        return list;
    }
}

