/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.strategy.PHedge;
import cms.tmx.define.IErrorMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class HedgeTaskApi
extends CallApi {
    private static final Logger logger = LogManager.getLogger(HedgeTaskApi.class);
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private TradeServiceDefines.HedgeTaskServiceDefine future;
    @Inject
    private IErrorMsg msg;

    public List<PHedge.HedgeTaskInfo> getTasks(PHedge.GetHedgeTasksReq.Builder req) throws MException {
        ArrayList<PHedge.HedgeTaskInfo> list = new ArrayList<PHedge.HedgeTaskInfo>();
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(100);
        int times = 0;
        PHedge.GetHedgeTasksResp resp = null;
        do {
            builder.setStartRow(times * builder.getPageSize() + 1);
            req.setPage(builder);
            req.setOpUser(this.bmi.getOpUser());
            MEvent event = new MEvent();
            event.setObj((Object)req.build());
            this.action(this.future, "000", event);
            resp = (PHedge.GetHedgeTasksResp)event.getObj(PHedge.GetHedgeTasksResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getTaskInfoList());
        } while (resp.getPage().getTotalRow() > ++times * builder.getPageSize());
        return list;
    }

    public Map<String, String> startStrategy(PHedge.StartHedgeTasksReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "002", event);
        PHedge.StartHedgeTasksResp resp = (PHedge.StartHedgeTasksResp)event.getObj(PHedge.StartHedgeTasksResp.class);
        this.checkStatus(resp.getStatus());
        HashMap<String, String> map = new HashMap<String, String>();
        for (PHedge.TaskStatus ctx : resp.getTaskStatusList()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getTaskId(), errorInfo);
        }
        return map;
    }

    public Map<String, String> stopStrategy(PHedge.StopHedgeTasksReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "003", event);
        PHedge.StopHedgeTasksResp resp = (PHedge.StopHedgeTasksResp)event.getObj(PHedge.StopHedgeTasksResp.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PHedge.TaskStatus ctx : resp.getTaskStatusList()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getTaskId(), errorInfo);
        }
        return map;
    }

    public void updateStrategy(PHedge.UpdateHedgeTaskReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "001", event);
        this.checkStatus(event.getObj());
    }
}

