/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.IFutureMarketMakingApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.define.IErrorMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class FutureMarketMakingApiImpl
extends CallApi
implements IFutureMarketMakingApi {
    private static final Logger logger = LogManager.getLogger(FutureMarketMakingApiImpl.class);
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private TradeServiceDefines.FutureStrategyServiceDefine future;
    @Inject
    private IErrorMsg msg;

    @Override
    public List<PStrategy.CrossOrder> getCrossOrder(PStrategy.GetCrossOrdersReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "009", event);
        PStrategy.GetCrossOrdersResp resp = (PStrategy.GetCrossOrdersResp)event.getObj(PStrategy.GetCrossOrdersResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getCrossOrderList();
    }

    @Override
    public List<PStrategy.SingleOrder> getSingleOrder(PStrategy.GetSingleOrdersReq req) throws MException {
        this.bmi.getOpUser();
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "010", event);
        PStrategy.GetSingleOrdersResp resp = (PStrategy.GetSingleOrdersResp)event.getObj(PStrategy.GetSingleOrdersResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getSingleOrderList();
    }

    @Override
    public List<PStrategy.ContextSettings> getStrategy(PStrategy.GetCtxSettingsReq.Builder req) throws MException {
        ArrayList<PStrategy.ContextSettings> list = new ArrayList<PStrategy.ContextSettings>();
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(100);
        long start = System.currentTimeMillis();
        int times = 0;
        PStrategy.GetCtxSettingsResp resp = null;
        do {
            builder.setStartRow(times * builder.getPageSize() + 1);
            req.setPage(builder);
            MEvent event = new MEvent();
            event.setObj((Object)req.build());
            this.action(this.future, "001", event);
            resp = (PStrategy.GetCtxSettingsResp)event.getObj(PStrategy.GetCtxSettingsResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getSettingsList());
        } while (resp.getPage().getTotalRow() > ++times * builder.getPageSize());
        logger.debug("\u8c03\u7528\u4e00\u6b21\u7b56\u7565\u67e5\u8be2\u63a5\u53e3\u6240\u6709\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        return list;
    }

    public static void main(String[] args) {
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(100);
        builder.setStartRow(1);
        PBase.Page.Builder builder2 = PBase.Page.newBuilder();
        builder2.setPageSize(1200);
        builder2.setStartRow(1);
        PStrategy.GetCtxSettingsReq.Builder req = PStrategy.GetCtxSettingsReq.newBuilder();
        req.setPage(builder);
        System.err.println();
        PStrategy.GetCtxSettingsReq tt = req.build();
        tt.toBuilder().setPage(builder2);
        System.err.println();
    }

    @Override
    public void addStrategy(PStrategy.NewCtxSettingsReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "003", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void updateStrategy(PStrategy.UpdateCtxSettingsReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "002", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void delStrategy(PStrategy.DeleteCtxSettingsReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "004", event);
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        this.checkStatus(status);
    }

    @Override
    public Map<String, String> startStrategy(PStrategy.StartContextReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "005", event);
        PStrategy.StartContextResp resp = (PStrategy.StartContextResp)event.getObj(PStrategy.StartContextResp.class);
        this.checkStatus(resp.getStatus());
        HashMap<String, String> map = new HashMap<String, String>();
        for (PStrategy.CtxStatus ctx : resp.getCtxStatusList()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getContextId(), errorInfo);
        }
        return map;
    }

    @Override
    public Map<String, String> stopStrategy(PStrategy.StopContextReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "006", event);
        PStrategy.StopContextResp resp = (PStrategy.StopContextResp)event.getObj(PStrategy.StopContextResp.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PStrategy.CtxStatus ctx : resp.getCtxStatusList()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getContextId(), errorInfo);
        }
        return map;
    }

    @Override
    public Map<String, String> pauseStrategy(PStrategy.PauseContextReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "008", event);
        PStrategy.PauseContextResp resp = (PStrategy.PauseContextResp)event.getObj(PStrategy.PauseContextResp.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PStrategy.CtxStatus ctx : resp.getCtxStatusList()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getContextId(), errorInfo);
        }
        return map;
    }

    @Override
    public Map<String, String> resumeStrategy(PStrategy.ResumeContextReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "007", event);
        PStrategy.ResumeContextResp resp = (PStrategy.ResumeContextResp)event.getObj(PStrategy.ResumeContextResp.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PStrategy.CtxStatus ctx : resp.getCtxStatusList()) {
            if (ctx.getStatus() == 1) continue;
            String errorInfo = this.msg.getMsg(ctx.getStatus());
            if (errorInfo.isEmpty()) {
                errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
            }
            map.put(ctx.getContextId(), errorInfo);
        }
        return map;
    }

    @Override
    public synchronized void hedge(PStrategy.UpdateSingleOrdersReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.future, "014", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }
}

