/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IDealHisQueryApi;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class DealHisQueryApiImpl<T>
extends CallApi
implements IDealHisQueryApi<T> {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine qs;

    @Override
    public List<POrderService.Execution> queryHisDeals(IHisQueryPageInfo<T> page, Integer i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        POrderService.GetExecutionsHisReq.Builder builder = POrderService.GetExecutionsHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDate(page.getBeginDate());
        builder.setEndDate(page.getEndDate());
        builder.setSecurityId(page.getSecurityId());
        String dimension = page.getDimension();
        if (dimension.equals("1")) {
            builder.addAllExtAccntId(page.getExtAccntIdList());
        } else if (dimension.equals("2")) {
            builder.addAllSubAccntId(page.getSubAccntIdList());
        } else if (dimension.equals("6")) {
            builder.addAllAccntGroupId(page.getAssetGrpIdList());
        } else if (dimension.equals("7")) {
            builder.addAllPortfolioGroupId(page.getAssetsGrpIdList());
        }
        builder.setQueryDimensionsValue(Integer.parseInt(dimension));
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<POrderService.Execution> list = new LinkedList<POrderService.Execution>();
        POrderService.GetExecutionsHisResp resp = null;
        page.initParam();
        do {
            page.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "351", event);
            resp = (POrderService.GetExecutionsHisResp)event.getObj(POrderService.GetExecutionsHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getExecutionList());
        } while (page.hasNext(resp.getTotalCount()));
        return list;
    }

    @Override
    public List<PAssetService.ExecutionsCollect> queryHisDealsSum(IHisQueryPageInfo<T> page, Integer i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PAssetService.GetExecutionsCollectReq.Builder builder = PAssetService.GetExecutionsCollectReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDate(page.getBeginDate());
        builder.setEndDate(page.getEndDate());
        builder.setSecurityId(page.getSecurityId());
        builder.setQuerySumDimensionsValue(page.isInverval() ? 1 : 0);
        String dimension = page.getDimension();
        if (dimension.equals("1")) {
            builder.addAllExtAccntId(page.getExtAccntIdList());
        } else if (dimension.equals("2")) {
            builder.addAllPortfolioId(page.getPortfolioIdList());
        } else if (dimension.equals("6")) {
            builder.addAllAccntGroupId(page.getAssetGrpIdList());
        } else if (dimension.equals("7")) {
            builder.addAllPortfolioGroupId(page.getAssetsGrpIdList());
        }
        builder.setQueryDimensionsValue(Integer.parseInt(dimension));
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<PAssetService.ExecutionsCollect> list = new LinkedList<PAssetService.ExecutionsCollect>();
        PAssetService.GetExecutionsCollectResp resp = null;
        page.initParam();
        do {
            page.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "353", event);
            resp = (PAssetService.GetExecutionsCollectResp)event.getObj(PAssetService.GetExecutionsCollectResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getExecutioncollectList());
        } while (page.hasNext(resp.getTotalCount()));
        return list;
    }

    @Override
    public List<POrderService.Execution> queryAlgoDeals(IHisQueryPageInfo<T> param) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        POrderService.GetExecutionsHisReq.Builder builder = POrderService.GetExecutionsHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(param.getMarketGrp());
        builder.setBeginDate(param.getBeginDate());
        builder.setEndDate(param.getEndDate());
        builder.setSecurityId(param.getSecurityId());
        PComponent.ExecMode.Builder mode = PComponent.ExecMode.newBuilder();
        mode.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_ALGORITHM);
        mode.setEmName(param.getId());
        builder.setExecMode(mode);
        builder.setQueryDimensionsValue(4);
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setPageSize(150);
        page.setStartRow(1);
        LinkedList<POrderService.Execution> list = new LinkedList<POrderService.Execution>();
        POrderService.GetExecutionsHisResp resp = null;
        do {
            builder.setPage(page);
            event.setObj((Object)builder.build());
            this.action(this.qs, "351", event);
            resp = (POrderService.GetExecutionsHisResp)event.getObj(POrderService.GetExecutionsHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getExecutionList());
            page.setStartRow(page.getStartRow() + page.getPageSize());
        } while (resp.getTotalCount() >= page.getStartRow());
        return list;
    }
}

