/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IDailyAvgQtyApi;
import cms.tmx.api.trade.info.IAvgQtyParam;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.proto.calc.PCalculator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DailyAvgQtyApiImpl
extends CallApi
implements IDailyAvgQtyApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.DailyAvgQtyServiceDefine dtsd;
    private static final int COUNT = 100;

    @Override
    public List<PCalculator.AvgTradeQty> query(IAvgQtyParam param) throws MException {
        PCalculator.GetAvgTradeQtyReq.Builder builder = PCalculator.GetAvgTradeQtyReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(param.getMarketGrp());
        builder.setTradingDayNum(param.getDayNum());
        builder.setWeightTypeValue(param.getWeightType());
        builder.setWeight(param.getWeight());
        PComponent.Instrument.Builder instrucment = PComponent.Instrument.newBuilder();
        LinkedList<PCalculator.AvgTradeQty> list = new LinkedList<PCalculator.AvgTradeQty>();
        List<IRefItem> items = param.getItems();
        int size = items.size();
        int start = 0;
        int end = 0;
        do {
            builder.clearInstrument();
            end = (end += 100) < size ? end : size;
            for (IRefItem item : items.subList(start, end)) {
                instrucment.setSecurityId(item.getCode());
                instrucment.setSymbol(item.getName());
                instrucment.setMarket(item.getMarket());
                instrucment.setSecurityType(item.getType());
                builder.addInstrument(instrucment);
            }
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.dtsd, "100", event);
            PCalculator.GetAvgTradeQtyResp resp = (PCalculator.GetAvgTradeQtyResp)event.getObj(PCalculator.GetAvgTradeQtyResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getAvgTradeQtyList());
        } while ((start = end) != size);
        return list;
    }
}

