/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IClearRecordHisQueryApi;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.trade.PCashService;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ClearRecordHisQueryApiImpl<T>
extends CallApi
implements IClearRecordHisQueryApi<T> {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.TransPosiServiceDefine qs;
    @Inject
    private TradeServiceDefines.ClearRecordDefine cr;

    @Override
    public List<PCashService.ClearRecord> queryHisRecords(IHisQueryPageInfo<T> page, Integer i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PCashService.GetClearRecordsReq.Builder builder = PCashService.GetClearRecordsReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDate(page.getBeginDate());
        builder.setEndDate(page.getEndDate());
        builder.setSecurityId(page.getSecurityId());
        if (page.getProductIdList().size() > 0) {
            builder.addAllProductId(page.getProductIdList());
        }
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<PCashService.ClearRecord> list = new LinkedList<PCashService.ClearRecord>();
        PCashService.GetClearRecordsResp resp = null;
        page.initParam();
        do {
            page.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "270", event);
            resp = (PCashService.GetClearRecordsResp)event.getObj(PCashService.GetClearRecordsResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getClearRecordList().isEmpty()) {
                page.setTotalCount(resp.getPage().getTotalRow());
                return list;
            }
            list.addAll(resp.getClearRecordList());
            page.setMod(page.getMod() + pageBuilder.getPageSize() - resp.getPage().getPageSize());
            page.setStart(page.getStart() - pageBuilder.getPageSize() + resp.getPage().getPageSize());
        } while (page.hasNext(resp.getPage().getTotalRow()));
        return list;
    }

    @Override
    public List<PCashService.SubClearRecord> querySubHisRecords(IHisQueryPageInfo<T> page, Integer i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PCashService.GetSubClearRecordsReq.Builder builder = PCashService.GetSubClearRecordsReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDate(page.getBeginDate());
        builder.setEndDate(page.getEndDate());
        builder.setSecurityId(page.getSecurityId());
        if (page.getPortfolioIdList().size() > 0) {
            builder.addAllPortfolioId(page.getPortfolioIdList());
        }
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<PCashService.SubClearRecord> list = new LinkedList<PCashService.SubClearRecord>();
        PCashService.GetSubClearRecordsResp resp = null;
        page.initParam();
        do {
            page.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "274", event);
            resp = (PCashService.GetSubClearRecordsResp)event.getObj(PCashService.GetSubClearRecordsResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getSubClearRecordList().isEmpty()) {
                page.setTotalCount(resp.getPage().getTotalRow());
                return list;
            }
            list.addAll(resp.getSubClearRecordList());
            page.setMod(page.getMod() + pageBuilder.getPageSize() - resp.getPage().getPageSize());
            page.setStart(page.getStart() - pageBuilder.getPageSize() + resp.getPage().getPageSize());
        } while (page.hasNext(resp.getPage().getTotalRow()));
        return list;
    }

    @Override
    public void updateClearRecord(List<PCashService.ClearRecord> clearRecordList) throws MException {
        PCashService.OutClearRecordResp resp = null;
        PCashService.OutClearRecordReq.Builder builder = PCashService.OutClearRecordReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.addAllClearRecord(clearRecordList);
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.cr, "501", event);
        resp = (PCashService.OutClearRecordResp)event.getObj(PCashService.OutClearRecordResp.class);
        this.checkStatus(resp.getStatus());
    }

    @Override
    public void updateSubClearRecord(List<PCashService.SubClearRecord> subClearRecordList) throws MException {
        PCashService.OutClearRecordResp resp = null;
        PCashService.OutClearRecordReq.Builder builder = PCashService.OutClearRecordReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.addAllSubClearRecord(subClearRecordList);
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.cr, "501", event);
        resp = (PCashService.OutClearRecordResp)event.getObj(PCashService.OutClearRecordResp.class);
        this.checkStatus(resp.getStatus());
    }
}

