/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CancelOrderApiImpl
extends CallApi
implements ICancelOrderApi {
    @Inject
    private TradeServiceDefines.OrderServiceDefine hs;
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private TradeServiceDefines.EtfTradeServiceDefine etf;

    @Override
    public void submit(PMessage.OrderCancelRequest orderCancel) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)orderCancel);
        this.action(this.hs, "211", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }

    @Override
    public synchronized int etfCancelOrder(String accntId, String secAccntId, int buynum, POrderService.CrossOrder order, PComponent.Instrument instrument) throws MException {
        PComponent.OrderQtyData.Builder builderData = PComponent.OrderQtyData.newBuilder();
        builderData.setOrderQty((double)buynum);
        PComponent.OrderQtyData qtyData = builderData.build();
        PComponent.SideCrossOrdCxl.Builder sb1 = PComponent.SideCrossOrdCxl.newBuilder();
        sb1.setSide(PField.Side.SIDE_BUY);
        sb1.setOrderQtyData(qtyData);
        PComponent.SideCrossOrdCxl s1 = sb1.build();
        PComponent.SideCrossOrdCxl.Builder sb2 = PComponent.SideCrossOrdCxl.newBuilder();
        sb2.setSide(PField.Side.SIDE_SELL);
        sb2.setOrderQtyData(qtyData);
        PComponent.SideCrossOrdCxl s2 = sb2.build();
        LinkedList<PComponent.SideCrossOrdCxl> cxlSitList = new LinkedList<PComponent.SideCrossOrdCxl>();
        cxlSitList.add(s1);
        cxlSitList.add(s2);
        PMessage.CrossOrderCancelRequest.Builder ccsBuilder = PMessage.CrossOrderCancelRequest.newBuilder();
        ccsBuilder.setOpUser(this.bmi.getOpUser());
        ccsBuilder.setCrossId(order.getCrossId());
        ccsBuilder.setHostCrossId(order.getCrossId());
        ccsBuilder.setCrossType(order.getCrossType());
        ccsBuilder.addAllCxlSide(cxlSitList);
        ccsBuilder.setInstrument(instrument);
        ccsBuilder.setExtAccntId(accntId);
        ccsBuilder.setExtSecAccntId(secAccntId);
        PMessage.CrossOrderCancelRequest req = ccsBuilder.build();
        MEvent event = new MEvent();
        event.put((Object)"user_id", (Object)this.bmi.getOpUser().getUserId());
        event.setObj((Object)req);
        this.action(this.etf, "221", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getStatus();
    }
}

