/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.IBusinessRefApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.trade.PMiscService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BusinessRefApiImpl
extends CallApi
implements IBusinessRefApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private MngServiceDefines.TradeCounterDefine tcd;
    private List<PMiscService.BusinessRefData> busiList = new LinkedList<PMiscService.BusinessRefData>();
    private List<String> idList = new ArrayList<String>();

    @Override
    public void addBusi(PMiscService.BusinessRefData build) throws MException {
        this.busiList.clear();
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMiscService.AddBusinessRefDataReq.Builder pBuilder = PMiscService.AddBusinessRefDataReq.newBuilder();
        this.busiList.add(build);
        pBuilder.setOpUser(opUser);
        pBuilder.addAllBusinessData(this.busiList);
        event.setObj((Object)pBuilder.build());
        this.action(this.tcd, "009", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PMiscService.BusinessRefData> getBusiList() throws MException {
        this.busiList.clear();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryBusiPage(defPage, i);
        return this.busiList;
    }

    private void queryBusiPage(PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PMiscService.GetBusinessRefDataReq.Builder pBuilder = PMiscService.GetBusinessRefDataReq.newBuilder();
        pBuilder.setOpUser(opUser);
        pBuilder.setPage(defPage);
        event.setObj((Object)pBuilder.build());
        this.action(this.tcd, "012", event);
        PMiscService.GetBusinessRefDataResp resp = (PMiscService.GetBusinessRefDataResp)event.getObj(PMiscService.GetBusinessRefDataResp.class);
        this.checkStatus(resp.getStatus());
        this.busiList.addAll(resp.getBusinessDataList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryBusiPage(pageBuilder.build(), i);
        }
    }

    @Override
    public void delBusi(PMiscService.BusinessRefData build) throws MException {
        this.idList.clear();
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        this.idList.add(build.getId());
        PMiscService.DeleteBusinessRefDataReq.Builder pBuilder = PMiscService.DeleteBusinessRefDataReq.newBuilder();
        pBuilder.setOpUser(opUser);
        pBuilder.addAllId(this.idList);
        event.setObj((Object)pBuilder.build());
        this.action(this.tcd, "010", event);
        this.checkStatus(event.getObj());
    }
}

