/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IBasketHisQueryApi;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BasketHisQueryApiImpl<T>
extends CallApi
implements IBasketHisQueryApi<T> {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine qs;

    @Override
    public List<POrderService.ListOrder> queryHisListOrders(IHisQueryPageInfo<T> page, Integer i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        POrderService.GetListOrdersHisReq.Builder builder = POrderService.GetListOrdersHisReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDate(page.getBeginDate());
        builder.setEndDate(page.getEndDate());
        String dimension = page.getDimension();
        if (dimension.equals("1")) {
            builder.addAllExtAccntId(page.getExtAccntIdList());
        } else if (dimension.equals("2")) {
            builder.addAllSubAccntId(page.getSubAccntIdList());
        }
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<POrderService.ListOrder> list = new LinkedList<POrderService.ListOrder>();
        POrderService.GetListOrdersHisResp resp = null;
        page.initParam();
        do {
            page.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.qs, "356", event);
            resp = (POrderService.GetListOrdersHisResp)event.getObj(POrderService.GetListOrdersHisResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getOrdersList());
        } while (page.hasNext(resp.getPage().getTotalRow()));
        return list;
    }

    @Override
    public List<POrderService.ListOrderLeg> queryHisLegOrders(String listId, String ordDate, Set<String> legIdList) throws MException {
        LinkedList<POrderService.ListOrderLeg> listOrderLegsList = new LinkedList<POrderService.ListOrderLeg>();
        int i = 0;
        PBase.Page defPage = this.baseApi.getDefPage();
        this.queryHisLegOrdersByPage(listOrderLegsList, defPage, i, listId, ordDate, legIdList);
        return listOrderLegsList;
    }

    private void queryHisLegOrdersByPage(List<POrderService.ListOrderLeg> listOrderLegsList, PBase.Page defPage, int index, String listId, String ordDate, Set<String> legIdList) throws MException {
        MEvent event = new MEvent();
        POrderService.GetListOrdersHisReq.Builder builder = POrderService.GetListOrdersHisReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp("CCS");
        builder.setListId(listId);
        builder.setPage(defPage);
        builder.setOrdDate(ordDate);
        if (legIdList != null && !legIdList.isEmpty()) {
            builder.addAllLegId(legIdList);
        }
        event.setObj((Object)builder.build());
        this.action(this.qs, "356", event);
        POrderService.GetListOrdersHisResp resp = (POrderService.GetListOrdersHisResp)event.getObj(POrderService.GetListOrdersHisResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getOrdersList().size() > 0) {
            listOrderLegsList.addAll(((POrderService.ListOrder)resp.getOrdersList().get(0)).getLegsList());
        }
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++index) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * index + 1);
            this.queryHisLegOrdersByPage(listOrderLegsList, pageBuilder.build(), index, listId, ordDate, legIdList);
        }
    }
}

