/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IAlgoParam;
import cms.tmx.api.trade.IAlgorithmTradeApi;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.strategy.PFollowUp;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class AlgorithmTradeApiImpl
extends CallApi
implements IAlgorithmTradeApi {
    @Inject
    private IBaseApi iba;
    @Inject
    private TradeServiceDefines.AlgorithmServiceDefine define;
    @Inject
    private TradeServiceDefines.AlgoFollowUpServiceDefine fDefine;
    private static final Logger logger = LogManager.getLogger(AlgorithmTradeApiImpl.class);

    @Override
    public List<PAlgorithmTrade.AlgorithmInfo> getAlgoList() throws MException {
        MEvent event = new MEvent();
        PAlgorithmTrade.AlgoLists.Builder builder = PAlgorithmTrade.AlgoLists.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        event.setObj((Object)builder.build());
        this.action(this.define, "040", event);
        PAlgorithmTrade.AlgoListsResp resp = (PAlgorithmTrade.AlgoListsResp)event.getObj(PAlgorithmTrade.AlgoListsResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getAlgoInfoList();
    }

    @Override
    public List<PAlgorithmTrade.BaseOrderInfomation> getBaseOrderList(String begin, String end, List<String> listFund, boolean isPortfolio) throws MException {
        PAlgorithmTrade.AlgoBaseOrderInfos.Builder builder = PAlgorithmTrade.AlgoBaseOrderInfos.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setStartDate(begin);
        builder.setEndDate(end);
        if (isPortfolio) {
            builder.addAllSubAccntId(listFund);
            builder.setQueryDimensions(PAlgorithmTrade.QueryDimensions.QD_PORTFOLIO);
        } else {
            builder.addAllExtAccntId(listFund);
            builder.setQueryDimensions(PAlgorithmTrade.QueryDimensions.QD_EXT_ACCNT);
        }
        PBase.Pager.Builder pagerBuilder = PBase.Pager.newBuilder();
        pagerBuilder.setStartRow(0);
        pagerBuilder.setPageSize(Integer.MAX_VALUE);
        String index = "1";
        PAlgorithmTrade.AlgoBaseOrderInfosResp resp = null;
        LinkedList<PAlgorithmTrade.BaseOrderInfomation> list = new LinkedList<PAlgorithmTrade.BaseOrderInfomation>();
        do {
            pagerBuilder.setNextId(index);
            builder.setPager(pagerBuilder.build());
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.define, "043", event);
            resp = (PAlgorithmTrade.AlgoBaseOrderInfosResp)event.takeObj(PAlgorithmTrade.AlgoBaseOrderInfosResp.class);
            this.checkStatus(resp.getOpStatus());
            index = resp.getPagination().getNextId();
            list.addAll(resp.getBaseOrdeList());
        } while (resp != null && resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public PAlgorithmTrade.BaseOrderInfomation getOrderDetails(int type, String orderId) throws MException {
        PAlgorithmTrade.AlgoBaseOrderInfos.Builder builder = PAlgorithmTrade.AlgoBaseOrderInfos.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setAlgoTypeValue(type);
        builder.setAlgoSysOrderId(orderId);
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.define, "043", event);
        PAlgorithmTrade.AlgoBaseOrderInfosResp resp = (PAlgorithmTrade.AlgoBaseOrderInfosResp)event.takeObj(PAlgorithmTrade.AlgoBaseOrderInfosResp.class);
        this.checkStatus(resp.getOpStatus());
        List list = resp.getBaseOrdeList();
        if (list.size() > 0) {
            return (PAlgorithmTrade.BaseOrderInfomation)list.get(0);
        }
        return null;
    }

    @Override
    public String submit(IAlgoParam algo) throws MException {
        PBase.OpUser.Builder opUser;
        PAlgorithmTrade.AlgoBaseOrderEntrust.Builder builder = PAlgorithmTrade.AlgoBaseOrderEntrust.newBuilder();
        opUser.setPi(StringUtils.isEmpty((String)(opUser = PBase.OpUser.newBuilder((PBase.OpUser)this.iba.getOpUser())).getPi()) ? "" : opUser.getPi().replaceAll(",", "#"));
        opUser.setText(opUser.getText().replace("\"", "\\\""));
        builder.setOpUser(opUser.build());
        builder.setExtAccntId(algo.getFundAccId());
        builder.setExtSecAccntId(algo.getSecAccId());
        String portfolio = algo.getPortfolio();
        if (portfolio != null) {
            builder.setPortfolioId(portfolio);
            builder.setSubAccntId(algo.getSubFundId());
            builder.setSubSecAccntId(algo.getSubSecId());
        }
        PAlgorithmTrade.Instrument.Builder instrument = PAlgorithmTrade.Instrument.newBuilder();
        instrument.setSecurityId(algo.getCode());
        instrument.setSymbol(algo.getName());
        instrument.setMarket(algo.getMarket());
        instrument.setSecurityType(algo.getType());
        instrument.setApplId(algo.getType().equals("REPO") ? "110" : "010");
        builder.setInstrument(instrument.build());
        if (algo.getType().equals("REPO")) {
            builder.setSide(algo.isBuy() ? PAlgorithmTrade.Side.SIDE_BORROW : PAlgorithmTrade.Side.SIDE_LEND);
        } else {
            builder.setSide(algo.isBuy() ? PAlgorithmTrade.Side.SIDE_BUY : PAlgorithmTrade.Side.SIDE_SELL);
        }
        builder.setOrderQty(algo.getCount());
        builder.setAlgorithmTypeValue(algo.getAlgoType());
        builder.setResourceId(algo.getResourceId());
        builder.setReference(algo.getReference());
        builder.setOrderQtyCapacity((double)algo.getCount());
        Any any = this.pack(algo);
        if (any != null) {
            builder.setObject(any);
        }
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.define, "041", event);
        PAlgorithmTrade.AlgoBaseOrderEntrustResp resp = (PAlgorithmTrade.AlgoBaseOrderEntrustResp)event.getObj(PAlgorithmTrade.AlgoBaseOrderEntrustResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getAlgoSysOrderId();
    }

    @Override
    public void update(IAlgoParam algo) throws MException {
        PBase.OpUser.Builder opUser;
        PAlgorithmTrade.AlgoBaseOrderCancelReplaceRequest.Builder builder = PAlgorithmTrade.AlgoBaseOrderCancelReplaceRequest.newBuilder();
        opUser.setPi(StringUtils.isEmpty((String)(opUser = PBase.OpUser.newBuilder((PBase.OpUser)this.iba.getOpUser())).getPi()) ? "" : opUser.getPi().replaceAll(",", "#"));
        opUser.setText(opUser.getText().replace("\"", "\\\""));
        builder.setOpUser(opUser.build());
        builder.setExtAccntId(algo.getFundAccId());
        builder.setExtSecAccntId(algo.getSecAccId());
        String portfolio = algo.getPortfolio();
        if (portfolio != null) {
            builder.setPortfolioId(portfolio);
            builder.setSubAccntId(algo.getSubFundId());
            builder.setSubSecAccntId(algo.getSubSecId());
        }
        PAlgorithmTrade.Instrument.Builder instrument = PAlgorithmTrade.Instrument.newBuilder();
        instrument.setSecurityId(algo.getCode());
        instrument.setSymbol(algo.getName());
        instrument.setMarket(algo.getMarket());
        instrument.setSecurityType(algo.getType());
        instrument.setApplId(algo.getType().equals("REPO") ? "110" : "010");
        builder.setInstrument(instrument.build());
        if (algo.getType().equals("REPO")) {
            builder.setSide(algo.isBuy() ? PAlgorithmTrade.Side.SIDE_BORROW : PAlgorithmTrade.Side.SIDE_LEND);
        } else {
            builder.setSide(algo.isBuy() ? PAlgorithmTrade.Side.SIDE_BUY : PAlgorithmTrade.Side.SIDE_SELL);
        }
        builder.setOrderQty(algo.getCount());
        builder.setAlgoTypeValue(algo.getAlgoType());
        builder.setResourceId(algo.getResourceId());
        builder.setReference(algo.getReference());
        builder.setOrderQtyCapacity((double)algo.getCount());
        builder.setOrigAlgoSysOrderId(algo.getSysId());
        Any any = this.pack(algo);
        if (any != null) {
            builder.setObject(any);
        }
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.define, "044", event);
        PAlgorithmTrade.AlgoBaseOrderCancelReplaceResp resp = (PAlgorithmTrade.AlgoBaseOrderCancelReplaceResp)event.getObj(PAlgorithmTrade.AlgoBaseOrderCancelReplaceResp.class);
        this.checkStatus(resp.getOpStatus());
    }

    @Override
    public Any pack(IAlgoParam algo) {
        switch (algo.getAlgoType()) {
            case 7: {
                PAlgorithmTrade.BlockTradingParam.Builder block = PAlgorithmTrade.BlockTradingParam.newBuilder();
                block.setPriceUpperLimit(algo.getPriceUp());
                block.setPriceLowerLimit(algo.getPriceLow());
                block.setOrderDepthValue(algo.getDepth());
                block.setTimeSlice(algo.getSlice());
                return Any.pack((Message)block.build());
            }
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                PAlgorithmTrade.WapAlgoParam.Builder wap = PAlgorithmTrade.WapAlgoParam.newBuilder();
                wap.setStartHour(algo.getStartHour());
                wap.setStartMinute(algo.getStartMinute());
                wap.setEndHour(algo.getEndHour());
                wap.setEndMinute(algo.getEndMinute());
                wap.setAlgoBehaviorLevelValue(algo.getAggress());
                wap.setTimeSliceCount(algo.getSlice());
                return Any.pack((Message)wap.build());
            }
            case 10: 
            case 11: {
                PAlgorithmTrade.EnhancedLiquidityParam.Builder liquidity = PAlgorithmTrade.EnhancedLiquidityParam.newBuilder();
                liquidity.setMostPrice(algo.getPriceMost());
                liquidity.setCalcBasePricePercent(algo.getPercentRise());
                liquidity.setOrderDepthValue(algo.getDepth());
                liquidity.setOrderQtyPercent(algo.getPercentDepth());
                liquidity.setWithdrawInterval(algo.getDelay());
                liquidity.setBasePriceTypeValue(algo.getBasePrice());
                return Any.pack((Message)liquidity.build());
            }
            case 12: 
            case 13: 
            case 19: 
            case 20: {
                PAlgorithmTrade.HighLowLimitWapParam.Builder limit = PAlgorithmTrade.HighLowLimitWapParam.newBuilder();
                limit.setPriceUpperLimit(algo.getPriceUp());
                limit.setPriceLowerLimit(algo.getPriceLow());
                limit.setStartHour(algo.getStartHour());
                limit.setStartMinute(algo.getStartMinute());
                limit.setEndHour(algo.getEndHour());
                limit.setEndMinute(algo.getEndMinute());
                limit.setAlgoBehaviorLevelValue(algo.getAggress());
                limit.setTimeSliceCount(algo.getSlice());
                return Any.pack((Message)limit.build());
            }
        }
        return null;
    }

    @Override
    public void cancel(PAlgorithmTrade.AlgoBaseOrderCancel order) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)order);
        this.action(this.define, "042", event);
        PAlgorithmTrade.AlgoBaseOrderCancleResp resp = (PAlgorithmTrade.AlgoBaseOrderCancleResp)event.getObj(PAlgorithmTrade.AlgoBaseOrderCancleResp.class);
        this.checkStatus(resp.getOpStatus());
    }

    @Override
    public List<PAlgorithmTrade.BaseOrderInfomation> queryHisAlgo(IHisQueryPageInfo<?> param) throws MException {
        PAlgorithmTrade.AlgoBaseOrderInfos.Builder builder = PAlgorithmTrade.AlgoBaseOrderInfos.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setStartDate(param.getBeginDate());
        builder.setEndDate(param.getEndDate());
        builder.setSecurityId(param.getSecurityId());
        if (param.getDimension().equals("1")) {
            builder.addAllExtAccntId(param.getExtAccntIdList());
            builder.setQueryDimensions(PAlgorithmTrade.QueryDimensions.QD_EXT_ACCNT);
        } else {
            builder.addAllSubAccntId(param.getSubAccntIdList());
            builder.setQueryDimensions(PAlgorithmTrade.QueryDimensions.QD_PORTFOLIO);
        }
        PBase.Pager.Builder pagerBuilder = PBase.Pager.newBuilder();
        PAlgorithmTrade.AlgoBaseOrderInfosResp resp = null;
        LinkedList<PAlgorithmTrade.BaseOrderInfomation> list = new LinkedList<PAlgorithmTrade.BaseOrderInfomation>();
        param.initParam();
        do {
            param.updatePager(pagerBuilder);
            builder.setPager(pagerBuilder.build());
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            logger.info("\u67e5\u8be2\u5386\u53f2\u7b97\u6cd5" + builder.build());
            this.action(this.define, "043", event);
            resp = (PAlgorithmTrade.AlgoBaseOrderInfosResp)event.takeObj(PAlgorithmTrade.AlgoBaseOrderInfosResp.class);
            logger.info("\u67e5\u8be2\u5386\u53f2\u7b97\u6cd5\u54cd\u5e94" + resp);
            this.checkStatus(resp.getOpStatus());
            list.addAll(resp.getBaseOrdeList());
        } while (param.hasNext(resp.getPagination().getTotalRows()) && resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public String submit(List<IAlgoParam> algos, int totalNum) throws MException {
        if (algos.isEmpty()) {
            return "";
        }
        IAlgoParam algo = algos.get(0);
        PStrategy.BaseOrderNewReq.Builder builder = PStrategy.BaseOrderNewReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        PComponent.Instrument.Builder instrument = PComponent.Instrument.newBuilder();
        instrument.setSecurityId(algo.getCode());
        instrument.setSymbol(algo.getName());
        instrument.setMarket(algo.getMarket());
        instrument.setSecurityType(algo.getType());
        instrument.setApplId(algo.getType().equals("REPO") ? "110" : "010");
        builder.setInstrument(instrument.build());
        if (algo.getType().equals("REPO")) {
            builder.setSide(algo.isBuy() ? PField.Side.SIDE_BORROW : PField.Side.SIDE_LEND);
        } else {
            builder.setSide(algo.isBuy() ? PField.Side.SIDE_BUY : PField.Side.SIDE_SELL);
        }
        builder.setOrderQty(totalNum);
        builder.setAlgorithmTypeValue(algo.getAlgoType());
        builder.setExecModeType(PField.ExecModeType.EXEC_MODE_TYPE_ALGOORDER);
        PFollowUp.FollowUpParam.Builder paramBuild = PFollowUp.FollowUpParam.newBuilder();
        paramBuild.setPriceLimit(algo.getPriceMost());
        paramBuild.setRefPriceTypeValue(algo.getBasePrice());
        paramBuild.setPriceAdjustTypeValue(algo.getFloatWay());
        if (algo.getFloatWay() == 1) {
            paramBuild.setPriceAdjustRate(algo.getFloatPercent());
        } else if (algo.getFloatWay() == 2) {
            paramBuild.setPriceAdjustValue(algo.getFloatNum());
        }
        paramBuild.setQtyAdjustTypeValue(algo.getDiskWay());
        if (algo.getDiskWay() == 2) {
            paramBuild.setQtyAdjustRate(algo.getDiskPercent());
        } else if (algo.getDiskWay() == 1) {
            paramBuild.setQtyAdjustValue(algo.getDiskNum());
        }
        paramBuild.setCancelTimeout(algo.getDelay());
        HashMap map = new HashMap();
        for (IAlgoParam item : algos) {
            if (map.get(item.getFundAccId()) == null) {
                LinkedList<IAlgoParam> list = new LinkedList<IAlgoParam>();
                list.add(item);
                map.put(item.getFundAccId(), list);
                continue;
            }
            ((List)map.get(item.getFundAccId())).add(item);
        }
        for (String accntId : map.keySet()) {
            PFollowUp.FundAccountSetting.Builder fb = PFollowUp.FundAccountSetting.newBuilder();
            fb.setExtFundAccntId(accntId);
            for (IAlgoParam item : (List)map.get(accntId)) {
                PFollowUp.SecAccountSetting.Builder secb = PFollowUp.SecAccountSetting.newBuilder();
                secb.setExtSecAccntId(item.getSecAccId());
                secb.setQty(item.getCount());
                fb.addSecAccountSettings(secb.build());
            }
            paramBuild.addFundAccountSettings(fb.build());
        }
        Any any = Any.pack((Message)paramBuild.build());
        if (any != null) {
            builder.setObject(any);
        }
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.fDefine, "011", event);
        PStrategy.BaseOrderNewResp resp = (PStrategy.BaseOrderNewResp)event.getObj(PStrategy.BaseOrderNewResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getSysOrderId();
    }

    @Override
    public List<PStrategy.BaseOrderInfo> getBaseOrderList(String begin, String end, List<String> listFund) throws MException {
        PStrategy.BaseOrderQueryReq.Builder builder = PStrategy.BaseOrderQueryReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setStartDate(begin);
        builder.setEndDate(end);
        builder.addAllExtAccntId(listFund);
        builder.setAlgorithmTypeValue(18);
        builder.setExecModeType(PField.ExecModeType.EXEC_MODE_TYPE_ALGOORDER);
        PBase.Pager.Builder pagerBuilder = PBase.Pager.newBuilder();
        pagerBuilder.setStartRow(0);
        pagerBuilder.setPageSize(Integer.MAX_VALUE);
        String index = "1";
        PStrategy.BaseOrderQueryResp resp = null;
        LinkedList<PStrategy.BaseOrderInfo> list = new LinkedList<PStrategy.BaseOrderInfo>();
        do {
            pagerBuilder.setNextId(index);
            builder.setPager(pagerBuilder.build());
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.fDefine, "013", event);
            resp = (PStrategy.BaseOrderQueryResp)event.takeObj(PStrategy.BaseOrderQueryResp.class);
            this.checkStatus(resp.getOpStatus());
            index = resp.getPagination().getNextId();
            list.addAll(resp.getBaseOrderList());
        } while (resp != null && resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public PStrategy.BaseOrderInfo getFollowUpOrderDetails(int type, String orderId) throws MException {
        PStrategy.BaseOrderQueryReq.Builder builder = PStrategy.BaseOrderQueryReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setAlgorithmTypeValue(type);
        builder.setSysOrderId(orderId);
        builder.setExecModeType(PField.ExecModeType.EXEC_MODE_TYPE_ALGOORDER);
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.fDefine, "013", event);
        PStrategy.BaseOrderQueryResp resp = (PStrategy.BaseOrderQueryResp)event.takeObj(PStrategy.BaseOrderQueryResp.class);
        this.checkStatus(resp.getOpStatus());
        List list = resp.getBaseOrderList();
        if (list.size() > 0) {
            return (PStrategy.BaseOrderInfo)list.get(0);
        }
        return null;
    }

    @Override
    public void cancel(PStrategy.BaseOrderCancelReq order) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)order);
        this.action(this.fDefine, "012", event);
        PStrategy.BaseOrderCancelResp resp = (PStrategy.BaseOrderCancelResp)event.getObj(PStrategy.BaseOrderCancelResp.class);
        this.checkStatus(resp.getOpStatus());
    }
}

