/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.trade.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.trade.IAlgoMiseTradeApi;
import cms.tmx.api.trade.info.MiseRequset;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class AlgoMiseTradeApiImpl
extends CallApi
implements IAlgoMiseTradeApi {
    private static final Logger logger = LogManager.getLogger(AlgoMiseTradeApiImpl.class);
    @Inject
    private TradeServiceDefines.AlgoPosiAdjServiceDefine adj;
    private Gson gson = new Gson();

    @Override
    public MEvent queryMise(String accntId, String startTime, String endTime, String orderIndex) throws MException {
        return this.queryAlgoStrategy(accntId, startTime, endTime, orderIndex, "");
    }

    @Override
    public MEvent queryMiseDetails(String accntId, String startTime, String endTime, String orderIndex, String algoOrderId) throws MException {
        return this.queryAlgoStrategy(accntId, startTime, endTime, orderIndex, algoOrderId);
    }

    private MEvent queryAlgoStrategy(String accntId, String startTime, String endTime, String orderIndex, String algoOrderId) throws MException {
        MEvent event = new MEvent();
        JsonObject obj = new JsonObject();
        obj.addProperty("biz_acct", accntId);
        if (!algoOrderId.isEmpty()) {
            obj.addProperty("algo_order_id", algoOrderId);
            obj.addProperty("is_summary", "0");
        } else {
            obj.addProperty("is_summary", "1");
        }
        if (!startTime.isEmpty()) {
            obj.addProperty("start_date", startTime);
        }
        if (!endTime.isEmpty()) {
            obj.addProperty("end_date", endTime);
        }
        if (!orderIndex.isEmpty()) {
            obj.addProperty("algo_order_id_index", orderIndex);
        }
        event.setObj((Object)obj.toString());
        event.put((Object)"parse.type", (Object)"mise.json");
        logger.info("mise\u5386\u53f2\u67e5\u8be2 " + obj.toString());
        this.action(this.adj, "503", event);
        MEvent resp = (MEvent)event.getObj();
        String code = (String)resp.get((Object)"ret_code");
        logger.info("mise\u5386\u53f2\u67e5\u8be2\u54cd\u5e94 " + code);
        if (!"0".equals(code)) {
            String reason = (String)resp.get((Object)"ret_msg");
            MException e = new MException(700503, reason);
            throw e;
        }
        return resp;
    }

    @Override
    public MEvent miseOrder(JsonObject json) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)json.toString());
        event.put((Object)"parse.type", (Object)"mise.json");
        this.action(this.adj, "500", event);
        MEvent resp = (MEvent)event.getObj();
        String code = (String)resp.get((Object)"ret_code");
        if (!"0".equals(code)) {
            String reason = (String)resp.get((Object)"ret_msg");
            MException e = new MException(700500, reason);
            throw e;
        }
        return resp;
    }

    @Override
    public MEvent miseOrder(MiseRequset request) throws MException {
        MEvent event = new MEvent();
        String body = this.gson.toJson((Object)request);
        event.setObj((Object)body);
        event.put((Object)"parse.type", (Object)"mise.json");
        logger.info("mise\u7b97\u6cd5\u4e0b\u5355\u53c2\u6570\uff1a" + body);
        this.action(this.adj, "500", event);
        MEvent resp = (MEvent)event.getObj();
        String code = (String)resp.get((Object)"ret_code");
        if (!"0".equals(code)) {
            String reason = (String)resp.get((Object)"ret_msg");
            MException e = new MException(700500, reason);
            throw e;
        }
        return resp;
    }

    @Override
    public MEvent miseCancelOrder(JsonObject json) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)json.toString());
        event.put((Object)"parse.type", (Object)"mise.json");
        this.action(this.adj, "502", event);
        MEvent resp = (MEvent)event.getObj();
        String code = (String)resp.get((Object)"ret_code");
        if (!"0".equals(code)) {
            String reason = (String)resp.get((Object)"ret_msg");
            MException e = new MException(700502, reason);
            throw e;
        }
        return resp;
    }
}

