/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.news.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.NewsServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.news.INewsApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.refdata.PRefDataService;
import com.google.protobuf.ByteString;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NewsImpl
extends CallApi
implements INewsApi {
    private String newsId = "";
    private static final String FIN = "FIN";
    private static final Logger logger = LogManager.getLogger(NewsImpl.class);
    @Inject
    private NewsServiceDefines.NewsServiceDefine nsd;
    @Inject
    private IBaseApi iba;

    @Override
    public List<PRefDataService.NewsList> getNewsTypes() {
        PRefDataService.NewsRequest.Builder builder = PRefDataService.NewsRequest.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setNewsType(FIN);
        builder.setNewsFuncType(0);
        PRefDataService.NewsRequest req = builder.build();
        MEvent event = new MEvent();
        event.setObj((Object)req);
        try {
            this.action(this.nsd, "250", event);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        PRefDataService.News news = (PRefDataService.News)event.getObj(PRefDataService.News.class);
        try {
            this.checkStatus(news.getOpStatus());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return news.getNewsListList();
    }

    @Override
    public synchronized List<PRefDataService.NewsDetail> queryNewsList(int id, String name) {
        PRefDataService.NewsList.Builder newsList = PRefDataService.NewsList.newBuilder();
        newsList.setId(id);
        newsList.setNewsStr(ByteString.copyFrom((byte[])name.getBytes()));
        PBase.Pager.Builder pager = PBase.Pager.newBuilder();
        pager.setPageSize(200);
        pager.setStartRow(1);
        pager.setNextId("1");
        PRefDataService.NewsRequest.Builder builder = PRefDataService.NewsRequest.newBuilder();
        MEvent event = new MEvent();
        builder.setOpUser(this.iba.getOpUser());
        builder.setNewsType(FIN);
        builder.setNewsFuncType(1);
        builder.addNewsList(newsList);
        builder.setPage(pager);
        PRefDataService.NewsRequest req = builder.build();
        event.setObj((Object)req);
        try {
            this.action(this.nsd, "250", event);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        PRefDataService.News news = (PRefDataService.News)event.getObj(PRefDataService.News.class);
        try {
            this.checkStatus(news.getOpStatus());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return news.getNewsDetailList();
    }

    @Override
    public List<PRefDataService.NewsDetail> getNewsDetail(String id) {
        PRefDataService.NewsRequest.Builder builder = PRefDataService.NewsRequest.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setNewsType(FIN);
        builder.setNewsFuncType(2);
        PRefDataService.NewsDetail.Builder builderDetail = PRefDataService.NewsDetail.newBuilder();
        builderDetail.setId(id);
        builder.addNewsDetail(builderDetail.build());
        PRefDataService.NewsRequest req = builder.build();
        MEvent event = new MEvent();
        event.setObj((Object)req);
        try {
            this.action(this.nsd, "250", event);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        PRefDataService.News news = (PRefDataService.News)event.getObj(PRefDataService.News.class);
        try {
            this.checkStatus(news.getOpStatus());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return news.getNewsDetailList();
    }

    public void setSelectedNews(String id) {
        this.newsId = id;
    }

    public String getSelectedNews() {
        String id = this.newsId;
        this.newsId = "";
        return id;
    }
}

