/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.news.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.NewsServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.news.ExecutionsQueryParam;
import cms.tmx.api.news.IHomeQueryApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.proto.PBase;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HomeQueryImpl
extends CallApi
implements IHomeQueryApi {
    @Inject
    private NewsServiceDefines.HomeServiceDefine define;
    @Inject
    private IBaseApi iba;

    @Override
    public List<PAssetService.AssetDistribution> getAssetDistList(List<PAssetService.AssetDistributionReq> listReq) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.iba.getOpUser();
        PAssetService.GetAssetDistributionsReq.Builder adBuilder = PAssetService.GetAssetDistributionsReq.newBuilder();
        adBuilder.setOpUser(opUser);
        adBuilder.addAllAssetReq(listReq);
        event.setObj((Object)adBuilder.build());
        this.action(this.define, "281", event);
        PAssetService.GetAssetDistributionsResp resp = (PAssetService.GetAssetDistributionsResp)event.getObj(PAssetService.GetAssetDistributionsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getAssetList();
    }

    @Override
    public List<PAssetService.AssetIntervalDistribution> getAssetIntervalDistList(String stratDate, String endDate, List<PAssetService.AssetDistributionReq> listReq) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.iba.getOpUser();
        PAssetService.GetAssetIntervalDistributionsReq.Builder builder = PAssetService.GetAssetIntervalDistributionsReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setStartDate(stratDate);
        builder.setEndDate(endDate);
        builder.addAllAssetReq(listReq);
        event.setObj((Object)builder.build());
        this.action(this.define, "282", event);
        PAssetService.GetAssetIntervalDistributionsResp resp = (PAssetService.GetAssetIntervalDistributionsResp)event.getObj(PAssetService.GetAssetIntervalDistributionsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getAssetList();
    }

    @Override
    public PAssetService.AssetConfiguration getAssetConfigurations(String extAccntId, String marketGrp) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.iba.getOpUser();
        PAssetService.GetAssetConfigurationsReq.Builder builder = PAssetService.GetAssetConfigurationsReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setExtAccntId(extAccntId);
        builder.setMarketGrp(marketGrp);
        event.setObj((Object)builder.build());
        this.action(this.define, "283", event);
        PAssetService.GetAssetConfigurationsResp resp = (PAssetService.GetAssetConfigurationsResp)event.getObj(PAssetService.GetAssetConfigurationsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getAsset();
    }

    @Override
    public PAssetService.GetExecutionsCollectResp getExecutions(ExecutionsQueryParam execQueryParam, List<String> extAccntIdListStr) throws MException {
        MEvent event = new MEvent();
        PAssetService.GetExecutionsCollectReq.Builder builder = PAssetService.GetExecutionsCollectReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setStartRow((execQueryParam.getPageNum() - 1) * execQueryParam.getPageSize() + 1);
        page.setPageSize(execQueryParam.getPageSize().intValue());
        builder.setPage(page.build());
        builder.setBeginDate(execQueryParam.getStartTime());
        builder.setEndDate(execQueryParam.getEndTime());
        builder.setMarketGrp("CCS");
        builder.addAllExtAccntId(extAccntIdListStr);
        builder.setSecurityId(execQueryParam.getCode());
        event.setObj((Object)builder.build());
        this.action(this.define, "353", event);
        PAssetService.GetExecutionsCollectResp resp = (PAssetService.GetExecutionsCollectResp)event.getObj(PAssetService.GetExecutionsCollectResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }
}

