/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.proxy;

import cms.tmx.api.mng.IPostApi;
import cms.tmx.api.mng.imp.PostApiImpl;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PPost;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PostApiProxy
implements IPostApi {
    private PostApiImpl postApi;
    @Inject
    private MObjFactory of;

    private synchronized void checkApi() {
        if (this.postApi == null) {
            this.postApi = (PostApiImpl)this.of.create(PostApiImpl.class);
        }
    }

    @Override
    public List<String> getPostIdList(String userId) throws MException {
        this.checkApi();
        return this.postApi.getPostIdList(userId);
    }

    @Override
    public List<PPost.Post> getPostList(String userId) throws MException {
        this.checkApi();
        return this.postApi.getPostList(userId);
    }

    @Override
    public PPost.Post getPostDetail(String postId) throws MException {
        this.checkApi();
        return this.postApi.getPostDetail(postId);
    }

    @Override
    public List<PPost.PostWithUser> getPostList(String partyId, Boolean all) throws MException {
        this.checkApi();
        return this.postApi.getPostList(partyId, all);
    }

    @Override
    public String addPost(PPost.Post post) throws MException {
        this.checkApi();
        return this.postApi.addPost(post);
    }

    @Override
    public void updatePost(PPost.Post post) throws MException {
        this.checkApi();
        this.postApi.updatePost(post);
    }

    @Override
    public void assignAccountToPost(String accountId, String postId, PCommon.Operation operation) throws MException {
        this.checkApi();
        this.postApi.assignAccountToPost(accountId, postId, operation);
    }

    @Override
    public void assignRoleToPost(String roleId, String postId, PCommon.Operation operation) throws MException {
        this.checkApi();
        this.postApi.assignRoleToPost(roleId, postId, operation);
    }

    @Override
    public void assignPortfolioToPost(String portfolioId, String postId, PCommon.Operation operation) throws MException {
        this.checkApi();
        this.postApi.assignPortfolioToPost(portfolioId, postId, operation);
    }

    @Override
    public void assignProductToPost(String productId, String postId, PCommon.Operation operation) throws MException {
        this.checkApi();
        this.postApi.assignProductToPost(productId, postId, operation);
    }

    @Override
    public PPost.Post getUserPost() throws MException {
        this.checkApi();
        return this.postApi.getUserPost();
    }

    @Override
    public List<String> getPostIdViaPortfolio(String portfolioId) throws MException {
        this.checkApi();
        return this.postApi.getPostIdViaPortfolio(portfolioId);
    }

    @Override
    public List<String> getPostIdViaExtAccnt(String accntId) throws MException {
        this.checkApi();
        return this.postApi.getPostIdViaExtAccnt(accntId);
    }

    @Override
    public List<PPost.Post> getPosts(List<String> postIds) throws MException {
        this.checkApi();
        return this.postApi.getPosts(postIds);
    }

    @Override
    public void operatePostControl(PPost.PostControl pControl, int type, String postId, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        this.checkApi();
        this.postApi.operatePostControl(pControl, type, postId, partyId, macFlag, ipFlag);
    }

    @Override
    public List<PPost.PostControl> getPostControl(String postId) throws MException {
        this.checkApi();
        return this.postApi.getPostControl(postId);
    }

    @Override
    public void updatePostControl(List<PPost.PostControl> postcontrols, int type, String postId, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        this.checkApi();
        this.postApi.updatePostControl(postcontrols, type, postId, partyId, macFlag, ipFlag);
    }

    @Override
    public void checkPostIpAndMac(String postId, String userId) throws MException {
        this.checkApi();
        this.postApi.checkPostIpAndMac(postId, userId);
    }

    @Override
    public void userCollectMenus(String meunuId) throws MException {
    }

    @Override
    public void userUnCollectMenus(String meunuId) throws MException {
    }

    @Override
    public List<String> getUserCollectionMenus() throws MException {
        return null;
    }

    @Override
    public List<String> getUserIdsViaPostId(String postId) throws MException {
        return null;
    }
}

