/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.proxy;

import cms.tmx.api.mng.IPartyApi;
import cms.tmx.api.mng.imp.PartyApiImpl;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PartyApiProxy
implements IPartyApi {
    private PartyApiImpl partyApi;
    @Inject
    private MObjFactory of;

    @Override
    public List<PHierarchy.Party> getPartyList(String partyId) throws MException {
        this.checkApi();
        return this.partyApi.getPartyList(partyId, PHierarchy.GetHierarchyReq.Option.GET_CHILDREN);
    }

    private synchronized void checkApi() {
        if (this.partyApi == null) {
            this.partyApi = (PartyApiImpl)this.of.create(PartyApiImpl.class);
        }
    }

    @Override
    public List<PHierarchy.Party> getPartyList(String partyId, PHierarchy.GetHierarchyReq.Option option) throws MException {
        this.checkApi();
        return this.partyApi.getPartyList(partyId, option);
    }

    @Override
    public boolean checkParty(String partyId) throws MException {
        this.checkApi();
        return this.partyApi.checkParty(partyId);
    }

    @Override
    public PHierarchy.Party getParty(String partyId) throws MException {
        this.checkApi();
        return this.partyApi.getParty(partyId);
    }

    @Override
    public PHierarchy.Party getUserParty() throws MException {
        this.checkApi();
        return this.partyApi.getUserParty();
    }

    @Override
    public String addParty(PHierarchy.Party party) throws MException {
        this.checkApi();
        return this.partyApi.addParty(party);
    }

    @Override
    public void updateParty(PHierarchy.Party party) throws MException {
        this.checkApi();
        this.partyApi.updateParty(party);
    }

    @Override
    public PHierarchy.Party getPartyDetails(PBase.OpUser user) throws MException {
        this.checkApi();
        return this.partyApi.getPartyDetails(user);
    }

    @Override
    public List<PHierarchy.Party> getPartyListContainOwn(String partyId) throws MException {
        this.checkApi();
        return this.partyApi.getPartyListContainOwn(partyId);
    }

    @Override
    public void checkParyIpAndMac(String postId, String userId, String partyId) throws MException {
        this.checkApi();
        this.partyApi.checkParyIpAndMac(postId, userId, partyId);
    }

    @Override
    public List<PHierarchy.PartyControl> getPartyControl(String partyId) throws MException {
        this.checkApi();
        return this.partyApi.getPartyControl(partyId);
    }

    @Override
    public void updatePartyControl(List<PHierarchy.PartyControl> partycontrols, int type, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        this.checkApi();
        this.partyApi.updatePartyControl(partycontrols, type, partyId, macFlag, ipFlag);
    }

    @Override
    public void operatePartyControl(PHierarchy.PartyControl control, int type, String partyId) throws MException {
        this.checkApi();
        this.partyApi.operatePartyControl(control, type, partyId);
    }
}

