/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IWorkFlowApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.datatype.proto.workflow.PWorkflow;
import cms.tmx.define.BsDict;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WorkFlowApiImpl
extends CallApi
implements IWorkFlowApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.WorkFlowServiceDefine ws;

    @Override
    public String setWorkFlowAttr(PWorkflow.WorkflowAttr workflowAttr) throws MException {
        MEvent event = new MEvent();
        PWorkflow.SetWorkflowAttrReq.Builder obj = PWorkflow.SetWorkflowAttrReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setWorkflowAttr(workflowAttr);
        event.setObj((Object)obj.build());
        this.action(this.ws, "771", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
        return opStatus.getData();
    }

    @Override
    public List<PWorkflow.WorkflowAttr> getWorkflowAttrs(String id, int type) throws MException {
        MEvent event = new MEvent();
        PWorkflow.GetWorkflowAttrsReq.Builder obj = PWorkflow.GetWorkflowAttrsReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        if (type == 1) {
            obj.setAccountId(id);
        } else if (type == 2) {
            obj.setPortfolioId(id);
        }
        event.setObj((Object)obj.build());
        this.action(this.ws, "772", event);
        PWorkflow.GetWorkflowAttrsResp resp = (PWorkflow.GetWorkflowAttrsResp)event.getObj(PWorkflow.GetWorkflowAttrsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getAttrList();
    }

    @Override
    public List<PWorkflow.WorkflowDescriptor> getDescriptors(List<Integer> flowIds) throws MException {
        MEvent event = new MEvent();
        PWorkflow.GetDescriptorsReq.Builder obj = PWorkflow.GetDescriptorsReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.addAllFlowId(flowIds);
        event.setObj((Object)obj.build());
        this.action(this.ws, "770", event);
        PWorkflow.GetDescriptorsResp resp = (PWorkflow.GetDescriptorsResp)event.getObj(PWorkflow.GetDescriptorsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getFlowDescriptorList();
    }

    @Override
    public void updateWorkFlowAttr(PWorkflow.WorkflowAttr workflowAttr) throws MException {
        MEvent event = new MEvent();
        PWorkflow.UpdateWorkflowAttrReq.Builder obj = PWorkflow.UpdateWorkflowAttrReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setWorkflowAttr(workflowAttr);
        event.setObj((Object)obj.build());
        this.action(this.ws, "773", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
    }

    @Override
    public void deleteWorkFlowAttr(String workflowAttrId) throws MException {
        MEvent event = new MEvent();
        PWorkflow.DeleteWorkflowAttrReq.Builder obj = PWorkflow.DeleteWorkflowAttrReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setWorkflowAttrId(workflowAttrId);
        event.setObj((Object)obj.build());
        this.action(this.ws, "774", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
    }

    @Override
    public void doAction(long entryId, int actionId, String portfolioName, String remark) throws MException {
        MEvent event = new MEvent();
        PWorkflow.DoActionReq.Builder obj = PWorkflow.DoActionReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setActionId(actionId);
        obj.setEntryId(entryId);
        obj.setRemark(remark);
        PInstructionManagement.InstructionContext.Builder contextBuilder = PInstructionManagement.InstructionContext.newBuilder();
        contextBuilder.setActionName((String)BsDict.INSTRUCTION_TYPE_MAP.get(String.valueOf(actionId)));
        contextBuilder.setPortfolioName(portfolioName);
        obj.setContext(contextBuilder.build());
        event.setObj((Object)obj.build());
        this.action(this.ws, "784", event);
        PWorkflow.DoActionResp resp = (PWorkflow.DoActionResp)event.getObj(PWorkflow.DoActionResp.class);
        this.checkStatus(resp.getStatus());
    }

    @Override
    public void doDistribute(long entryId, int actionId, String portfolioName, String userId, String remark) throws MException {
        MEvent event = new MEvent();
        PWorkflow.DoActionReq.Builder obj = PWorkflow.DoActionReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setActionId(actionId);
        obj.setEntryId(entryId);
        obj.setRemark(remark);
        obj.setDistributeUserId(userId);
        PInstructionManagement.InstructionContext.Builder contextBuilder = PInstructionManagement.InstructionContext.newBuilder();
        contextBuilder.setActionName((String)BsDict.INSTRUCTION_TYPE_MAP.get(String.valueOf(actionId)));
        contextBuilder.setPortfolioName(portfolioName);
        obj.setContext(contextBuilder.build());
        event.setObj((Object)obj.build());
        this.action(this.ws, "784", event);
        PWorkflow.DoActionResp resp = (PWorkflow.DoActionResp)event.getObj(PWorkflow.DoActionResp.class);
        this.checkStatus(resp.getStatus());
    }

    @Override
    public boolean checkInstructionStatus(String id, int type, String postId) throws MException {
        MEvent event = new MEvent();
        PWorkflow.CheckInstructionStatusReq.Builder obj = PWorkflow.CheckInstructionStatusReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        if (type == 1) {
            obj.setAccntId(id);
        } else if (type == 2) {
            obj.setPortfolioId(id);
        }
        if (!postId.isEmpty()) {
            obj.setPostId(postId);
        }
        event.setObj((Object)obj.build());
        this.action(this.ws, "775", event);
        PWorkflow.CheckInstructionStatusResp resp = (PWorkflow.CheckInstructionStatusResp)event.getObj(PWorkflow.CheckInstructionStatusResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getFlag();
    }
}

