/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IUserApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.account.PPersonalAccnt;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.hierarchy.PPost;
import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.datatype.proto.user.PUser;
import cms.tmx.datatype.proto.user.PUserControl;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UserApiImpl
extends CallApi
implements IUserApi {
    private String userId;
    private PUser.User user;
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.UserServiceDefine usd;
    @Inject
    private MngServiceDefines.PersonalUserServiceDefine pUsd;
    @Inject
    private MngServiceDefines.LoggerMessageServiceDefine lsd;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hsd;
    @Inject
    private MConfService cs;
    @Inject
    private MngServiceDefines.OpinionServiceDefine opi;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private Logger logger = LogManager.getLogger(UserApiImpl.class);
    private static final int PAGE_SIZE = 200;
    private static final int USER_ID_LEN = 11;

    @Override
    public PUser.User getActiveUser() throws MException {
        this.userId = this.bmi.getUserId();
        if (this.user == null && this.userId != null) {
            this.user = this.getUserDetail(this.userId);
        }
        return this.user;
    }

    @Override
    public PUser.User getUserDetail(String userId) throws MException {
        LinkedList<String> list = new LinkedList<String>();
        list.add(userId);
        List<PUser.User> users = this.getUserList(list);
        if (users.size() > 0) {
            return users.get(0);
        }
        return null;
    }

    @Override
    public List<PUser.User> getUserList(List<String> userIds) throws MException {
        MEvent event = new MEvent();
        PUser.GetUsersReq.Builder uBuilder = PUser.GetUsersReq.newBuilder();
        uBuilder.setOpUser(this.bmi.getOpUserWithOutCpu());
        userIds.forEach(item -> uBuilder.addUserId(item));
        event.setObj((Object)uBuilder.build());
        this.action(this.usd, "146", event);
        PUser.GetUsersResp resp = (PUser.GetUsersResp)event.getObj(PUser.GetUsersResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getUserList();
    }

    @Override
    public boolean VerifyUserPassword(String userId, String oldPwd) throws MException {
        MEvent event = new MEvent();
        PUser.VerifyUserPasswordReq.Builder newBuilder = PUser.VerifyUserPasswordReq.newBuilder();
        newBuilder.setUserId(userId);
        try {
            String decrypt = DesEncrypt.encrypt((String)oldPwd, (String)"ficc2018");
            newBuilder.setPassword(decrypt);
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        event.setObj((Object)newBuilder.build());
        this.action(this.usd, "141", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        int code = status.getStatus();
        return code == 1 || code == 11;
    }

    @Override
    public String addUser(PUser.User user) throws MException {
        MEvent event = new MEvent();
        PUser.NewUserReq.Builder newBuilder = PUser.NewUserReq.newBuilder();
        newBuilder.setOpUser(this.bmi.getOpUser());
        newBuilder.setUser(user);
        event.setObj((Object)newBuilder.build());
        this.action(this.usd, "140", event);
        this.checkStatus(event.getObj());
        return ((PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj())).getData();
    }

    @Override
    public void updateUser(PUser.User user) throws MException {
        MEvent event = new MEvent();
        PUser.UpdateUserReq.Builder newBuilder = PUser.UpdateUserReq.newBuilder();
        newBuilder.setOpUser(this.bmi.getOpUser());
        newBuilder.setUser(user);
        event.setObj((Object)newBuilder.build());
        this.action(this.usd, "143", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void assignUserToParty(String partyId, String userId) throws MException {
        MEvent event = new MEvent();
        PHierarchy.AssignUserToPartyReq.Builder aBuilder = PHierarchy.AssignUserToPartyReq.newBuilder();
        aBuilder.setOpUser(this.bmi.getOpUser());
        aBuilder.setPartyId(partyId);
        aBuilder.setUserId(userId);
        event.setObj((Object)aBuilder.build());
        this.action(this.hsd, "740", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<String> getUserIds(String partyId) throws MException {
        return this.getUserIds(partyId, PHierarchy.GetUserIdsViaPartyReq.GetOption.GET_OFFSPRING);
    }

    @Override
    public List<String> getUserIds(String partyId, PHierarchy.GetUserIdsViaPartyReq.GetOption option) throws MException {
        PHierarchy.GetUserIdsViaPartyResp resp;
        LinkedList<String> list = new LinkedList<String>();
        boolean hasMore = false;
        int i = 0;
        do {
            MEvent event = new MEvent();
            PHierarchy.GetUserIdsViaPartyReq.Builder uBuilder = PHierarchy.GetUserIdsViaPartyReq.newBuilder();
            uBuilder.setOpUser(this.bmi.getOpUser());
            uBuilder.setOption(option);
            uBuilder.setPartyId(partyId);
            PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
            pBuilder.setPageSize(200);
            pBuilder.setStartRow(200 * i++ + 1);
            uBuilder.setPager(pBuilder.build());
            event.setObj((Object)uBuilder.build());
            this.action(this.hsd, "741", event);
            resp = (PHierarchy.GetUserIdsViaPartyResp)event.getObj(PHierarchy.GetUserIdsViaPartyResp.class);
            list.addAll((Collection<String>)resp.getUserIdList());
            this.checkStatus(resp.getStatus());
        } while (hasMore = resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public void resetPwd(String userId, String pwd) throws MException {
        MEvent event = new MEvent();
        PUser.ResetPasswordReq.Builder uBuilder = PUser.ResetPasswordReq.newBuilder();
        PBase.OpUser.Builder builder = PBase.OpUser.newBuilder();
        try {
            PBase.OpUser opUser = this.bmi.getOpUser();
            builder.setIp(opUser.getLocalIp());
            builder.setMac(opUser.getMac());
            if (!"".equals(opUser.getUserId())) {
                builder.setUserId(opUser.getUserId());
            } else {
                builder.setUserId(userId);
            }
        }
        catch (Exception exception) {
            builder.setUserId(userId);
        }
        uBuilder.setOpUser(builder.build());
        uBuilder.setUserId(userId);
        try {
            String decrypt = DesEncrypt.encrypt((String)pwd, (String)"ficc2018");
            uBuilder.setPassword(decrypt);
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        event.setObj((Object)uBuilder.build());
        this.action(this.usd, "155", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void assignUserToPost(String userId, Collection<String> postIds) throws MException {
        MEvent event = new MEvent();
        PPost.AssignUserToPostReq.Builder uBuilder = PPost.AssignUserToPostReq.newBuilder();
        uBuilder.setOpUser(this.bmi.getOpUser());
        uBuilder.setUserId(userId);
        uBuilder.addAllPostId(postIds);
        event.setObj((Object)uBuilder.build());
        this.action(this.hsd, "698", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public MEvent userLogin(String user, String passwd) throws MException {
        MEvent event = new MEvent();
        String id = "";
        id = StringUtils.isEmpty((String)this.bmi.getUserId()) ? this.getIdByName(user) : this.bmi.getOpUser().getUserId();
        if (!id.isEmpty()) {
            user = id;
        }
        if (user.length() != 11) {
            throw new MException(999997, "\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        }
        PUser.LoginReq.Builder builder = PUser.LoginReq.newBuilder();
        PBase.OpUser.Builder opUserB = this.getOpUserWithOutCpu();
        opUserB.setUserId(user);
        builder.setOpUser(opUserB.build());
        builder.setUserId(user);
        builder.setUuid(this.eCore.getStr("uuid"));
        try {
            String decrypt = DesEncrypt.encrypt((String)passwd, (String)"ficc2018");
            builder.setPassword(decrypt);
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        builder.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
        builder.setMac(CommUtils.getMAC());
        builder.setHddSerial(CommUtils.getSerialNumber());
        event.setObj((Object)builder.build());
        event.put((Object)"user_id", (Object)user);
        this.login(this.usd, "147", event);
        try {
            PUser.LoginResp resp = (PUser.LoginResp)event.getObj(PUser.LoginResp.class);
            PBase.OpStatus opStatus = resp.getOpStatus();
            this.checkStatus(opStatus);
        }
        catch (Exception e) {
            this.logger.error("\u767b\u5f55\u56de\u62a5\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new MException(-1, "\u767b\u5f55\u56de\u62a5\u7c7b\u578b\u8f6c\u6362\u5931\u8d25");
        }
        event.put((Object)"userId", (Object)user);
        this.eCore.put((Object)"user_id", (Object)user);
        this.eCore.put((Object)"ORG_PASSWORD", (Object)passwd);
        return event;
    }

    @Override
    public void userLogout() throws MException {
        MEvent event = new MEvent();
        PUser.LogoutReq.Builder builder = PUser.LogoutReq.newBuilder();
        builder.setUserId(this.bmi.getOpUser().getUserId());
        builder.setOpUser(this.bmi.getOpUser());
        builder.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
        builder.setMac(CommUtils.getMAC());
        builder.setUuid(this.eCore.getStr("uuid"));
        event.setObj((Object)builder.build());
        this.action(this.usd, "152", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void personalUserLogout() throws MException {
        MEvent event = new MEvent();
        PPersonalAccnt.PersonalLogoutReq.Builder builder = PPersonalAccnt.PersonalLogoutReq.newBuilder();
        builder.setUserId(this.bmi.getOpUser().getUserId());
        builder.setOpUser(this.bmi.getOpUser());
        builder.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
        builder.setMac(CommUtils.getMAC());
        builder.setUuid(this.eCore.getStr("uuid"));
        builder.setMarketGroup(this.eCore.getStr("MarketGrp", "CCS"));
        event.setObj((Object)builder.build());
        this.action(this.pUsd, "175", event);
        this.checkStatus(event.getObj());
    }

    private PBase.OpUser.Builder getOpUserWithOutCpu() {
        PBase.OpUser.Builder opUserB = PBase.OpUser.newBuilder();
        String ip = this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip");
        String mac = CommUtils.getMAC();
        opUserB.setIp(ip);
        opUserB.setMac(mac);
        opUserB.setLocalIp(CommUtils.getIP());
        opUserB.setSno(CommUtils.getSerialNumber());
        opUserB.setPcn(CommUtils.getPCName());
        opUserB.setOsv(CommUtils.getOSV());
        opUserB.setSn(CommUtils.getSerialNumber());
        opUserB.setUuid(this.eCore.getStr("uuid"));
        opUserB.setDatetime(DateTimeUtils.getTimeStamp());
        opUserB.setTerminalVersion("V" + this.cs.getProps("client.properties").getDesValue("client_version"));
        opUserB.setTerminalName("T-master");
        JsonObject jsonObj = new JsonObject();
        jsonObj.add("broker_id", (JsonElement)new JsonPrimitive("99999"));
        jsonObj.add("v_mac_flag", (JsonElement)new JsonPrimitive(CommUtils.isVirtual() ? "1" : "0"));
        String json = jsonObj.toString().replace(",", "$");
        opUserB.setText(json);
        return opUserB;
    }

    @Override
    public MEvent personalUserLogin(String user, String passwd, String marketGrp) throws MException {
        MEvent event = new MEvent();
        String id = "";
        id = StringUtils.isEmpty((String)this.bmi.getOpUser().getUserId()) ? this.getIdByName(user) : this.bmi.getOpUser().getUserId();
        if (!id.isEmpty()) {
            user = id;
        }
        if (user.length() != 11) {
            throw new MException(999997, "\u8d44\u91d1\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        PPersonalAccnt.PersonalLoginReq.Builder builder = PPersonalAccnt.PersonalLoginReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setUuid(this.eCore.getStr("uuid"));
        builder.setUserId(user);
        builder.setUserName(user);
        try {
            String decrypt = DesEncrypt.encrypt((String)passwd, (String)"ficc2018");
            builder.setPassword(decrypt);
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        builder.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
        builder.setMac(CommUtils.getMAC());
        builder.setHddSerial(CommUtils.getSerialNumber());
        builder.setMarketGroup(marketGrp);
        event.setObj((Object)builder.build());
        event.put((Object)"user_id", (Object)user);
        this.login(this.pUsd, "174", event);
        this.checkStatusForReason(event.getObj());
        event.put((Object)"userId", (Object)user);
        this.eCore.put((Object)"user_id", (Object)user);
        this.eCore.put((Object)"ORG_PASSWORD", (Object)passwd);
        return event;
    }

    @Override
    public String getIdByName(String userName) throws MException {
        MEvent event = new MEvent();
        String id = "";
        PUser.GetUserIdReq.Builder builder = PUser.GetUserIdReq.newBuilder();
        builder.setUsername(userName);
        event.setObj((Object)builder.build());
        event.put((Object)"user_id", (Object)userName);
        this.action(this.usd, "156", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        id = status.getData();
        return id;
    }

    @Override
    public void updateUserControl(PUserControl.UpdateUserControlReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.usd, "157", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public HashMap<String, Object> getUserControl(String userId) throws MException {
        MEvent event = new MEvent();
        PUserControl.GetUserControlReq.Builder build = PUserControl.GetUserControlReq.newBuilder();
        build.setOpUser(this.bmi.getOpUser());
        build.setUserId(userId);
        event.setObj((Object)build.build());
        this.action(this.usd, "158", event);
        PUserControl.GetUserControlResp resp = (PUserControl.GetUserControlResp)event.getObj(PUserControl.GetUserControlResp.class);
        this.checkStatus(resp.getStatus());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("list", resp.getUserControlList());
        hashMap.put("user", resp.getPwdControl());
        return hashMap;
    }

    @Override
    public PUser.GetUserLockInfoResp getUserLockInfo(PBase.Pager page) throws MException {
        MEvent event = new MEvent();
        PUser.GetUserLockInfoReq.Builder build = PUser.GetUserLockInfoReq.newBuilder();
        build.setOpUser(this.bmi.getOpUser());
        build.setPager(page);
        event.setObj((Object)build.build());
        this.action(this.usd, "145", event);
        PUser.GetUserLockInfoResp resp = (PUser.GetUserLockInfoResp)event.getObj(PUser.GetUserLockInfoResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    @Override
    public void setUserLockInfo(PUser.SetUserLockInfoReq.Option op, long lockDuration, int maxCount, List<String> userIds) throws MException {
        MEvent event = new MEvent();
        PUser.SetUserLockInfoReq.Builder build = PUser.SetUserLockInfoReq.newBuilder();
        build.setOpUser(this.bmi.getOpUser());
        build.setOption(op);
        if (op.getNumber() == 1) {
            build.setLockDuration(lockDuration);
            build.setMaxRetryCount(maxCount);
        } else if (op.getNumber() == 2) {
            build.addAllUserId(userIds);
        }
        event.setObj((Object)build.build());
        this.action(this.usd, "151", event);
        PBase.OpStatus status = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(status);
    }

    @Override
    public PMisc.GetUserLogResp getUserLogReq(PMisc.GetUserLogReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.lsd, "193", event);
        PMisc.GetUserLogResp resp = (PMisc.GetUserLogResp)event.getObj(PMisc.GetUserLogResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    @Override
    public void setOpinionsReq(PMisc.SetOpinionsReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.opi, "194", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public PMisc.GetOpinionsResp GetOpinionsReq(PMisc.GetOpinionsReq build) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)build);
        this.action(this.opi, "199", event);
        PMisc.GetOpinionsResp resp = (PMisc.GetOpinionsResp)event.getObj(PMisc.GetOpinionsResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    @Override
    public String userRegister(PUser.UserRegisterReq req) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.usd, "179", event);
        PBase.OpStatus status = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(status);
        return status.getData();
    }
}

