/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PSecAccntService;
import cms.tmx.datatype.proto.PBase;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SecAccountApiImpl
extends CallApi
implements ISecAccountApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.SecAccntServiceDefine sec;

    @Override
    public List<PAccount.ExtSecAccnt> getSecAccountList(PAccount.ExtFundAccnt fund) throws MException {
        ArrayList<PAccount.ExtSecAccnt> secList = new ArrayList<PAccount.ExtSecAccnt>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.querySecAccountByPage(secList, fund, defPage, i);
        return secList;
    }

    private void querySecAccountByPage(List<PAccount.ExtSecAccnt> secList, PAccount.ExtFundAccnt fund, PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        PSecAccntService.GetExtSecAccntsReq.Builder hBuilder = PSecAccntService.GetExtSecAccntsReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setMarketGrp(fund.getMarketGrp());
        hBuilder.setExtAccntId(fund.getExtAccntId());
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.sec, "244", event);
        PSecAccntService.GetExtSecAccntsResp resp = (PSecAccntService.GetExtSecAccntsResp)event.getObj(PSecAccntService.GetExtSecAccntsResp.class);
        event.getObj(PSecAccntService.GetExtSecAccntsResp.class);
        this.checkStatus(resp.getStatus());
        secList.addAll(resp.getExtSecAccntList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.querySecAccountByPage(secList, fund, pageBuilder.build(), i);
        }
    }

    @Override
    public PBase.OpStatus addSecAccount(PAccount.ExtSecAccnt secAccnt, String marketGrp, String market) throws MException {
        MEvent event = new MEvent();
        PSecAccntService.NewExtSecAccntReq.Builder hBuilder = PSecAccntService.NewExtSecAccntReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setMarketGrp(marketGrp);
        hBuilder.setMarket(market);
        hBuilder.setExtSecAccnt(secAccnt);
        event.setObj((Object)hBuilder.build());
        this.action(this.sec, "241", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status;
    }

    @Override
    public PBase.OpStatus delSecAccount(PAccount.ExtSecAccnt secAccnt) throws MException {
        MEvent event = new MEvent();
        PSecAccntService.DeleteExtSecAccntReq.Builder hBuilder = PSecAccntService.DeleteExtSecAccntReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setMarket(secAccnt.getMarket());
        hBuilder.setExtSecAccntId(secAccnt.getExtSecAccntId());
        hBuilder.setMarketGrp(secAccnt.getMarketGrp());
        event.setObj((Object)hBuilder.build());
        this.action(this.sec, "242", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status;
    }

    @Override
    public List<PAccount.SubSecAccnt> getSubSecAccounts(String marketGrp, PAccount.SubSecAccnt subSecAccnt) throws MException {
        ArrayList<PAccount.SubSecAccnt> secAccountsList = new ArrayList<PAccount.SubSecAccnt>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.querySubSecAccountsByPage(secAccountsList, marketGrp, subSecAccnt, defPage, i);
        return secAccountsList;
    }

    private void querySubSecAccountsByPage(List<PAccount.SubSecAccnt> secList, String marketGrp, PAccount.SubSecAccnt subSecAccnt, PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        PSecAccntService.GetSubSecAccntsReq.Builder hBuilder = PSecAccntService.GetSubSecAccntsReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setMarketGrp(marketGrp);
        hBuilder.setSubSecAccnt(subSecAccnt);
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.sec, "254", event);
        PSecAccntService.GetSubSecAccntsResp resp = (PSecAccntService.GetSubSecAccntsResp)event.getObj(PSecAccntService.GetSubSecAccntsResp.class);
        this.checkStatus(resp.getStatus());
        secList.addAll(resp.getSubSecAccntList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.querySubSecAccountsByPage(secList, marketGrp, subSecAccnt, pageBuilder.build(), i);
        }
    }

    @Override
    public PBase.OpStatus syncExtsecAccnts(String investorId, String marketGrp, int seq) throws MException {
        MEvent event = new MEvent();
        PSecAccntService.SyncExtSecAccntsReq.Builder sb = PSecAccntService.SyncExtSecAccntsReq.newBuilder();
        sb.setOpUser(this.bmi.getOpUser());
        sb.setInvestorId(investorId);
        sb.setMarketGrp(marketGrp);
        sb.setSeq(seq);
        event.setObj((Object)sb.build());
        this.action(this.sec, "245", event);
        PSecAccntService.SyncExtSecAccntsResp resp = (PSecAccntService.SyncExtSecAccntsResp)event.getObj(PSecAccntService.SyncExtSecAccntsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getStatus();
    }
}

