/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IRoleApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.hierarchy.PRbac;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class RoleApiImpl
extends CallApi
implements IRoleApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hsd;

    @Override
    public String addRole(PRbac.Role role) throws MException {
        MEvent event = new MEvent();
        PRbac.NewRoleReq.Builder obj = PRbac.NewRoleReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setRole(role);
        event.setObj((Object)obj.build());
        this.action(this.hsd, "171", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
        return opStatus.getData();
    }

    @Override
    public void updateRole(PRbac.Role role) throws MException {
        MEvent event = new MEvent();
        PRbac.UpdateRoleReq.Builder obj = PRbac.UpdateRoleReq.newBuilder();
        obj.setRole(role);
        obj.setOpUser(this.bmi.getOpUser());
        obj.setOwnedPartyId(role.getPartyId());
        event.setObj((Object)obj.build());
        this.action(this.hsd, "174", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public PRbac.Role getRoleDetail(String id) throws MException {
        MEvent event = new MEvent();
        PRbac.GetRolesReq.Builder obj = PRbac.GetRolesReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.addRoleId(id);
        event.setObj((Object)obj.build());
        this.action(this.hsd, "177", event);
        PRbac.GetRolesResp resp = (PRbac.GetRolesResp)event.getObj(PRbac.GetRolesResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getRoleCount() == 1) {
            return (PRbac.Role)resp.getRoleList().get(0);
        }
        return null;
    }

    @Override
    public List<PRbac.RoleWithPost> getRoleListByParty(String id) throws MException {
        LinkedList<PRbac.RoleWithPost> list = new LinkedList<PRbac.RoleWithPost>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PRbac.GetRolesViaPartyReq.Builder rBuilder = PRbac.GetRolesViaPartyReq.newBuilder();
            rBuilder.setOpUser(this.bmi.getOpUser());
            rBuilder.setPartyId(id);
            rBuilder.setNeedPublic(true);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                rBuilder.setPager(pBuilder.build());
            }
            event.setObj((Object)rBuilder.build());
            this.action(this.hsd, "645", event);
            PRbac.GetRolesViaPartyResp resp = (PRbac.GetRolesViaPartyResp)event.getObj(PRbac.GetRolesViaPartyResp.class);
            this.checkStatus(resp.getStatus());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
            list.addAll(resp.getRoleList());
        } while (hasMore);
        return list;
    }

    @Override
    public List<PRbac.Role> getRoleListByPost(String id) throws MException {
        return null;
    }

    @Override
    public List<String> getRoleIdListByPost(String id) throws MException {
        MEvent event = new MEvent();
        PRbac.GetRoleIdsViaPostReq.Builder builder = PRbac.GetRoleIdsViaPostReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setPostId(id);
        event.setObj((Object)builder.build());
        this.action(this.hsd, "697", event);
        PRbac.GetRoleIdsViaPostResp resp = (PRbac.GetRoleIdsViaPostResp)event.getObj(PRbac.GetRoleIdsViaPostResp.class);
        this.checkStatus(resp.getStatus());
        LinkedList<String> ids = new LinkedList<String>();
        resp.getRoleIdList().forEach(item -> ids.add((String)item));
        return ids;
    }

    @Override
    public void assignFuncToRole(String roleId, List<String> funcIds) throws MException {
        MEvent event = new MEvent();
        PRbac.AssignFuncModulesToRoleReq.Builder builder = PRbac.AssignFuncModulesToRoleReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setRoleId(roleId);
        builder.addAllFuncModuleId(funcIds);
        event.setObj((Object)builder.build());
        this.action(this.hsd, "672", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PRbac.Role> getRoleListByPostId(String postId) throws MException {
        MEvent event = new MEvent();
        PRbac.GetRolesViaPostIdReq.Builder builder = PRbac.GetRolesViaPostIdReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setPostId(postId);
        event.setObj((Object)builder.build());
        this.action(this.hsd, "700", event);
        PRbac.GetRolesViaPostIdResp resp = (PRbac.GetRolesViaPostIdResp)event.getObj(PRbac.GetRolesViaPostIdResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getRolesList();
    }
}

