/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IProductApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.product.PProduct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ProductApiImpl
extends CallApi
implements IProductApi {
    @Inject
    private BaseApiImpl bai;
    @Inject
    private MngServiceDefines.ProductServiceDefine psd;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hsd;

    @Override
    public String addProduct(PProduct.Product product, String partyId) throws MException {
        MEvent event = new MEvent();
        PProduct.NewProductReq.Builder nBuilder = PProduct.NewProductReq.newBuilder();
        nBuilder.setOpUser(this.bai.getOpUser());
        nBuilder.setProduct(product);
        nBuilder.setOwnerPartyId(partyId);
        event.setObj((Object)nBuilder.build());
        this.action(this.psd, "730", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
        return opStatus.getData();
    }

    @Override
    public void updateProduct(PProduct.Product product) throws MException {
        MEvent event = new MEvent();
        PProduct.UpdateProductReq.Builder nBuilder = PProduct.UpdateProductReq.newBuilder();
        nBuilder.setOpUser(this.bai.getOpUser());
        nBuilder.setProduct(product);
        event.setObj((Object)nBuilder.build());
        this.action(this.psd, "732", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void delProduct(String id) throws MException {
        MEvent event = new MEvent();
        PProduct.DeleteProductReq.Builder nBuilder = PProduct.DeleteProductReq.newBuilder();
        nBuilder.setOpUser(this.bai.getOpUser());
        nBuilder.setProductId(id);
        event.setObj((Object)nBuilder.build());
        this.action(this.psd, "731", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<String> getProductIdsByPartyId(String partyId, PCommon.AssignType type, PHierarchy.GetProductIdsViaPartyReq.Option option) throws MException {
        LinkedList<String> list = new LinkedList<String>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PHierarchy.GetProductIdsViaPartyReq.Builder builder = PHierarchy.GetProductIdsViaPartyReq.newBuilder();
            builder.setOpUser(this.bai.getOpUser());
            builder.setPartyId(partyId);
            builder.setAssignType(type);
            builder.setOption(option);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                builder.setPager(pBuilder.build());
            }
            event.setObj((Object)builder.build());
            this.action(this.hsd, "646", event);
            PHierarchy.GetProductIdsViaPartyResp resp = (PHierarchy.GetProductIdsViaPartyResp)event.getObj(PHierarchy.GetProductIdsViaPartyResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll((Collection<String>)resp.getProductIdList());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
        } while (hasMore);
        return list;
    }

    @Override
    public PProduct.ProductDetails getProductDetail(String id) throws MException {
        MEvent event = new MEvent();
        PProduct.GetProductsReq.Builder builder = PProduct.GetProductsReq.newBuilder();
        builder.addProductId(id);
        builder.setOpUser(this.bai.getOpUser());
        event.setObj((Object)builder.build());
        this.action(this.psd, "733", event);
        PProduct.GetProductsResp resp = (PProduct.GetProductsResp)event.getObj(PProduct.GetProductsResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getDetailsList().size() >= 1) {
            return (PProduct.ProductDetails)resp.getDetailsList().get(0);
        }
        return null;
    }

    @Override
    public List<String> getProductIdsByPostId(String postId) throws MException {
        LinkedList<String> productIds = new LinkedList<String>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PHierarchy.GetProductIdsViaPostReq.Builder rBuilder = PHierarchy.GetProductIdsViaPostReq.newBuilder();
            rBuilder.setOpUser(this.bai.getOpUser());
            rBuilder.setPostId(postId);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                rBuilder.setPager(pBuilder.build());
            }
            event.setObj((Object)rBuilder.build());
            this.action(this.hsd, "752", event);
            PHierarchy.GetProductIdsViaPostResp resp = (PHierarchy.GetProductIdsViaPostResp)event.getObj(PHierarchy.GetProductIdsViaPostResp.class);
            this.checkStatus(resp.getStatus());
            productIds.addAll((Collection<String>)resp.getProductIdList());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
        } while (hasMore);
        return productIds;
    }

    @Override
    public void assignAccountToProduct(List<String> accountIds, String productId, PCommon.Operation operation, int accntType) throws MException {
        MEvent event = new MEvent();
        PProduct.AssignAccntToProductReq.Builder builder = PProduct.AssignAccntToProductReq.newBuilder();
        builder.setProductId(productId);
        builder.setOperation(operation);
        builder.setOpUser(this.bai.getOpUser());
        accountIds.forEach(item -> {
            PProduct.AccntDetails.Builder b = PProduct.AccntDetails.newBuilder();
            b.setAccntId(item);
            b.setTypeValue(accntType);
            builder.addDetails(b.build());
        });
        event.setObj((Object)builder.build());
        this.action(this.psd, "736", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PProduct.ProductDetails> getProducts(String partyId) throws MException {
        LinkedList<PProduct.ProductDetails> list = new LinkedList<PProduct.ProductDetails>();
        list.addAll(this.getProductsByPartyId(partyId, PCommon.AssignType.ALL, PHierarchy.GetProductIdsViaPartyReq.Option.GET_OFFSPRING));
        list.addAll(this.getProductsByPartyId(partyId, PCommon.AssignType.ALL, PHierarchy.GetProductIdsViaPartyReq.Option.GET_ONE));
        return list;
    }

    @Override
    public List<PProduct.ProductDetails> getProductsByPartyId(String partyId, PCommon.AssignType type, PHierarchy.GetProductIdsViaPartyReq.Option option) throws MException {
        List<String> ids = this.getProductIdsByPartyId(partyId, type, option);
        return this.getProductsByIdList(ids);
    }

    private List<PProduct.ProductDetails> getProductsByIdList(List<String> productIds) throws MException {
        ArrayList<PProduct.ProductDetails> liste = new ArrayList<PProduct.ProductDetails>();
        int m = productIds.size() / 200;
        int n = productIds.size() % 200;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            list = i == m ? productIds.subList(m * 200, m * 200 + n) : productIds.subList(i * 200, (i + 1) * 200);
            liste.addAll(this.getTwoHundredProducts(list));
            ++i;
        }
        return liste;
    }

    private List<PProduct.ProductDetails> getTwoHundredProducts(List<String> productIds) throws MException {
        MEvent event = new MEvent();
        PProduct.GetProductsReq.Builder builder = PProduct.GetProductsReq.newBuilder();
        builder.addAllProductId(productIds);
        builder.setOpUser(this.bai.getOpUser());
        event.setObj((Object)builder.build());
        this.action(this.psd, "733", event);
        if (productIds.isEmpty()) {
            LinkedList<PProduct.ProductDetails> list = new LinkedList<PProduct.ProductDetails>();
            return list;
        }
        PProduct.GetProductsResp resp = (PProduct.GetProductsResp)event.getObj(PProduct.GetProductsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getDetailsList();
    }
}

