/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IPostApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PPost;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.DateTimeUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PostApiImpl
extends CallApi
implements IPostApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hs;
    private PPost.Post post;
    private String postId;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private static final int OP_TYPE_DEFAULT = 7;
    private static final int PAGE_SIZE = 200;

    @Override
    public List<String> getPostIdList(String userId) throws MException {
        PPost.GetPostIdsViaUserReq.Builder builderReq = PPost.GetPostIdsViaUserReq.newBuilder();
        PBase.OpUser.Builder builderUser = PBase.OpUser.newBuilder();
        builderUser.setUserId(userId);
        PBase.OpUser user = builderUser.build();
        builderReq.setOpUser(user);
        builderReq.setUserId(userId);
        PPost.GetPostIdsViaUserReq req = builderReq.build();
        MEvent event = new MEvent();
        event.setObj((Object)req);
        this.action(this.hs, "714", event);
        PPost.GetPostIdsViaUserResp resp = (PPost.GetPostIdsViaUserResp)event.getObj(PPost.GetPostIdsViaUserResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getPostIdList();
    }

    @Override
    public List<PPost.Post> getPostList(String userId) throws MException {
        List<String> listIds = this.getPostIdList(userId);
        PPost.GetAssignPostsReq.Builder builderReq = PPost.GetAssignPostsReq.newBuilder();
        PBase.OpUser.Builder builderUser = PBase.OpUser.newBuilder();
        LinkedList<PPost.Post> posts = new LinkedList<PPost.Post>();
        builderUser.setUserId(userId);
        PBase.OpUser user = builderUser.build();
        builderReq.setOpUser(user);
        builderReq.addAllPostId(listIds);
        MEvent event = new MEvent();
        PPost.GetAssignPostsReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.hs, "726", event);
        PPost.GetAssignPostsResp resp = (PPost.GetAssignPostsResp)PPost.GetAssignPostsResp.class.cast(event.getObj());
        this.checkStatus(resp.getStatus());
        posts.addAll(resp.getPostList());
        return posts;
    }

    @Override
    public PPost.Post getPostDetail(String postId) throws MException {
        PPost.GetPostsReq.Builder builderReq = PPost.GetPostsReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.addPostId(postId);
        MEvent event = new MEvent();
        PPost.GetPostsReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.hs, "725", event);
        PPost.GetPostsResp resp = (PPost.GetPostsResp)PPost.GetPostsResp.class.cast(event.getObj());
        this.checkStatus(resp.getStatus());
        return resp.getPostList().size() > 0 ? (PPost.Post)resp.getPostList().get(0) : null;
    }

    @Override
    public List<PPost.PostWithUser> getPostList(String partyId, Boolean all) throws MException {
        LinkedList<PPost.PostWithUser> list = new LinkedList<PPost.PostWithUser>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PPost.GetPostsViaPartyReq.Builder hBuilder = PPost.GetPostsViaPartyReq.newBuilder();
            hBuilder.setOpUser(this.bmi.getOpUser());
            hBuilder.setPartyId(partyId);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                hBuilder.setPager(pBuilder.build());
            }
            event.setObj((Object)hBuilder.build());
            this.action(this.hs, "750", event);
            PPost.GetPostsViaPartyResp resp = (PPost.GetPostsViaPartyResp)event.getObj(PPost.GetPostsViaPartyResp.class);
            this.checkStatus(resp.getStatus());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
            resp.getPostList().forEach(item -> {
                if (all.booleanValue()) {
                    list.add((PPost.PostWithUser)item);
                } else if (item.getPost().getStatus() == 1) {
                    list.add((PPost.PostWithUser)item);
                }
            });
        } while (hasMore);
        return list;
    }

    @Override
    public String addPost(PPost.Post post) throws MException {
        MEvent event = new MEvent();
        PPost.NewPostReq.Builder pBuilder = PPost.NewPostReq.newBuilder();
        pBuilder.setPost(post);
        pBuilder.setOpUser(this.bmi.getOpUser());
        PPost.NewPostReq data = pBuilder.build();
        event.setObj((Object)data);
        this.action(this.hs, "720", event);
        this.checkStatus(event.getObj());
        return ((PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj())).getData();
    }

    @Override
    public void updatePost(PPost.Post post) throws MException {
        MEvent event = new MEvent();
        PPost.UpdatePostReq.Builder pBuilder = PPost.UpdatePostReq.newBuilder();
        pBuilder.setPost(post);
        pBuilder.setOpUser(this.bmi.getOpUser());
        PPost.UpdatePostReq data = pBuilder.build();
        event.setObj((Object)data);
        this.action(this.hs, "722", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void assignAccountToPost(String accountId, String postId, PCommon.Operation operation) throws MException {
        MEvent event = new MEvent();
        PPost.AssignExtAccntToPostReq.Builder builder = PPost.AssignExtAccntToPostReq.newBuilder();
        builder.setExtAccntId(accountId);
        builder.setPostId(postId);
        builder.setOption(operation);
        builder.setOpUser(this.bmi.getOpUser());
        builder.setOperateType(7);
        event.setObj((Object)builder.build());
        this.action(this.hs, "690", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void assignRoleToPost(String roleId, String postId, PCommon.Operation operation) throws MException {
        MEvent event = new MEvent();
        PPost.AssignRoleToPostReq.Builder builder = PPost.AssignRoleToPostReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setOption(operation);
        builder.setPostId(postId);
        builder.setRoleId(roleId);
        event.setObj((Object)builder.build());
        this.action(this.hs, "696", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void assignPortfolioToPost(String portfolioId, String postId, PCommon.Operation operation) throws MException {
        MEvent event = new MEvent();
        PPost.AssignPortfolioToPostReq.Builder builder = PPost.AssignPortfolioToPostReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setOption(operation);
        builder.setPostId(postId);
        builder.setPortfolioId(portfolioId);
        event.setObj((Object)builder.build());
        this.action(this.hs, "694", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void assignProductToPost(String productId, String postId, PCommon.Operation operation) throws MException {
        MEvent event = new MEvent();
        PPost.AssignProductToPostReq.Builder builder = PPost.AssignProductToPostReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setOption(operation);
        builder.setPostId(postId);
        builder.setProductId(productId);
        event.setObj((Object)builder.build());
        this.action(this.hs, "751", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public PPost.Post getUserPost() throws MException {
        this.postId = this.bmi.getPostId();
        if (this.post == null && this.postId != null) {
            this.post = this.getPostDetail(this.postId);
        }
        return this.post;
    }

    @Override
    public List<String> getPostIdViaPortfolio(String portfolioId) throws MException {
        MEvent event = new MEvent();
        PPost.GetPostIdViaPortfolioReq.Builder req = PPost.GetPostIdViaPortfolioReq.newBuilder();
        req.setPortfolioId(portfolioId);
        req.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)req.build());
        this.action(this.hs, "712", event);
        PPost.GetPostIdViaPortfolioResp resp = (PPost.GetPostIdViaPortfolioResp)event.getObj(PPost.GetPostIdViaPortfolioResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getPostIdList();
    }

    @Override
    public List<String> getPostIdViaExtAccnt(String accntId) throws MException {
        MEvent event = new MEvent();
        PPost.GetPostIdViaExtAccntReq.Builder req = PPost.GetPostIdViaExtAccntReq.newBuilder();
        req.setExtAccntId(accntId);
        req.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)req.build());
        this.action(this.hs, "713", event);
        PPost.GetPostIdViaExtAccntResp resp = (PPost.GetPostIdViaExtAccntResp)event.getObj(PPost.GetPostIdViaExtAccntResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getPostIdList();
    }

    @Override
    public List<PPost.Post> getPosts(List<String> postIds) throws MException {
        PPost.GetPostsReq.Builder builderReq = PPost.GetPostsReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.addAllPostId(postIds);
        MEvent event = new MEvent();
        PPost.GetPostsReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.hs, "725", event);
        PPost.GetPostsResp resp = (PPost.GetPostsResp)PPost.GetPostsResp.class.cast(event.getObj());
        this.checkStatus(resp.getStatus());
        return resp.getPostList();
    }

    @Override
    public void operatePostControl(PPost.PostControl pControl, int type, String postId, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        MEvent event = new MEvent();
        PPost.OperatePostControlReq.Builder builderReq = PPost.OperatePostControlReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.setActionValue(type);
        builderReq.setPostId(postId);
        builderReq.setPartyId(partyId);
        builderReq.addPostControl(pControl);
        event.setObj((Object)builderReq.build());
        this.action(this.hs, "727", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PPost.PostControl> getPostControl(String postId) throws MException {
        PPost.GetPostControlResp resp;
        LinkedList<PPost.PostControl> list = new LinkedList<PPost.PostControl>();
        boolean hasMore = false;
        int i = 0;
        do {
            MEvent event = new MEvent();
            PPost.GetPostControlReq.Builder build = PPost.GetPostControlReq.newBuilder();
            build.setOpUser(this.bmi.getOpUser());
            build.setPostId(postId);
            PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
            pBuilder.setPageSize(200);
            pBuilder.setStartRow(200 * i++ + 1);
            build.setPager(pBuilder.build());
            event.setObj((Object)build.build());
            this.action(this.hs, "728", event);
            resp = (PPost.GetPostControlResp)event.getObj(PPost.GetPostControlResp.class);
            list.addAll(resp.getPostControlList());
            this.checkStatus(resp.getStatus());
        } while (hasMore = resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public void updatePostControl(List<PPost.PostControl> postcontrols, int type, String postId, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        MEvent event = new MEvent();
        PPost.OperatePostControlReq.Builder uBuilder = PPost.OperatePostControlReq.newBuilder();
        uBuilder.setOpUser(this.bmi.getOpUser());
        uBuilder.setActionValue(type);
        uBuilder.setPostId(postId);
        uBuilder.setPartyId(partyId);
        uBuilder.addAllPostControl(postcontrols);
        event.setObj((Object)uBuilder.build());
        this.action(this.hs, "727", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void checkPostIpAndMac(String postId, String userId) throws MException {
        PPost.CheckPostControlReq.Builder builder = PPost.CheckPostControlReq.newBuilder();
        PBase.OpUser.Builder userBuilder = PBase.OpUser.newBuilder();
        userBuilder.setPostId(postId);
        userBuilder.setUserId(userId);
        userBuilder.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
        userBuilder.setMac(CommUtils.getMAC());
        userBuilder.setDatetime(DateTimeUtils.getTimeStamp());
        PBase.OpUser user = userBuilder.build();
        builder.setOpUser(user);
        builder.setPostId(postId);
        PPost.CheckPostControlReq data = builder.build();
        MEvent event = new MEvent();
        event.setObj((Object)data);
        this.action(this.hs, "729", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void userCollectMenus(String meunuId) throws MException {
        PPost.CollectMenusReq.Builder builder = PPost.CollectMenusReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.addMenuId(meunuId);
        PPost.CollectMenusReq build = builder.build();
        MEvent event = new MEvent();
        event.setObj((Object)build);
        this.action(this.hs, "716", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void userUnCollectMenus(String meunuId) throws MException {
        PPost.UncollectMenusReq.Builder builder = PPost.UncollectMenusReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.addMenuId(meunuId);
        PPost.UncollectMenusReq build = builder.build();
        MEvent event = new MEvent();
        event.setObj((Object)build);
        this.action(this.hs, "717", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<String> getUserCollectionMenus() throws MException {
        PPost.GetCollectionMenusReq.Builder builder = PPost.GetCollectionMenusReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.hs, "718", event);
        PPost.GetCollectionMenusResp resp = (PPost.GetCollectionMenusResp)event.getObj(PPost.GetCollectionMenusResp.class);
        this.checkStatus(resp.getStatus());
        LinkedList<String> menuIdList = new LinkedList();
        menuIdList.addAll((Collection<String>)resp.getMenuIdList());
        menuIdList = menuIdList.stream().distinct().collect(Collectors.toList());
        return menuIdList;
    }

    @Override
    public List<String> getUserIdsViaPostId(String postId) throws MException {
        PPost.GetUserIdsViaPostReq.Builder builder = PPost.GetUserIdsViaPostReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setPostId(postId);
        PBase.Pager.Builder pageBuilder = PBase.Pager.newBuilder();
        pageBuilder.setPageSize(2000);
        pageBuilder.setStartRow(1);
        builder.setPager(pageBuilder.build());
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.hs, "699", event);
        PPost.GetUserIdsViaPostResp resp = (PPost.GetUserIdsViaPostResp)event.getObj(PPost.GetUserIdsViaPostResp.class);
        this.checkStatus(resp.getStatus());
        LinkedList<String> userIds = new LinkedList<String>();
        userIds.addAll((Collection<String>)resp.getUserIdList());
        return userIds;
    }
}

