/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.datatype.proto.trade.PCashService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PortfolioApiImpl
extends CallApi
implements IPortfolioApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.PortfolioServiceDefine ps;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hs;
    @Inject
    private TradeServiceDefines.TransCashServiceDefine tcs;
    @Inject
    private TradeServiceDefines.TransPosiServiceDefine tps;

    @Override
    public String addPortfolio(PPortfolio.Portfolio portfolio, String ownedPartyId) throws MException {
        MEvent event = new MEvent();
        PPortfolio.NewPortfolioReq.Builder obj = PPortfolio.NewPortfolioReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setPortfolio(portfolio);
        obj.setOwnedPartyId(ownedPartyId);
        event.setObj((Object)obj.build());
        this.action(this.ps, "110", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
        return opStatus.getData();
    }

    @Override
    public void updatePortfolio(PPortfolio.Portfolio portfolio, String ownedPartyId) throws MException {
        MEvent event = new MEvent();
        PPortfolio.UpdatePortfolioReq.Builder obj = PPortfolio.UpdatePortfolioReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setPortfolio(portfolio);
        obj.setOwnedPartyId(ownedPartyId);
        event.setObj((Object)obj.build());
        this.action(this.ps, "112", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
    }

    @Override
    public void enablePortfolio(String portfolioId, boolean enabled) throws MException {
        MEvent event = new MEvent();
        PPortfolio.EnablePortfolioReq.Builder obj = PPortfolio.EnablePortfolioReq.newBuilder();
        obj.setOpUser(this.bmi.getOpUser());
        obj.setPortfolioId(portfolioId);
        obj.setEnabled(enabled);
        event.setObj((Object)obj.build());
        this.action(this.ps, "115", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
    }

    @Override
    public List<String> getPortfolioIdsByParty(String id) throws MException {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.getPortfolioIdsByParty(id, PHierarchy.GetPortfolioIdsViaPartyReq.Option.GET_ONE));
        list.addAll(this.getPortfolioIdsByParty(id, PHierarchy.GetPortfolioIdsViaPartyReq.Option.GET_OFFSPRING));
        return list;
    }

    private List<String> getPortfolioIdsByParty(String id, PHierarchy.GetPortfolioIdsViaPartyReq.Option option) throws MException {
        MEvent event = new MEvent();
        PHierarchy.GetPortfolioIdsViaPartyReq.Builder rBuilder = PHierarchy.GetPortfolioIdsViaPartyReq.newBuilder();
        rBuilder.setOpUser(this.bmi.getOpUser());
        rBuilder.setPartyId(id);
        rBuilder.setOption(option);
        event.setObj((Object)rBuilder.build());
        this.action(this.hs, "641", event);
        PHierarchy.GetPortfolioIdsViaPartyResp resp = (PHierarchy.GetPortfolioIdsViaPartyResp)event.getObj(PHierarchy.GetPortfolioIdsViaPartyResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getPortfolioIdList();
    }

    @Override
    public List<PPortfolio.PortfolioDetails> getPortfoliosByIds(List<String> ids) throws MException {
        ArrayList<PPortfolio.PortfolioDetails> liste = new ArrayList<PPortfolio.PortfolioDetails>();
        int m = ids.size() / 200;
        int n = ids.size() % 200;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            list = i == m ? ids.subList(m * 200, m * 200 + n) : ids.subList(i * 200, (i + 1) * 200);
            liste.addAll(this.getTwoHundredPortfolio(list));
            ++i;
        }
        return liste;
    }

    private List<PPortfolio.PortfolioDetails> getTwoHundredPortfolio(List<String> ids) throws MException {
        MEvent event = new MEvent();
        ArrayList<PPortfolio.PortfolioDetails> liste = new ArrayList<PPortfolio.PortfolioDetails>();
        if (ids.size() > 0) {
            PPortfolio.GetPortfoliosReq.Builder rBuilder = PPortfolio.GetPortfoliosReq.newBuilder();
            rBuilder.setOpUser(this.bmi.getOpUser());
            rBuilder.addAllPortfolioId(ids);
            event.setObj((Object)rBuilder.build());
            this.action(this.ps, "113", event);
            PPortfolio.GetPortfoliosResp resp = (PPortfolio.GetPortfoliosResp)event.getObj(PPortfolio.GetPortfoliosResp.class);
            this.checkStatus(resp.getStatus());
            liste.addAll(resp.getDetailsList());
        }
        return liste;
    }

    @Override
    public List<String> getPortfolioIdsByPost(String postId) throws MException {
        MEvent event = new MEvent();
        PHierarchy.GetPortfolioIdsViaPostReq.Builder rBuilder = PHierarchy.GetPortfolioIdsViaPostReq.newBuilder();
        rBuilder.setOpUser(this.bmi.getOpUser());
        rBuilder.setPostId(postId);
        event.setObj((Object)rBuilder.build());
        this.action(this.hs, "695", event);
        PHierarchy.GetPortfolioIdsViaPostResp resp = (PHierarchy.GetPortfolioIdsViaPostResp)event.getObj(PHierarchy.GetPortfolioIdsViaPostResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getPortfolioIdList();
    }

    @Override
    public List<PPortfolio.PortfolioDetails> getPortfoliosByParty(String id) throws MException {
        return this.getPortfoliosByIds(this.getPortfolioIdsByParty(id));
    }

    @Override
    public List<PPortfolio.PortfolioDetails> getPortfoliosByPost(String postId) throws MException {
        return this.getPortfoliosByIds(this.getPortfolioIdsByPost(postId));
    }

    @Override
    public List<PPortfolio.PortAccntAssignDetails> getAccntsByPortfolioIds(String portfolioId) throws MException {
        PPortfolio.GetAccntIdsViaPortfolioResp resp;
        LinkedList<PPortfolio.PortAccntAssignDetails> list = new LinkedList<PPortfolio.PortAccntAssignDetails>();
        boolean hasMore = false;
        int startRow = 1;
        do {
            MEvent event = new MEvent();
            PPortfolio.GetAccntIdsViaPortfolioReq.Builder rBuilder = PPortfolio.GetAccntIdsViaPortfolioReq.newBuilder();
            rBuilder.setOpUser(this.bmi.getOpUser());
            rBuilder.setPortfolioId(portfolioId);
            PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
            pBuilder.setPageSize(150);
            pBuilder.setStartRow(startRow);
            startRow += 150;
            rBuilder.setPager(pBuilder.build());
            event.setObj((Object)rBuilder.build());
            this.action(this.ps, "671", event);
            resp = (PPortfolio.GetAccntIdsViaPortfolioResp)event.getObj(PPortfolio.GetAccntIdsViaPortfolioResp.class);
            list.addAll(resp.getDetailsList());
            this.checkStatus(resp.getStatus());
        } while (hasMore = resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public List<PPortfolio.PortAccntAssignDetails> getPortfolioIdsByAccntId(String accntId) throws MException {
        PPortfolio.GetPortfolioIdsViaAccntResp resp;
        LinkedList<PPortfolio.PortAccntAssignDetails> list = new LinkedList<PPortfolio.PortAccntAssignDetails>();
        boolean hasMore = false;
        int startRow = 1;
        do {
            MEvent event = new MEvent();
            PPortfolio.GetPortfolioIdsViaAccntReq.Builder pBuilder = PPortfolio.GetPortfolioIdsViaAccntReq.newBuilder();
            pBuilder.setOpUser(this.bmi.getOpUser());
            pBuilder.setAccountId(accntId);
            pBuilder.setAccntType(1);
            PBase.Pager.Builder rBuilder = PBase.Pager.newBuilder();
            rBuilder.setPageSize(150);
            rBuilder.setStartRow(startRow);
            startRow += 150;
            pBuilder.setPager(rBuilder.build());
            event.setObj((Object)pBuilder.build());
            this.action(this.ps, "674", event);
            resp = (PPortfolio.GetPortfolioIdsViaAccntResp)event.getObj(PPortfolio.GetPortfolioIdsViaAccntResp.class);
            list.addAll(resp.getDetailsList());
            this.checkStatus(resp.getStatus());
        } while (hasMore = resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public void AssignAccntToPortfolio(PPortfolio.AssignAccntToPortfolioReq.Builder req) throws MException {
        MEvent event = new MEvent();
        req.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)req.build());
        this.action(this.ps, "670", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
    }

    @Override
    public void TransferCash(int type, String srcSubFund, String srcParty, String dstSubFund, String dstParty, double amount) throws MException {
        MEvent event = new MEvent();
        PCashService.TransferCashReq.Builder builder = PCashService.TransferCashReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setTransTypeValue(type);
        builder.setSrcPartyId(srcParty);
        builder.setDstPartyId(dstParty);
        builder.setSrcSubAccntId(srcSubFund);
        builder.setDstSubAccntId(dstSubFund);
        builder.setTransAmount(amount);
        event.setObj((Object)builder.build());
        this.action(this.tcs, "026", event);
        PCashService.TransferCashResp resp = (PCashService.TransferCashResp)event.getObj(PCashService.TransferCashResp.class);
        this.checkStatus(resp.getStatus());
    }

    @Override
    public void TransferPosition(int type, String extFundAccnt, String srcPortfolio, String srcParty, String dstPortfolio, String dstParty, PCashService.TransPositionElem elem) throws MException {
        MEvent event = new MEvent();
        PCashService.TransferPositionReq.Builder builder = PCashService.TransferPositionReq.newBuilder();
        builder.setTransTypeValue(type);
        builder.setOpUser(this.bmi.getOpUser());
        builder.setSrcPartyId(srcParty);
        builder.setDstPartyId(dstParty);
        builder.setSrcPortfolioId(srcPortfolio);
        builder.setExtAccntId(extFundAccnt);
        builder.setDstPortfolioId(dstPortfolio);
        builder.setElem(elem);
        event.setObj((Object)builder.build());
        this.action(this.tps, "022", event);
        PCashService.TransferPositionResp resp = (PCashService.TransferPositionResp)event.getObj(PCashService.TransferPositionResp.class);
        this.checkStatus(resp.getStatus());
    }

    @Override
    public List<PCashService.CashTransRecord> getCashTransfer(String start, String end, List<String> partys) throws MException {
        PCashService.GetCashTransRecordsResp resp;
        PCashService.GetCashTransRecordsReq.Builder builder = PCashService.GetCashTransRecordsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setBeginTime(start);
        builder.setEndTime(end);
        builder.addAllPartyIdArray(partys);
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setStartRow(1);
        page.setPageSize(200);
        LinkedList<PCashService.CashTransRecord> list = new LinkedList<PCashService.CashTransRecord>();
        do {
            builder.setPage(page);
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.tcs, "027", event);
            resp = (PCashService.GetCashTransRecordsResp)event.takeObj(PCashService.GetCashTransRecordsResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getRecordList());
            int startRow = page.getStartRow();
            int pageSize = page.getPageSize();
            page.setStartRow(startRow + pageSize);
        } while (page.getStartRow() <= resp.getPage().getTotalRow());
        return list;
    }

    @Override
    public List<PCashService.PosTransRecord> getPosTransfer(String start, String end, List<String> partys) throws MException {
        PCashService.GetPosTransRecordsResp resp;
        PCashService.GetPosTransRecordsReq.Builder builder = PCashService.GetPosTransRecordsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setBeginTime(start);
        builder.setEndTime(end);
        builder.addAllPartyIdArray(partys);
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setStartRow(1);
        page.setPageSize(10);
        LinkedList<PCashService.PosTransRecord> list = new LinkedList<PCashService.PosTransRecord>();
        do {
            builder.setPage(page);
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.tps, "023", event);
            resp = (PCashService.GetPosTransRecordsResp)event.takeObj(PCashService.GetPosTransRecordsResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getRecordList());
            int startRow = page.getStartRow();
            int pageSize = page.getPageSize();
            page.setStartRow(startRow + pageSize);
        } while (page.getStartRow() <= resp.getPage().getTotalRow());
        return list;
    }

    @Override
    public List<PPortfolio.Benchmark> getBenchmarkList(int type) throws MException {
        PPortfolio.GetBenchmarksResp resp;
        LinkedList<PPortfolio.Benchmark> list = new LinkedList<PPortfolio.Benchmark>();
        boolean hasMore = false;
        int startRow = 1;
        do {
            MEvent event = new MEvent();
            PPortfolio.GetBenchmarksReq.Builder rBuilder = PPortfolio.GetBenchmarksReq.newBuilder();
            rBuilder.setOpUser(this.bmi.getOpUser());
            rBuilder.setType(type);
            PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
            pBuilder.setPageSize(150);
            pBuilder.setStartRow(startRow);
            startRow += 150;
            rBuilder.setPager(pBuilder.build());
            event.setObj((Object)rBuilder.build());
            this.action(this.ps, "675", event);
            resp = (PPortfolio.GetBenchmarksResp)event.getObj(PPortfolio.GetBenchmarksResp.class);
            list.addAll(resp.getBenchmarkList());
            this.checkStatus(resp.getStatus());
        } while (hasMore = resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public List<PCashService.CashTransRecord> getExtTransfer(String start, String end, List<String> ports) throws MException {
        PCashService.GetCashTransRecordsResp resp;
        PCashService.GetCashTransRecordsReq.Builder builder = PCashService.GetCashTransRecordsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setBeginTime(start);
        builder.setEndTime(end);
        builder.addAllPortfolioIdArray(ports);
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setStartRow(1);
        page.setPageSize(200);
        LinkedList<PCashService.CashTransRecord> list = new LinkedList<PCashService.CashTransRecord>();
        do {
            builder.setPage(page);
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.tcs, "027", event);
            resp = (PCashService.GetCashTransRecordsResp)event.takeObj(PCashService.GetCashTransRecordsResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getRecordList());
            int startRow = page.getStartRow();
            int pageSize = page.getPageSize();
            page.setStartRow(startRow + pageSize);
        } while (page.getStartRow() <= resp.getPage().getTotalRow());
        return list;
    }

    @Override
    public List<PCashService.PosTransRecord> getSecTransfer(String start, String end, List<String> ports) throws MException {
        PCashService.GetPosTransRecordsResp resp;
        PCashService.GetPosTransRecordsReq.Builder builder = PCashService.GetPosTransRecordsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setBeginTime(start);
        builder.setEndTime(end);
        builder.addAllPortfolioIdArray(ports);
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setStartRow(1);
        page.setPageSize(10);
        LinkedList<PCashService.PosTransRecord> list = new LinkedList<PCashService.PosTransRecord>();
        do {
            builder.setPage(page);
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.tps, "023", event);
            resp = (PCashService.GetPosTransRecordsResp)event.takeObj(PCashService.GetPosTransRecordsResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getRecordList());
            int startRow = page.getStartRow();
            int pageSize = page.getPageSize();
            page.setStartRow(startRow + pageSize);
        } while (page.getStartRow() <= resp.getPage().getTotalRow());
        return list;
    }
}

