/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IPartyApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.DateTimeUtils;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PartyApiImpl
extends CallApi
implements IPartyApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hs;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private static final int PAGE_SIZE = 200;
    private static final int PARTY_ENABLE = 1;

    @Override
    public List<PHierarchy.Party> getPartyList(String partyId) throws MException {
        return this.getPartyList(partyId, PHierarchy.GetHierarchyReq.Option.GET_CHILDREN);
    }

    @Override
    public List<PHierarchy.Party> getPartyList(String partyId, PHierarchy.GetHierarchyReq.Option option) throws MException {
        LinkedList<PHierarchy.Party> list = new LinkedList<PHierarchy.Party>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PHierarchy.GetHierarchyReq.Builder hBuilder = PHierarchy.GetHierarchyReq.newBuilder();
            hBuilder.setOpUser(this.bmi.getOpUser());
            hBuilder.setPartyId(partyId);
            hBuilder.setOption(option);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                hBuilder.setPager(pBuilder.build());
            }
            event.setObj((Object)hBuilder.build());
            this.action(this.hs, "640", event);
            PHierarchy.GetHierarchyResp resp = (PHierarchy.GetHierarchyResp)event.getObj(PHierarchy.GetHierarchyResp.class);
            list.addAll(resp.getPartyList());
            this.checkStatus(resp.getStatus());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
        } while (hasMore);
        return list;
    }

    @Override
    public boolean checkParty(String partyId) throws MException {
        PHierarchy.GetInstitutionDetailsReq.Builder builderReq = PHierarchy.GetInstitutionDetailsReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUserWithOutCpu());
        builderReq.setPartyId(partyId);
        MEvent event = new MEvent();
        PHierarchy.GetInstitutionDetailsReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.hs, "124", event);
        PHierarchy.GetInstitutionDetailsResp resp = (PHierarchy.GetInstitutionDetailsResp)event.getObj(PHierarchy.GetInstitutionDetailsResp.class);
        this.checkStatus(resp.getStatus());
        if (!resp.getIsAncestorsNormal()) {
            return false;
        }
        return resp.getParty().getStatus() == 1;
    }

    @Override
    public PHierarchy.Party getParty(String partyId) throws MException {
        List<PHierarchy.Party> list = this.getPartyList(partyId, PHierarchy.GetHierarchyReq.Option.GET_SINGEL_PARTY);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public PHierarchy.Party getUserParty() throws MException {
        PHierarchy.Party party = this.getParty(this.bmi.getPartyId());
        return party;
    }

    @Override
    public String addParty(PHierarchy.Party party) throws MException {
        MEvent event = new MEvent();
        PHierarchy.NewInstitutionReq.Builder instBuilder = PHierarchy.NewInstitutionReq.newBuilder();
        instBuilder.setOpUser(this.bmi.getOpUser());
        instBuilder.setParty(party);
        PHierarchy.NewInstitutionReq obj = instBuilder.build();
        event.setObj((Object)obj);
        this.action(this.hs, "120", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
        return opStatus.getData();
    }

    @Override
    public void updateParty(PHierarchy.Party party) throws MException {
        MEvent event = new MEvent();
        PHierarchy.UpdateInstitutionReq.Builder instBuilder = PHierarchy.UpdateInstitutionReq.newBuilder();
        instBuilder.setOpUser(this.bmi.getOpUser());
        instBuilder.setParty(party);
        event.setObj((Object)instBuilder.build());
        this.action(this.hs, "122", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public PHierarchy.Party getPartyDetails(PBase.OpUser user) throws MException {
        PHierarchy.GetInstitutionDetailsReq.Builder builderReq = PHierarchy.GetInstitutionDetailsReq.newBuilder();
        builderReq.setOpUser(user);
        builderReq.setPartyId(user.getPartyId());
        MEvent event = new MEvent();
        PHierarchy.GetInstitutionDetailsReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.hs, "124", event);
        PHierarchy.GetInstitutionDetailsResp resp = (PHierarchy.GetInstitutionDetailsResp)event.getObj(PHierarchy.GetInstitutionDetailsResp.class);
        this.checkStatus(resp.getStatus());
        if (!resp.getIsAncestorsNormal()) {
            return null;
        }
        if (resp.getParty().getStatus() != 1) {
            return null;
        }
        return resp.getParty();
    }

    @Override
    public List<PHierarchy.Party> getPartyListContainOwn(String partyId) throws MException {
        LinkedList<PHierarchy.Party> list = new LinkedList<PHierarchy.Party>();
        list.addAll(this.getPartyList(partyId, PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
        list.add(this.getParty(partyId));
        return list;
    }

    @Override
    public void checkParyIpAndMac(String postId, String userId, String partyId) throws MException {
        PHierarchy.CheckPartyControlReq.Builder builder = PHierarchy.CheckPartyControlReq.newBuilder();
        PBase.OpUser.Builder userBuilder = PBase.OpUser.newBuilder();
        userBuilder.setPostId(postId);
        userBuilder.setUserId(userId);
        userBuilder.setPartyId(partyId);
        userBuilder.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
        userBuilder.setMac(CommUtils.getMAC());
        userBuilder.setDatetime(DateTimeUtils.getTimeStamp());
        PBase.OpUser user = userBuilder.build();
        builder.setOpUser(user);
        builder.setPartyId(partyId);
        PHierarchy.CheckPartyControlReq data = builder.build();
        MEvent event = new MEvent();
        event.setObj((Object)data);
        this.action(this.hs, "130", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PHierarchy.PartyControl> getPartyControl(String partyId) throws MException {
        PHierarchy.GetPartyControlResp resp;
        LinkedList<PHierarchy.PartyControl> list = new LinkedList<PHierarchy.PartyControl>();
        boolean hasMore = false;
        int i = 0;
        do {
            MEvent event = new MEvent();
            PHierarchy.GetPartyControlReq.Builder build = PHierarchy.GetPartyControlReq.newBuilder();
            build.setOpUser(this.bmi.getOpUser());
            build.setPartyId(partyId);
            PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
            pBuilder.setPageSize(200);
            pBuilder.setStartRow(200 * i++ + 1);
            build.setPager(pBuilder.build());
            event.setObj((Object)build.build());
            this.action(this.hs, "129", event);
            resp = (PHierarchy.GetPartyControlResp)event.getObj(PHierarchy.GetPartyControlResp.class);
            list.addAll(resp.getPartyControlList());
            this.checkStatus(resp.getStatus());
        } while (hasMore = resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public void updatePartyControl(List<PHierarchy.PartyControl> partycontrols, int type, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        MEvent event = new MEvent();
        PHierarchy.OperatePartyControlReq.Builder uBuilder = PHierarchy.OperatePartyControlReq.newBuilder();
        uBuilder.setOpUser(this.bmi.getOpUser());
        uBuilder.setActionValue(type);
        uBuilder.setPartyId(partyId);
        uBuilder.addAllPartyControl(partycontrols);
        event.setObj((Object)uBuilder.build());
        this.action(this.hs, "128", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void operatePartyControl(PHierarchy.PartyControl pControl, int type, String partyId) throws MException {
        MEvent event = new MEvent();
        PHierarchy.OperatePartyControlReq.Builder builderReq = PHierarchy.OperatePartyControlReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.setActionValue(type);
        builderReq.setPartyId(partyId);
        builderReq.addPartyControl(pControl);
        event.setObj((Object)builderReq.build());
        this.action(this.hs, "128", event);
        this.checkStatus(event.getObj());
    }
}

