/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.ICommApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.utils.CommUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ICommApiImpl
extends CallApi
implements ICommApi {
    @Inject
    private MngServiceDefines.HeartbeatServiceDefine define;
    @Inject
    private TradeServiceDefines.FutureStrategyServiceDefine strategy;
    @Inject
    private BaseApiImpl iba;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;

    @Override
    public boolean heartbeatReq() {
        MEvent event = new MEvent();
        PMisc.MiscHeartbeatReq.Builder builder = PMisc.MiscHeartbeatReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setIp(this.getIP());
        builder.setMac(CommUtils.getMAC());
        PMisc.MiscHeartbeatReq heartbeat = builder.build();
        event.setObj((Object)heartbeat);
        try {
            this.action(this.define, "100", event);
            this.checkStatus(event.getObj());
        }
        catch (MException mException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean strategyHeartbeatReq() {
        MEvent event = new MEvent();
        PMisc.MiscHeartbeatReq.Builder builder = PMisc.MiscHeartbeatReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setIp(this.getIP());
        builder.setMac(CommUtils.getMAC());
        PMisc.MiscHeartbeatReq heartbeat = builder.build();
        event.setObj((Object)heartbeat);
        try {
            this.action(this.strategy, "500", event);
            this.checkStatus(event.getObj());
        }
        catch (MException mException) {
            return false;
        }
        return true;
    }

    private String getIP() {
        String ip = this.eCore.getStr("ip");
        if (ip == null) {
            ip = CommUtils.getIP();
        }
        return ip;
    }
}

