/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PFundAccntService;
import cms.tmx.datatype.proto.PBase;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FundAccountApiImpl
extends CallApi
implements IFundAccountApi {
    private static final Logger logger = LogManager.getLogger(FundAccountApiImpl.class);
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.FundAccntServiceDefine fundApi;

    @Override
    public int addFundAccount(PAccount.ExtFundAccnt fundAccount, String type) throws MException {
        MEvent event = new MEvent();
        PFundAccntService.NewExtFundAccntReq.Builder builderReq = PFundAccntService.NewExtFundAccntReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.setExtFundAccnt(fundAccount);
        builderReq.setMarketGrp(type);
        PFundAccntService.NewExtFundAccntReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.fundApi, "236", event);
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getStatus();
    }

    @Override
    public int updateFundAccount(PAccount.ExtFundAccnt fundAccount, String type) throws MException {
        MEvent event = new MEvent();
        PFundAccntService.UpdateExtFundAccntReq.Builder builderReq = PFundAccntService.UpdateExtFundAccntReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.setExtFundAccnt(fundAccount);
        builderReq.setMarketGrp(type);
        PFundAccntService.UpdateExtFundAccntReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.fundApi, "238", event);
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        this.checkStatus(event.getObj());
        return status.getStatus();
    }

    @Override
    public int updateFundAccount(ArrayList<PFundAccntService.AccntToProduct> accToPros, String type) throws MException {
        MEvent event = new MEvent();
        PFundAccntService.UpdateExtFundAccntReq.Builder builderReq = PFundAccntService.UpdateExtFundAccntReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.setMarketGrp(type);
        builderReq.addAllAccntToProduct(accToPros);
        PFundAccntService.UpdateExtFundAccntReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.fundApi, "238", event);
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        this.checkStatus(event.getObj());
        return status.getStatus();
    }

    @Override
    public List<PAccount.ExtFundAccnt> getFundAccountList(String id, String type) throws MException {
        ArrayList<PAccount.ExtFundAccnt> fundList = new ArrayList<PAccount.ExtFundAccnt>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.QueryFundByPage(fundList, id, type, defPage, i);
        return fundList;
    }

    private void QueryFundByPage(List<PAccount.ExtFundAccnt> fundList, String id, String type, PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        PFundAccntService.GetExtFundAccntsReq.Builder hBuilder = PFundAccntService.GetExtFundAccntsReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setParentAccntId(id);
        hBuilder.setMarketGrp(type);
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.fundApi, "239", event);
        PFundAccntService.GetExtFundAccntsResp resp = (PFundAccntService.GetExtFundAccntsResp)event.getObj(PFundAccntService.GetExtFundAccntsResp.class);
        this.checkStatus(resp.getStatus());
        fundList.addAll(resp.getExtFundAccntList());
        logger.error("\u6839\u636etype\u83b7\u53d6\u8d44\u91d1\u8d26\u6237\u5217\u8868\uff1a type: " + type + " list:" + resp.getExtFundAccntList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.QueryFundByPage(fundList, id, type, pageBuilder.build(), i);
        }
    }

    @Override
    public PAccount.ExtFundAccnt getFundAccount(PAccount.ExtFundAccnt fundAcc) throws MException {
        MEvent event = new MEvent();
        PBase.Page defPage = this.bmi.getDefPage();
        PFundAccntService.GetExtFundAccntsReq.Builder hBuilder = PFundAccntService.GetExtFundAccntsReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setExtAccntId(fundAcc.getExtAccntId());
        hBuilder.setMarketGrp(fundAcc.getMarketGrp());
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.fundApi, "239", event);
        PFundAccntService.GetExtFundAccntsResp resp = (PFundAccntService.GetExtFundAccntsResp)event.getObj(PFundAccntService.GetExtFundAccntsResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getExtFundAccntList().size() > 0) {
            return (PAccount.ExtFundAccnt)resp.getExtFundAccntList().get(0);
        }
        return null;
    }

    @Override
    public PAccount.ExtFundAccnt getFundAccount(String parentId, String grp, String currency) throws MException {
        MEvent event = new MEvent();
        PBase.Page defPage = this.bmi.getDefPage();
        PFundAccntService.GetExtFundAccntsReq.Builder hBuilder = PFundAccntService.GetExtFundAccntsReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setParentAccntId(parentId);
        hBuilder.setMarketGrp(grp);
        hBuilder.setCurrencyId(currency);
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.fundApi, "239", event);
        PFundAccntService.GetExtFundAccntsResp resp = (PFundAccntService.GetExtFundAccntsResp)event.getObj(PFundAccntService.GetExtFundAccntsResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getExtFundAccntList().size() > 0) {
            return (PAccount.ExtFundAccnt)resp.getExtFundAccntList().get(0);
        }
        return null;
    }

    @Override
    public List<PAccount.SubFundAccnt> getSubFundAccountList(String marketGrp, PAccount.SubFundAccnt subFundAccnt) throws MException {
        ArrayList<PAccount.SubFundAccnt> fundList = new ArrayList<PAccount.SubFundAccnt>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.querySubFundByPage(fundList, marketGrp, subFundAccnt, defPage, i);
        return fundList;
    }

    private void querySubFundByPage(List<PAccount.SubFundAccnt> subFundAccntListResult, String marketGrp, PAccount.SubFundAccnt subFundAccnt, PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        PFundAccntService.GetSubFundAccntsReq.Builder hBuilder = PFundAccntService.GetSubFundAccntsReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.setMarketGrp(marketGrp);
        hBuilder.setSubFundAccnt(subFundAccnt);
        hBuilder.setPage(defPage);
        event.setObj((Object)hBuilder.build());
        this.action(this.fundApi, "249", event);
        PFundAccntService.GetSubFundAccntsResp resp = (PFundAccntService.GetSubFundAccntsResp)event.getObj(PFundAccntService.GetSubFundAccntsResp.class);
        this.checkStatus(resp.getStatus());
        subFundAccntListResult.addAll(resp.getSubFundAccntList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.querySubFundByPage(subFundAccntListResult, marketGrp, subFundAccnt, pageBuilder.build(), i);
        }
    }
}

