/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IFuncApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.mng.imp.PartyApiImpl;
import cms.tmx.api.mng.imp.RoleApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.hierarchy.PRbac;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FuncApiImpl
extends CallApi
implements IFuncApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private RoleApiImpl roleApi;
    @Inject
    private PartyApiImpl partyApi;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hs;
    private static final int PAGE_SIZE = 200;

    @Override
    public List<PRbac.FuncModule> getFuncListByUserPost(String postId) throws MException {
        LinkedList<String> allFuncId = new LinkedList();
        List<PRbac.RoleWithPost> roles = this.roleApi.getRoleListByParty(this.bmi.getPartyId());
        HashMap map = new HashMap(1000);
        roles.stream().filter(item -> item.getRole().getStatus() == 1).forEach(item -> map.put(item.getRole().getRoleId(), item.getRole()));
        List<String> roleIdList = this.roleApi.getRoleIdListByPost(postId);
        for (String roleId : roleIdList) {
            if (!map.keySet().contains(roleId) || !this.partyApi.checkParty(((PRbac.Role)map.get(roleId)).getPartyId())) continue;
            allFuncId.addAll(this.getFuncByRole(roleId));
        }
        allFuncId = allFuncId.stream().distinct().collect(Collectors.toList());
        return this.getFuncs(PRbac.GetFuncModulesReq.Option.LIST, allFuncId);
    }

    @Override
    public List<PRbac.FuncModule> getEnableFuncListByUserPost(String postId) throws MException {
        List<PRbac.FuncModule> allFunc = this.getFuncListByUserPost(postId);
        LinkedList<PRbac.FuncModule> userFuncs = new LinkedList<PRbac.FuncModule>();
        allFunc.stream().filter(item -> item.getStatus() == 1).forEach(item -> userFuncs.add((PRbac.FuncModule)item));
        return userFuncs;
    }

    @Override
    public String addFunc(PRbac.FuncModule func) throws MException {
        MEvent event = new MEvent();
        PRbac.NewFuncModuleReq.Builder builder = PRbac.NewFuncModuleReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setFuncModule(func);
        event.setObj((Object)builder.build());
        this.action(this.hs, "601", event);
        PBase.OpStatus opStatus = (PBase.OpStatus)event.getObj(PBase.OpStatus.class);
        this.checkStatus(opStatus);
        return opStatus.getData();
    }

    @Override
    public void delFuc(String id) throws MException {
        MEvent event = new MEvent();
        PRbac.DeleteFuncModuleReq.Builder builder = PRbac.DeleteFuncModuleReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setModuleId(id);
        event.setObj((Object)builder.build());
        this.action(this.hs, "602", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void updateFunc(PRbac.FuncModule func) throws MException {
        MEvent event = new MEvent();
        PRbac.UpdateFuncModuleReq.Builder builder = PRbac.UpdateFuncModuleReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setFuncModule(func);
        event.setObj((Object)builder.build());
        this.action(this.hs, "603", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PRbac.FuncModule> getFuncs(PRbac.GetFuncModulesReq.Option option, Collection<String> funcIds) throws MException {
        LinkedList<PRbac.FuncModule> list = new LinkedList<PRbac.FuncModule>();
        boolean hasMore = false;
        String nextId = "";
        int i = 0;
        do {
            MEvent event = new MEvent();
            PRbac.GetFuncModulesReq.Builder builder = PRbac.GetFuncModulesReq.newBuilder();
            builder.setOption(option);
            PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
            if (PRbac.GetFuncModulesReq.Option.ALL.equals((Object)option)) {
                pBuilder.setPageSize(200);
                pBuilder.setStartRow(200 * i++ + 1);
                builder.setPager(pBuilder.build());
            } else if (!nextId.isEmpty()) {
                pBuilder.setNextId(nextId);
                builder.setPager(pBuilder.build());
            }
            builder.setOpUser(this.bmi.getOpUser());
            if (funcIds != null) {
                builder.addAllModuleId(funcIds);
            }
            event.setObj((Object)builder.build());
            this.action(this.hs, "609", event);
            PRbac.GetFuncModulesResp resp = (PRbac.GetFuncModulesResp)event.getObj(PRbac.GetFuncModulesResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getFuncModuleList());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
        } while (hasMore);
        return list;
    }

    @Override
    public List<String> getFuncByRole(String roleId) throws MException {
        MEvent event = new MEvent();
        PRbac.GetFuncModuleIdsViaRoleReq.Builder builder = PRbac.GetFuncModuleIdsViaRoleReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setRoleId(roleId);
        event.setObj((Object)builder.build());
        this.action(this.hs, "673", event);
        PRbac.GetFuncModuleIdsViaRoleResp resp = (PRbac.GetFuncModuleIdsViaRoleResp)event.getObj(PRbac.GetFuncModuleIdsViaRoleResp.class);
        this.checkStatus(resp.getStatus());
        LinkedList<String> list = new LinkedList<String>();
        resp.getFuncModuleIdList().forEach(item -> list.add((String)item));
        return list;
    }
}

