/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IBrokerApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.broker.PBroker;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BrokerApiImpl
extends CallApi
implements IBrokerApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.BrokerServiceDefine bro;

    @Override
    public List<PBroker.Broker> getBrokerList() throws MException {
        MEvent event = new MEvent();
        PBroker.GetBrokersReq.Builder hBuilder = PBroker.GetBrokersReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)hBuilder.build());
        this.action(this.bro, "313", event);
        PBroker.GetBrokersResp resp = (PBroker.GetBrokersResp)event.getObj(PBroker.GetBrokersResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getBrokerList();
    }

    @Override
    public String addBroker(PBroker.Broker broker) throws MException {
        MEvent event = new MEvent();
        PBroker.NewBrokerReq.Builder builder = PBroker.NewBrokerReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setBroker(broker);
        PBroker.NewBrokerReq obj = builder.build();
        event.setObj((Object)obj);
        this.action(this.bro, "310", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getData();
    }

    @Override
    public void updateBroker(PBroker.Broker broker) throws MException {
        MEvent event = new MEvent();
        PBroker.UpdateBrokerReq.Builder builder = PBroker.UpdateBrokerReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setBroker(broker);
        PBroker.UpdateBrokerReq obj = builder.build();
        event.setObj((Object)obj);
        this.action(this.bro, "312", event);
        this.checkStatus(event.getObj());
    }
}

