/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IBlacklistApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.user.PUser;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BlacklistApiImpl
extends CallApi
implements IBlacklistApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private MngServiceDefines.UserServiceDefine usd;
    private List<PUser.BlackList> blacklist = new LinkedList<PUser.BlackList>();

    @Override
    public List<PUser.BlackList> getBlacklist(int type) throws MException {
        this.blacklist.clear();
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PUser.OperateBlackListReq.Builder pBuilder = PUser.OperateBlackListReq.newBuilder();
        pBuilder.setOpUser(opUser);
        pBuilder.setOptionsValue(type);
        event.setObj((Object)pBuilder.build());
        this.action(this.usd, "180", event);
        PUser.OperateBlackListResp resp = (PUser.OperateBlackListResp)event.getObj(PUser.OperateBlackListResp.class);
        this.checkStatus(resp.getOpStatus());
        this.blacklist.addAll(resp.getListList());
        return this.blacklist;
    }

    @Override
    public void addBlacklist(PUser.BlackList bl, int type) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PUser.OperateBlackListReq.Builder pBuilder = PUser.OperateBlackListReq.newBuilder();
        pBuilder.setOpUser(opUser);
        pBuilder.setList(bl);
        pBuilder.setOptionsValue(type);
        event.setObj((Object)pBuilder.build());
        this.action(this.usd, "180", event);
        PUser.OperateBlackListResp resp = (PUser.OperateBlackListResp)event.getObj(PUser.OperateBlackListResp.class);
        this.checkStatus(resp.getOpStatus());
    }

    @Override
    public void updateBlacklist(PUser.BlackList bl, int type) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PUser.OperateBlackListReq.Builder pBuilder = PUser.OperateBlackListReq.newBuilder();
        pBuilder.setOpUser(opUser);
        pBuilder.setList(bl);
        pBuilder.setOptionsValue(type);
        event.setObj((Object)pBuilder.build());
        this.action(this.usd, "180", event);
        PUser.OperateBlackListResp resp = (PUser.OperateBlackListResp)event.getObj(PUser.OperateBlackListResp.class);
        this.checkStatus(resp.getOpStatus());
    }

    @Override
    public void delBlacklist(PUser.BlackList bl, int type) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PUser.OperateBlackListReq.Builder pBuilder = PUser.OperateBlackListReq.newBuilder();
        pBuilder.setOpUser(opUser);
        pBuilder.setList(bl);
        pBuilder.setOptionsValue(type);
        event.setObj((Object)pBuilder.build());
        this.action(this.usd, "180", event);
        PUser.OperateBlackListResp resp = (PUser.OperateBlackListResp)event.getObj(PUser.OperateBlackListResp.class);
        this.checkStatus(resp.getOpStatus());
    }

    @Override
    public void enableBlacklist(PUser.BlackList bl, int type) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.baseApi.getOpUser();
        PUser.OperateBlackListReq.Builder pBuilder = PUser.OperateBlackListReq.newBuilder();
        pBuilder.setOpUser(opUser);
        pBuilder.setList(bl);
        pBuilder.setOptionsValue(type);
        event.setObj((Object)pBuilder.build());
        this.action(this.usd, "180", event);
        PUser.OperateBlackListResp resp = (PUser.OperateBlackListResp)event.getObj(PUser.OperateBlackListResp.class);
        this.checkStatus(resp.getOpStatus());
    }
}

