/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BaseApiImpl
implements IBaseApi {
    private static Logger logger = LogManager.getLogger(BaseApiImpl.class);
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private MConfService cs;
    private String userId = "";
    private String postId = "";
    private String partyId = "";
    private String token = "";
    private String accessToken = "";
    private String cmstmxToken = "";
    private String refreshToken = "";
    private String cpu = "";
    private String pcn = "";
    private String pi = "";
    private String vol = "";
    private String osv = "";
    private String pwd = "";

    @Override
    public PBase.OpUser getOpUser() {
        PBase.OpUser.Builder builder = PBase.OpUser.newBuilder();
        builder.setPostId(this.postId);
        builder.setUserId(this.userId);
        builder.setPartyId(this.partyId);
        String ip = this.eCore.get((Object)"ip") == null ? "NA" : (String)this.eCore.get((Object)"ip");
        ip = CommUtils.getIP().equals(this.eCore.get((Object)"ip")) || this.eCore.get((Object)"ip") == null ? "NA" : (String)this.eCore.get((Object)"ip");
        String mac = CommUtils.getMAC();
        builder.setIp(ip);
        builder.setMac(mac);
        builder.setLocalIp(CommUtils.getIP());
        builder.setCpu(CommUtils.getCPUSerial());
        builder.setPcn(CommUtils.getPCName());
        builder.setPi(CommUtils.getPI());
        builder.setVol(CommUtils.getVolNew());
        builder.setOsv(CommUtils.getOSV());
        builder.setTerminalType("PC");
        builder.setTerminalName("T-master");
        builder.setTerminalVersion("V" + this.cs.getProps("client.properties").getDesValue("client_version"));
        builder.setPort("NA".equals(ip) ? -1 : this.eCore.getInt("port"));
        if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)mac)) {
            logger.error("ip\u6216mac\u4e3a\u7a7a\uff1aip = " + ip + " | mac = " + mac);
        }
        builder.setSn(CommUtils.getSerialNumber());
        builder.setUuid(this.eCore.getStr("uuid"));
        builder.setDatetime(DateTimeUtils.getTimeStamp());
        JsonObject jsonObj = new JsonObject();
        jsonObj.add("terminal_name", (JsonElement)new JsonPrimitive("T-master"));
        jsonObj.add("terminal_version", (JsonElement)new JsonPrimitive("V" + this.cs.getProps("client.properties").getDesValue("client_version")));
        jsonObj.add("broker_id", (JsonElement)new JsonPrimitive("99999"));
        jsonObj.add("v_mac_flag", (JsonElement)new JsonPrimitive(CommUtils.isVirtual() ? "1" : "0"));
        jsonObj.add("port", (JsonElement)new JsonPrimitive("NA".equals(ip) ? "NA" : String.valueOf(this.eCore.getInt("port"))));
        String json = jsonObj.toString().replace(",", "$");
        builder.setText(json);
        return builder.build();
    }

    @Override
    public PBase.OpUser getOpUserWithOutCpu() {
        PBase.OpUser.Builder builder = PBase.OpUser.newBuilder();
        builder.setPostId(this.postId);
        builder.setUserId(this.userId);
        builder.setPartyId(this.partyId);
        String ip = this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip");
        String mac = CommUtils.getMAC();
        builder.setIp(ip);
        builder.setMac(mac);
        builder.setLocalIp(CommUtils.getIP());
        builder.setPcn(CommUtils.getPCName());
        builder.setPi(CommUtils.getPI());
        builder.setVol(CommUtils.getVolNew());
        builder.setOsv(CommUtils.getOSV());
        builder.setTerminalType("PC");
        builder.setTerminalName("T-master");
        builder.setTerminalVersion("V" + this.cs.getProps("client.properties").getDesValue("client_version"));
        if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)mac)) {
            logger.error("ip\u6216mac\u4e3a\u7a7a\uff1aip = " + ip + " | mac = " + mac);
        }
        builder.setSn(CommUtils.getSerialNumber());
        builder.setUuid(this.eCore.getStr("uuid"));
        builder.setDatetime(DateTimeUtils.getTimeStamp());
        return builder.build();
    }

    @Override
    public PBase.Page getDefPage() {
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(150);
        builder.setStartRow(1);
        return builder.build();
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public void setPostId(String postId) {
        this.postId = postId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getPostId() {
        return this.postId;
    }

    @Override
    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    @Override
    public String getPartyId() {
        return this.partyId;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public PBase.Fragment getFragment(int total) {
        PBase.Fragment.Builder builder = PBase.Fragment.newBuilder();
        builder.setTotalFragNum(total / 150 + 1);
        builder.setTotalDataNum(total);
        return builder.build();
    }

    @Override
    public String getCpu() {
        return this.cpu;
    }

    @Override
    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    @Override
    public String getPcn() {
        return this.pcn;
    }

    @Override
    public void setPcn(String pcn) {
        this.pcn = pcn;
    }

    @Override
    public String getPi() {
        return this.pi;
    }

    @Override
    public void setPi(String pi) {
        this.pi = pi;
    }

    @Override
    public String getVol() {
        return this.vol;
    }

    @Override
    public void setVol(String vol) {
        this.vol = vol;
    }

    @Override
    public String getOsv() {
        return this.osv;
    }

    @Override
    public void setOsv(String osv) {
        this.osv = osv;
    }

    @Override
    public String getPwd() {
        return this.pwd;
    }

    @Override
    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public String getCmstmxToken() {
        return this.cmstmxToken;
    }

    @Override
    public void setCmstmxToken(String cmstmxToken) {
        this.cmstmxToken = cmstmxToken;
    }

    @Override
    public String getVersion() {
        return this.cs.getProps("client.properties").getDesValue("client_version");
    }
}

