/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.assetgroup.PAssetgroupService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AssetGrpApiImpl
extends CallApi
implements IAssetGrpApi {
    @Inject
    private BaseApiImpl bai;
    @Inject
    private MngServiceDefines.AssetGrpServiceDefine ags;

    @Override
    public String addAssetGrp(PAssetgroupService.AssetGroup assetGroup) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.NewAssetGroupReq.Builder obj = PAssetgroupService.NewAssetGroupReq.newBuilder();
        obj.setOpUser(this.bai.getOpUser());
        obj.setAssetGroup(assetGroup);
        event.setObj((Object)obj.build());
        this.action(this.ags, "100", event);
        PAssetgroupService.NewAssetGroupResp resp = (PAssetgroupService.NewAssetGroupResp)event.getObj(PAssetgroupService.NewAssetGroupResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getAssetGroupId();
    }

    @Override
    public List<PAssetgroupService.AssetGroup> getAssetGrps(String partyId, Boolean all) throws MException {
        LinkedList<PAssetgroupService.AssetGroup> list = new LinkedList<PAssetgroupService.AssetGroup>();
        list.addAll(this.getAssetGrpsByPartyId(partyId, PAssetgroupService.GetAssetGroupViaPartyIdReq.Option.GET_ONE));
        if (all.booleanValue()) {
            list.addAll(this.getAssetGrpsByPartyId(partyId, PAssetgroupService.GetAssetGroupViaPartyIdReq.Option.GET_OFFSPRING));
        }
        return list;
    }

    private List<PAssetgroupService.AssetGroup> getAssetGrpsByPartyId(String partyId, PAssetgroupService.GetAssetGroupViaPartyIdReq.Option option) throws MException {
        PAssetgroupService.GetAssetGroupResp resp;
        ArrayList<PAssetgroupService.AssetGroup> list = new ArrayList<PAssetgroupService.AssetGroup>();
        boolean hasMore = false;
        int startRow = 1;
        do {
            block3: {
                MEvent event = new MEvent();
                PAssetgroupService.GetAssetGroupViaPartyIdReq.Builder builder = PAssetgroupService.GetAssetGroupViaPartyIdReq.newBuilder();
                builder.setOpUser(this.bai.getOpUser());
                builder.setPartyId(partyId);
                builder.setOption(option);
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setPageSize(150);
                pBuilder.setStartRow(startRow);
                startRow += 150;
                builder.setPager(pBuilder.build());
                event.setObj((Object)builder.build());
                this.action(this.ags, "104", event);
                resp = (PAssetgroupService.GetAssetGroupResp)event.getObj(PAssetgroupService.GetAssetGroupResp.class);
                try {
                    this.checkStatus(resp.getStatus());
                }
                catch (MException e) {
                    if (e.getCode() == 3066) break block3;
                    throw e;
                }
            }
            list.addAll(resp.getAssetGroupList());
        } while (hasMore = resp.getPagination().getHasMore());
        return list;
    }

    @Override
    public void updateAssetGrp(PAssetgroupService.AssetGroup build) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.UpdateAssetGroupReq.Builder builder = PAssetgroupService.UpdateAssetGroupReq.newBuilder();
        builder.setOpUser(this.bai.getOpUser());
        builder.setAssetGroup(build);
        event.setObj((Object)builder.build());
        this.action(this.ags, "102", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void addAssets(PAssetgroupService.AssetGroup build) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.AddAssetsReq.Builder builder = PAssetgroupService.AddAssetsReq.newBuilder();
        builder.setOpUser(this.bai.getOpUser());
        builder.setAssetGroup(build);
        event.setObj((Object)builder.build());
        this.action(this.ags, "101", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void delAssetGrp(String assetGrpId) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.DeleteAssetGroupReq.Builder builder = PAssetgroupService.DeleteAssetGroupReq.newBuilder();
        builder.setOpUser(this.bai.getOpUser());
        builder.setAssetGroupId(assetGrpId);
        event.setObj((Object)builder.build());
        this.action(this.ags, "103", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void enableAssetGrp(String assetGrpId, boolean enabled) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.EnableAssetGroupReq.Builder builder = PAssetgroupService.EnableAssetGroupReq.newBuilder();
        builder.setOpUser(this.bai.getOpUser());
        builder.setAssetGroupId(assetGrpId);
        builder.setEnabled(enabled);
        event.setObj((Object)builder.build());
        this.action(this.ags, "107", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public PAssetgroupService.AssetGroup getAssetGrpDetail(String assetGrpId) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.GetAssetGroupDetailReq.Builder builder = PAssetgroupService.GetAssetGroupDetailReq.newBuilder();
        builder.setOpUser(this.bai.getOpUser());
        builder.setAssetGroupId(assetGrpId);
        event.setObj((Object)builder.build());
        this.action(this.ags, "106", event);
        PAssetgroupService.GetAssetGroupDetailResp resp = (PAssetgroupService.GetAssetGroupDetailResp)event.getObj(PAssetgroupService.GetAssetGroupDetailResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getAssetGroup();
    }

    @Override
    public List<String> getAssetGrpIdsByPost(String postId) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.GetAssetGroupIdsViaPostIdReq.Builder builder = PAssetgroupService.GetAssetGroupIdsViaPostIdReq.newBuilder();
        builder.setOpUser(this.bai.getOpUser());
        builder.setPostId(postId);
        event.setObj((Object)builder.build());
        this.action(this.ags, "105", event);
        PAssetgroupService.GetAssetGroupIdsViaPostIdResp resp = (PAssetgroupService.GetAssetGroupIdsViaPostIdResp)event.getObj(PAssetgroupService.GetAssetGroupIdsViaPostIdResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getAssetGroupIdList();
    }

    @Override
    public void assignAssetGrpToPost(List<String> setAssetGrpIds, String postId) throws MException {
        MEvent event = new MEvent();
        PAssetgroupService.AssignAssetGroup2PostReq.Builder builder = PAssetgroupService.AssignAssetGroup2PostReq.newBuilder();
        builder.setOpUser(this.bai.getOpUser());
        builder.setPostId(postId);
        builder.addAllAssetGroupId(setAssetGrpIds);
        event.setObj((Object)builder.build());
        this.action(this.ags, "108", event);
        this.checkStatus(event.getObj());
    }
}

