/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IAccountGrpApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.account.PExtAccnt;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AccountGrpApiImpl
extends CallApi
implements IAccountGrpApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hs;
    @Inject
    private MngServiceDefines.AccntGrpServiceDefine accntGrp;

    @Override
    public List<String> getAccountGrpByPartyId(String partyId) throws MException {
        LinkedList<String> list = new LinkedList<String>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PHierarchy.GetAccntGroupIdsViaPartyReq.Builder builder = PHierarchy.GetAccntGroupIdsViaPartyReq.newBuilder();
            builder.setOpUser(this.bmi.getOpUser());
            builder.setPartyId(partyId);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                builder.setPager(pBuilder.build());
            }
            event.setObj((Object)builder.build());
            this.action(this.hs, "742", event);
            PHierarchy.GetAccntGroupIdsViaPartyResp resp = (PHierarchy.GetAccntGroupIdsViaPartyResp)event.getObj(PHierarchy.GetAccntGroupIdsViaPartyResp.class);
            list.addAll((Collection<String>)resp.getGroupIdList());
            this.checkStatus(resp.getStatus());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
        } while (hasMore);
        return list;
    }

    @Override
    public List<PExtAccnt.AccountGroupDetails> getAccountGrpList(List<String> ids) throws MException {
        ArrayList<PExtAccnt.AccountGroupDetails> liste = new ArrayList<PExtAccnt.AccountGroupDetails>();
        int m = ids.size() / 200;
        int n = ids.size() % 200;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            list = i == m ? ids.subList(m * 200, m * 200 + n) : ids.subList(i * 200, (i + 1) * 200);
            liste.addAll(this.getTwoHundredAccountGrp(list));
            ++i;
        }
        return liste;
    }

    private List<PExtAccnt.AccountGroupDetails> getTwoHundredAccountGrp(List<String> ids) throws MException {
        MEvent event = new MEvent();
        ArrayList<PExtAccnt.AccountGroupDetails> list = new ArrayList<PExtAccnt.AccountGroupDetails>();
        if (ids.size() > 0) {
            PExtAccnt.GetAccountGroupsReq.Builder builder = PExtAccnt.GetAccountGroupsReq.newBuilder();
            builder.setOpUser(this.bmi.getOpUser());
            builder.addAllGroupId(ids);
            event.setObj((Object)builder.build());
            this.action(this.accntGrp, "163", event);
            PExtAccnt.GetAccountGroupsResp resp = (PExtAccnt.GetAccountGroupsResp)event.getObj(PExtAccnt.GetAccountGroupsResp.class);
            this.checkStatus(resp.getStatus());
            list.addAll(resp.getDetailsList());
        }
        return list;
    }

    @Override
    public String addAccountGrp(PExtAccnt.AccountGroup accountGrp, String partyId) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.NewAccountGroupReq.Builder builder = PExtAccnt.NewAccountGroupReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setGroup(accountGrp);
        builder.setPartyId(partyId);
        PExtAccnt.NewAccountGroupReq obj = builder.build();
        event.setObj((Object)obj);
        this.action(this.accntGrp, "160", event);
        this.checkStatus(event.getObj());
        return ((PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj())).getData();
    }

    @Override
    public void updateAccountGrp(PExtAccnt.AccountGroup accountGrp) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.UpdateAccountGroupReq.Builder builderReq = PExtAccnt.UpdateAccountGroupReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.setGroup(accountGrp);
        PExtAccnt.UpdateAccountGroupReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.accntGrp, "162", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void deleteAccountGrp(String id) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.DeleteAccountGroupReq.Builder builder = PExtAccnt.DeleteAccountGroupReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setId(id);
        PExtAccnt.DeleteAccountGroupReq req = builder.build();
        event.setObj((Object)req);
        this.action(this.accntGrp, "161", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<String> GetAccountGroupDetails(String grpId) throws MException {
        MEvent event = new MEvent();
        ArrayList<String> list = new ArrayList<String>();
        PExtAccnt.GetAccountGroupDetailsReq.Builder builder = PExtAccnt.GetAccountGroupDetailsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setGroupId(grpId);
        PExtAccnt.GetAccountGroupDetailsReq req = builder.build();
        event.setObj((Object)req);
        this.action(this.accntGrp, "164", event);
        PExtAccnt.GetAccountGroupDetailsResp resp = (PExtAccnt.GetAccountGroupDetailsResp)event.getObj(PExtAccnt.GetAccountGroupDetailsResp.class);
        this.checkStatus(resp.getStatus());
        list.addAll((Collection<String>)resp.getAccountIdList());
        return list;
    }

    @Override
    public void AssignAccountsToGroup(String grpId, int grpType, Collection<PExtAccnt.AssignedAccountDetails> account, PCommon.Operation action) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.AssignAccountsToGroupReq.Builder builder = PExtAccnt.AssignAccountsToGroupReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setGroupId(grpId);
        builder.setGroupType(grpType);
        builder.setOperation(action);
        for (PExtAccnt.AssignedAccountDetails detail : account) {
            builder.addDetails(detail);
        }
        PExtAccnt.AssignAccountsToGroupReq req = builder.build();
        event.setObj((Object)req);
        this.action(this.accntGrp, "165", event);
        this.checkStatus(event.getObj());
    }
}

