/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.mng.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.DataServiceDefines;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.mng.IAccountApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.datatype.message.PMarketService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.account.PExtAccnt;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.product.PProduct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AccountApiImpl
extends CallApi
implements IAccountApi {
    private static final Logger logger = LogManager.getLogger(AccountApiImpl.class);
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.AccntServiceDefine accnt;
    @Inject
    private MngServiceDefines.AccntLoginServiceDefine accntLog;
    @Inject
    private DataServiceDefines.RefServiceDefine refDef;
    @Inject
    private MngServiceDefines.HierachyServiceDefine hs;
    @Inject
    private MngServiceDefines.ProductServiceDefine psd;
    @Inject
    private MngServiceDefines.CommissionDefine msd;

    @Override
    public List<String> getAccountIdListByPartyId(String partyId, PCommon.AssignType type, PHierarchy.GetExtAccntIdsViaPartyReq.Option option) throws MException {
        LinkedList<String> list = new LinkedList<String>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PHierarchy.GetExtAccntIdsViaPartyReq.Builder builder = PHierarchy.GetExtAccntIdsViaPartyReq.newBuilder();
            builder.setOpUser(this.bmi.getOpUser());
            builder.setPartyId(partyId);
            builder.setOption(option);
            builder.setAssignType(type);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                builder.setPager(pBuilder.build());
            }
            event.setObj((Object)builder.build());
            this.action(this.hs, "642", event);
            PHierarchy.GetExtAccntIdsViaPartyResp resp = (PHierarchy.GetExtAccntIdsViaPartyResp)event.getObj(PHierarchy.GetExtAccntIdsViaPartyResp.class);
            list.addAll((Collection<String>)resp.getExtAccntIdList());
            this.checkStatus(resp.getStatus());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
        } while (hasMore);
        return list;
    }

    @Override
    public List<PExtAccnt.ExtAccntDetails> getAccountList(List<String> ids) throws MException {
        ArrayList<PExtAccnt.ExtAccntDetails> liste = new ArrayList<PExtAccnt.ExtAccntDetails>();
        int m = ids.size() / 200;
        int n = ids.size() % 200;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            list = i == m ? ids.subList(m * 200, m * 200 + n) : ids.subList(i * 200, (i + 1) * 200);
            liste.addAll(this.getTwoHundredAccount(list));
            ++i;
        }
        return liste;
    }

    private List<PExtAccnt.ExtAccntDetails> getTwoHundredAccount(List<String> ids) throws MException {
        MEvent event = new MEvent();
        ArrayList<PExtAccnt.ExtAccntDetails> liste = new ArrayList<PExtAccnt.ExtAccntDetails>();
        if (ids.size() > 0) {
            PExtAccnt.GetExtAccntsReq.Builder builder = PExtAccnt.GetExtAccntsReq.newBuilder();
            builder.setOpUser(this.bmi.getOpUser());
            builder.addAllExtAccntId(ids);
            event.setObj((Object)builder.build());
            this.action(this.accnt, "105", event);
            PExtAccnt.GetExtAccntsResp resp = (PExtAccnt.GetExtAccntsResp)event.getObj(PExtAccnt.GetExtAccntsResp.class);
            this.checkStatus(resp.getStatus());
            liste.addAll(resp.getDetailsList());
        }
        return liste;
    }

    @Override
    public List<String> getAccountIdListByPostId(String postId) throws MException {
        LinkedList<String> list = new LinkedList<String>();
        boolean hasMore = false;
        String nextId = "";
        do {
            MEvent event = new MEvent();
            PHierarchy.GetExtAccntIdsViaPostReq.Builder hBuilder = PHierarchy.GetExtAccntIdsViaPostReq.newBuilder();
            hBuilder.setOpUser(this.bmi.getOpUser());
            hBuilder.setPostId(postId);
            if (!nextId.isEmpty()) {
                PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
                pBuilder.setNextId(nextId);
                hBuilder.setPager(pBuilder.build());
            }
            event.setObj((Object)hBuilder.build());
            this.action(this.hs, "691", event);
            PHierarchy.GetExtAccntIdsViaPostResp resp = (PHierarchy.GetExtAccntIdsViaPostResp)event.getObj(PHierarchy.GetExtAccntIdsViaPostResp.class);
            this.checkStatus(resp.getStatus());
            hasMore = resp.getPagination().getHasMore();
            nextId = resp.getPagination().getNextId();
            list.addAll((Collection<String>)resp.getExtAccntIdList());
        } while (hasMore);
        logger.error("\u6839\u636e\u804c\u4f4dID\u67e5\u4e00\u7ea7\u8d26\u6237   postID: " + postId + " , extAccntIdList: " + list);
        return list;
    }

    @Override
    public List<String> getAccountIdListByProductId(List<String> productIds) throws MException {
        LinkedList<String> list = new LinkedList<String>();
        MEvent event = new MEvent();
        PProduct.GetAccntIdsViaProductReq.Builder hBuilder = PProduct.GetAccntIdsViaProductReq.newBuilder();
        hBuilder.setOpUser(this.bmi.getOpUser());
        hBuilder.addAllProductId(productIds);
        event.setObj((Object)hBuilder.build());
        this.action(this.psd, "737", event);
        PProduct.GetAccntIdsViaProductResp resp = (PProduct.GetAccntIdsViaProductResp)event.getObj(PProduct.GetAccntIdsViaProductResp.class);
        this.checkStatus(resp.getStatus());
        resp.getDetailsList().forEach(item -> {
            if (item.getTypeValue() == 1) {
                list.add(item.getAccntId());
            }
        });
        return list;
    }

    @Override
    public String addAccount(PExtAccnt.ExtAccnt account, String id) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.NewExtAccntReq.Builder accountBuilder = PExtAccnt.NewExtAccntReq.newBuilder();
        accountBuilder.setOpUser(this.bmi.getOpUser());
        accountBuilder.setExtAccnt(account);
        accountBuilder.setOwnedPartyId(id);
        PExtAccnt.NewExtAccntReq obj = accountBuilder.build();
        event.setObj((Object)obj);
        this.action(this.accnt, "101", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getData();
    }

    @Override
    public void updateAccount(PExtAccnt.ExtAccnt account, String partyId) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.UpdateExtAccntReq.Builder builderReq = PExtAccnt.UpdateExtAccntReq.newBuilder();
        builderReq.setOpUser(this.bmi.getOpUser());
        builderReq.setExtAccnt(account);
        builderReq.setOwnedPartyId(partyId);
        PExtAccnt.UpdateExtAccntReq req = builderReq.build();
        event.setObj((Object)req);
        this.action(this.accnt, "104", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public int checkAccontPwd(String pwd, String id) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.VerifyExtAccntPasswordReq.Builder builder2 = PExtAccnt.VerifyExtAccntPasswordReq.newBuilder();
        builder2.setExtAccntId(id);
        builder2.setPassword(pwd);
        builder2.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)builder2.build());
        this.action(this.accnt, "108", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getStatus();
    }

    @Override
    public int enableAccount(Boolean isEnable, String id) throws MException {
        MEvent event = new MEvent();
        PExtAccnt.EnableExtAccntReq.Builder builder2 = PExtAccnt.EnableExtAccntReq.newBuilder();
        builder2.setEnabled(isEnable.booleanValue());
        builder2.setExtAccntId(id);
        builder2.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)builder2.build());
        this.action(this.accnt, "107", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getStatus();
    }

    @Override
    public void loginAccntReq(PExtAccnt.ExtAccnt account, String marketGrp) throws MException {
        MEvent event = new MEvent();
        PMainTenance.LoginRequest.Builder builder = PMainTenance.LoginRequest.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setAccount(account.getInvestorId());
        builder.setBrokerId(account.getBrokerId());
        builder.setPassword(account.getPassword());
        builder.setMarketGrp(marketGrp);
        event.setObj((Object)builder.build());
        this.action(this.accntLog, "223", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void loginAccntRefDataReq(PExtAccnt.ExtAccnt account, String marketGrp) throws MException {
        MEvent event = new MEvent();
        PMainTenance.LoginRequest.Builder builder = PMainTenance.LoginRequest.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setAccount(account.getInvestorId());
        builder.setBrokerId(account.getBrokerId());
        builder.setPassword(account.getPassword());
        builder.setMarketGrp(marketGrp);
        event.setObj((Object)builder.build());
        this.action(this.refDef, "256", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void logoutAccntReq(PExtAccnt.ExtAccnt account, String marketGrp) throws MException {
        MEvent event = new MEvent();
        PMainTenance.LogoutRequest.Builder builder = PMainTenance.LogoutRequest.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setInvestorId(account.getInvestorId());
        builder.setBrokerId(account.getBrokerId());
        builder.setMarketGrp(marketGrp);
        event.setObj((Object)builder.build());
        this.action(this.accntLog, "226", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PMainTenance.AccntStatus> getLoginStatus(String marketGrp, List<String> investorIds) throws MException {
        LinkedList<PMainTenance.AccntStatus> list = new LinkedList<PMainTenance.AccntStatus>();
        MEvent event = new MEvent();
        PMainTenance.GetLoginStatusReq.Builder builder = PMainTenance.GetLoginStatusReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.addAllInvestorId(investorIds);
        event.setObj((Object)builder.build());
        this.action(this.accntLog, "228", event);
        PMainTenance.GetLoginStatusRsp resp = (PMainTenance.GetLoginStatusRsp)event.getObj(PMainTenance.GetLoginStatusRsp.class);
        this.checkStatus(resp.getStatus());
        list.addAll(resp.getAccntStatusList());
        return list;
    }

    @Override
    public List<PMarketService.Commission> getCommissions(PMarketService.Commissions commissions) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)commissions);
        this.action(this.msd, "412", event);
        PMarketService.Commissions com = (PMarketService.Commissions)event.getObj(PMarketService.Commissions.class);
        return com.getCommissionList();
    }

    @Override
    public void addCommissions(PMarketService.Commissions commissions) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)commissions);
        this.action(this.msd, "410", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void delCommissions(PMarketService.Commissions commissions) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)commissions);
        this.action(this.msd, "411", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public void resetAccontPwd(PMainTenance.ModifyPasswdRequest.Builder builder) throws MException {
        MEvent event = new MEvent();
        builder.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)builder.build());
        this.action(this.accntLog, "258", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PHierarchy.ExternalAsset> getExternalAssets(PHierarchy.ExtAssetType extAsset) throws MException {
        MEvent event = new MEvent();
        PHierarchy.GetExternalAssetsReq.Builder builder = PHierarchy.GetExternalAssetsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setExtAssetTyep(extAsset);
        event.setObj((Object)builder.build());
        this.action(this.hs, "719", event);
        PHierarchy.GetExternalAssetsResp resp = (PHierarchy.GetExternalAssetsResp)event.getObj(PHierarchy.GetExternalAssetsResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getExtAssetList();
    }

    @Override
    public void alertAccount(PExtAccnt.AlterAccntTradeElementsReq.Builder req) throws MException {
        MEvent event = new MEvent();
        req.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)req.build());
        this.action(this.accnt, "182", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public PExtAccnt.GetAlterAccntTradeElementsResp getAlterRecord(PExtAccnt.GetAlterAccntTradeElementsReq.Builder req) throws MException {
        MEvent event = new MEvent();
        req.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)req.build());
        this.action(this.accnt, "183", event);
        PExtAccnt.GetAlterAccntTradeElementsResp resp = (PExtAccnt.GetAlterAccntTradeElementsResp)event.getObj(PExtAccnt.GetAlterAccntTradeElementsResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp;
    }
}

