/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.instruction.impl;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.instruction.IResourceApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.PResource;
import cms.tmx.datatype.proto.trade.PResourceService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ResourceImpl
extends CallApi
implements IResourceApi {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private TradeServiceDefines.ResourceServiceDefine resourceSD;
    private static int RMT_RESOURCE_ID = 1;
    private static int RMT_REFERENCE = 2;

    @Override
    public List<PResource.Resource> getResource(String refId, int type, String marketGrp, String beginTime, String endTime) throws MException {
        MEvent event = new MEvent();
        PResourceService.GetResourcesReq.Builder builder = PResourceService.GetResourcesReq.newBuilder();
        PResourceService.ResourceMeta.Builder meta = PResourceService.ResourceMeta.newBuilder();
        meta.setReference(refId);
        meta.setTypeValue(type);
        builder.addMeta(meta);
        builder.setMetaTypeValue(RMT_REFERENCE);
        builder.setMarketGrp(marketGrp);
        builder.setOpUser(this.bmi.getOpUser());
        builder.setBeginTime(beginTime);
        builder.setEndTime(endTime);
        event.setObj((Object)builder.build());
        this.action(this.resourceSD, "374", event);
        PResourceService.GetResourcesResp resp = (PResourceService.GetResourcesResp)event.getObj(PResourceService.GetResourcesResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getResourceList();
    }

    @Override
    public PResource.Resource createResource(String refId, int type, String marketGrp, long expectationQty) throws MException {
        MEvent event = new MEvent();
        PResourceService.AllocateResourceReq.Builder builder = PResourceService.AllocateResourceReq.newBuilder();
        builder.setReference(refId);
        builder.setTypeValue(type);
        builder.setMarketGrp(marketGrp);
        builder.setTotalExpectationQty((double)expectationQty);
        builder.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)builder.build());
        this.action(this.resourceSD, "371", event);
        PResourceService.AllocateResourceResp resp = (PResourceService.AllocateResourceResp)event.getObj(PResourceService.AllocateResourceResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getResource();
    }

    @Override
    public List<PResource.Resource> getResource(List<String> list) throws MException {
        MEvent event = new MEvent();
        PResourceService.GetResourcesReq.Builder builder = PResourceService.GetResourcesReq.newBuilder();
        if (list != null && !list.isEmpty()) {
            for (String resId : list) {
                PResourceService.ResourceMeta.Builder meta = PResourceService.ResourceMeta.newBuilder();
                meta.setResourceId(resId);
                builder.addMeta(meta);
            }
        }
        builder.setMetaTypeValue(RMT_RESOURCE_ID);
        builder.setMarketGrp("CCS");
        builder.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)builder.build());
        this.action(this.resourceSD, "374", event);
        PResourceService.GetResourcesResp resp = (PResourceService.GetResourcesResp)event.getObj(PResourceService.GetResourcesResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getResourceList();
    }

    @Override
    public void cancelResource(String resourceId, String marketGrp) throws MException {
        MEvent event = new MEvent();
        PResourceService.CancelResourceReq.Builder builder = PResourceService.CancelResourceReq.newBuilder();
        builder.setResourceId(resourceId);
        builder.setMarketGrp(marketGrp);
        builder.setOpUser(this.bmi.getOpUser());
        event.setObj((Object)builder.build());
        this.action(this.resourceSD, "376", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PResource.Resource> getResource(Map<String, Integer> refMap, String beginTime, String endTime) throws MException {
        LinkedList<PResource.Resource> resourceList = new LinkedList<PResource.Resource>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.getResourceByPage(resourceList, refMap, beginTime, endTime, defPage, i);
        return resourceList;
    }

    public void getResourceByPage(List<PResource.Resource> resourceList, Map<String, Integer> refMap, String beginTime, String endTime, PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        PResourceService.GetResourcesReq.Builder builder = PResourceService.GetResourcesReq.newBuilder();
        if (refMap != null && !refMap.isEmpty()) {
            for (String refId : refMap.keySet()) {
                PResourceService.ResourceMeta.Builder meta = PResourceService.ResourceMeta.newBuilder();
                meta.setReference(refId);
                meta.setTypeValue(refMap.get(refId).intValue());
                builder.addMeta(meta);
            }
        }
        builder.setMetaTypeValue(RMT_REFERENCE);
        builder.setMarketGrp("CCS");
        builder.setOpUser(this.bmi.getOpUser());
        builder.setPage(defPage);
        builder.setBeginTime(beginTime);
        builder.setEndTime(endTime);
        event.setObj((Object)builder.build());
        this.action(this.resourceSD, "374", event);
        PResourceService.GetResourcesResp resp = (PResourceService.GetResourcesResp)event.getObj(PResourceService.GetResourcesResp.class);
        this.checkStatus(resp.getStatus());
        resourceList.addAll(resp.getResourceList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.getResourceByPage(resourceList, refMap, beginTime, endTime, pageBuilder.build(), i);
        }
    }
}

