/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.instruction.impl;

import cms.tmx.api.CallApi;
import cms.tmx.api.MngServiceDefines;
import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.trade.PInstructionService;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class InstructionApiImpl<T>
extends CallApi
implements IInstructionApi<T> {
    @Inject
    private BaseApiImpl bmi;
    @Inject
    private MngServiceDefines.InstructionServiceDefine insSD;

    @Override
    public List<PInstruction.Instruction> getInstructions(int type) throws MException {
        LinkedList<PInstruction.Instruction> instructionList = new LinkedList<PInstruction.Instruction>();
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(100);
        builder.setStartRow(1);
        PBase.Page defPage = builder.build();
        int i = 0;
        this.getInstructionsByPage(instructionList, defPage, i, type, new LinkedList<String>(), new LinkedList<String>());
        return instructionList;
    }

    @Override
    public List<PInstruction.Instruction> queryHisInstructions(IHisQueryPageInfo<T> page, int type, Integer i) throws MException {
        MEvent event = new MEvent();
        PBase.OpUser opUser = this.bmi.getOpUser();
        PInstructionManagement.GetInstructionsReq.Builder builder = PInstructionManagement.GetInstructionsReq.newBuilder();
        builder.setOpUser(opUser);
        builder.setStartTime(page.getBeginDate());
        builder.setFinishTime(page.getEndDate());
        builder.setTypeValue(type);
        builder.setKey(page.getReferenceId());
        builder.setSecurityId(page.getSecurityId());
        String dimension = page.getDimension();
        if (dimension.equals("1")) {
            builder.addAllAccntId(page.getAccountIdList());
        } else if (dimension.equals("2")) {
            builder.addAllPortfolioId(page.getPortfolioIdList());
        }
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<PInstruction.Instruction> instructionList = new LinkedList<PInstruction.Instruction>();
        PInstructionManagement.GetInstructionsResp resp = null;
        page.initParam();
        do {
            page.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action(this.insSD, "782", event);
            resp = (PInstructionManagement.GetInstructionsResp)event.getObj(PInstructionManagement.GetInstructionsResp.class);
            this.checkStatus(resp.getStatus());
            instructionList.addAll(resp.getInstructionList());
            page.setMod(page.getMod() + pageBuilder.getPageSize() - resp.getInstructionList().size());
            page.setStart(page.getStart() - pageBuilder.getPageSize() + resp.getInstructionList().size());
        } while (page.hasNext(resp.getPage().getTotalRow()));
        return instructionList;
    }

    @Override
    public List<PInstruction.Instruction> getInstructions(int type, List<String> listBeQuery, List<String> clIds) throws MException {
        LinkedList<PInstruction.Instruction> instructionList = new LinkedList<PInstruction.Instruction>();
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(100);
        builder.setStartRow(1);
        PBase.Page defPage = builder.build();
        int i = 0;
        this.getInstructionsByPage(instructionList, defPage, i, type, listBeQuery, clIds);
        return instructionList;
    }

    private void getInstructionsByPage(List<PInstruction.Instruction> instructionList, PBase.Page defPage, int i, int type, List<String> listBeQuery, List<String> clIds) throws MException {
        MEvent event = new MEvent();
        PInstructionManagement.GetInstructionsReq.Builder iBuilder = PInstructionManagement.GetInstructionsReq.newBuilder();
        iBuilder.setOpUser(this.bmi.getOpUser());
        iBuilder.setPage(defPage);
        iBuilder.setTypeValue(type);
        if (listBeQuery != null && !listBeQuery.isEmpty()) {
            iBuilder.addAllInstructionId(listBeQuery);
        }
        if (clIds != null && !clIds.isEmpty()) {
            iBuilder.addAllClInstructionId(clIds);
        }
        event.setObj((Object)iBuilder.build());
        this.action(this.insSD, "782", event);
        PInstructionManagement.GetInstructionsResp resp = (PInstructionManagement.GetInstructionsResp)event.getObj(PInstructionManagement.GetInstructionsResp.class);
        this.checkStatus(resp.getStatus());
        instructionList.addAll(resp.getInstructionList());
        if (resp.getInstructionList().size() == 0 || resp.getInstructionList().size() == resp.getPage().getTotalRow()) {
            return;
        }
        for (PInstruction.Instruction ins : instructionList) {
            listBeQuery.remove(ins.getInstructionId());
        }
        PBase.Page.Builder pageBuilder = defPage.toBuilder();
        pageBuilder.setStartRow(defPage.getStartRow() + resp.getInstructionList().size());
        this.getInstructionsByPage(instructionList, pageBuilder.build(), i, type, listBeQuery, clIds);
    }

    @Override
    public String newInstruction(PInstruction.Instruction ins, int actionId) throws MException {
        return this.newInstruction(ins, null, null, actionId);
    }

    @Override
    public void updateInstruction(PInstruction.Instruction ins, int action) throws MException {
    }

    @Override
    public String submitInstruction(String instructionId, String postil) throws MException {
        MEvent event = new MEvent();
        PInstructionManagement.SubmitInstructionReq.Builder subBuilder = PInstructionManagement.SubmitInstructionReq.newBuilder();
        subBuilder.setOpUser(this.bmi.getOpUser());
        subBuilder.setInstructionId(instructionId);
        subBuilder.setRemark(postil);
        event.setObj((Object)subBuilder.build());
        this.action(this.insSD, "785", event);
        PInstructionManagement.SubmitInstructionResp resp = (PInstructionManagement.SubmitInstructionResp)event.getObj(PInstructionManagement.SubmitInstructionResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getStatus().getData();
    }

    @Override
    public String newInstruction(PInstruction.Instruction ins, PBase.Fragment fragment, String uuid, int actionId) throws MException {
        MEvent event = new MEvent();
        PInstructionManagement.NewInstructionReq.Builder iBuilder = PInstructionManagement.NewInstructionReq.newBuilder();
        iBuilder.setOpUser(this.bmi.getOpUser());
        iBuilder.setInstruction(ins);
        PInstructionManagement.InstructionContext.Builder contextB = PInstructionManagement.InstructionContext.newBuilder();
        contextB.setActionId(actionId);
        iBuilder.setContext(contextB.build());
        if (fragment != null) {
            iBuilder.setFragment(fragment);
        }
        if (!StringUtils.isEmpty((String)uuid)) {
            iBuilder.setBatchId(uuid);
        }
        event.setObj((Object)iBuilder.build());
        this.action(this.insSD, "780", event);
        this.checkStatus(event.getObj());
        PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(event.getObj());
        return status.getData();
    }

    @Override
    public List<PInstructionManagement.GetInsBasketAdviceResp> queryInsBasketItems(String instructionId, int type) throws MException {
        LinkedList<PInstructionManagement.GetInsBasketAdviceResp> listResp = new LinkedList<PInstructionManagement.GetInsBasketAdviceResp>();
        PBase.Page defPage = this.bmi.getDefPage();
        int i = 0;
        this.queryInsBasketItemsByPage(instructionId, type, listResp, defPage, i);
        return listResp;
    }

    private void queryInsBasketItemsByPage(String instructionId, int type, List<PInstructionManagement.GetInsBasketAdviceResp> listResp, PBase.Page defPage, int i) throws MException {
        MEvent event = new MEvent();
        PInstructionManagement.GetInsBasketAdviceReq.Builder builder = PInstructionManagement.GetInsBasketAdviceReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setInstructionId(instructionId);
        builder.setPage(defPage);
        builder.setTypeValue(type);
        event.setObj((Object)builder.build());
        this.action(this.insSD, "787", event);
        PInstructionManagement.GetInsBasketAdviceResp resp = (PInstructionManagement.GetInsBasketAdviceResp)event.getObj(PInstructionManagement.GetInsBasketAdviceResp.class);
        this.checkStatus(resp.getStatus());
        listResp.add(resp);
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryInsBasketItemsByPage(instructionId, type, listResp, pageBuilder.build(), i);
        }
    }

    @Override
    public void updateInstructionReq(PInstructionService.UpdateInstructionReq.Builder reqTrade) throws MException {
        MEvent event = new MEvent();
        reqTrade.setOpUser(this.bmi.getOpUser());
        PInstructionManagement.UpdateInstructionReq.Builder req = PInstructionManagement.UpdateInstructionReq.newBuilder();
        req.setReq(reqTrade);
        event.setObj((Object)req.build());
        this.action(this.insSD, "781", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PInstructionManagement.NewFastInstructionResult> fastInstructions(PInstructionManagement.NewFastInstructionReq.Builder req) throws MException {
        req.setOpUser(this.bmi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)req.build());
        this.action(this.insSD, "788", event);
        PInstructionManagement.NewFastInstructionResp resp = (PInstructionManagement.NewFastInstructionResp)event.getObj(PInstructionManagement.NewFastInstructionResp.class);
        this.checkStatus(resp.getOpStauts());
        return resp.getResultList();
    }

    @Override
    public List<PInstruction.Instruction> getFastInstructions(PInstructionManagement.GetFastInstructionReq.Builder req) throws MException {
        ArrayList<PInstruction.Instruction> instructions = new ArrayList<PInstruction.Instruction>();
        PBase.Page defPage = this.getPage(1, 100);
        this.getFastInstructionsByPage(req, instructions, defPage);
        return instructions;
    }

    private void getFastInstructionsByPage(PInstructionManagement.GetFastInstructionReq.Builder req, List<PInstruction.Instruction> instructions, PBase.Page defPage) throws MException {
        MEvent event = new MEvent();
        req.setOpUser(this.bmi.getOpUser());
        req.setPage(defPage);
        event.setObj((Object)req.build());
        this.action(this.insSD, "791", event);
        PInstructionManagement.GetFastInstructionResp resp = (PInstructionManagement.GetFastInstructionResp)event.getObj(PInstructionManagement.GetFastInstructionResp.class);
        this.checkStatus(resp.getStatus());
        instructions.addAll(resp.getInstructionList());
        if (resp.getPage().getTotalRow() > instructions.size()) {
            this.getFastInstructionsByPage(req, instructions, this.getPage(instructions.size() + 1, 100));
        }
    }

    @Override
    public void executeAction(PInstructionManagement.ExecuteActionReq.Builder exeReq) throws MException {
        exeReq.setOpUser(this.bmi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)exeReq.build());
        this.action(this.insSD, "790", event);
        this.checkStatus(event.getObj());
    }

    @Override
    public List<PInstructionManagement.CancelResult> cancelFastInstruction(PInstructionManagement.CancelFastInstructionReq.Builder req) throws MException {
        req.setOpUser(this.bmi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)req.build());
        this.action(this.insSD, "789", event);
        PInstructionManagement.CancelFastInstructionResp resp = (PInstructionManagement.CancelFastInstructionResp)event.getObj(PInstructionManagement.CancelFastInstructionResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getResultList();
    }

    public PBase.Page getPage(int startRaw, int pageSize) {
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(pageSize);
        builder.setStartRow(startRaw);
        return builder.build();
    }

    @Override
    public List<PInstructionManagement.CheckResult> checkAvalidPosition(PInstructionManagement.CheckAvalidPositionReq.Builder req) throws MException {
        req.setOpUser(this.bmi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)req.build());
        this.action(this.insSD, "793", event);
        PInstructionManagement.CheckAvalidPositionResp resp = (PInstructionManagement.CheckAvalidPositionResp)event.getObj(PInstructionManagement.CheckAvalidPositionResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getCheckResultList();
    }

    @Override
    public List<PInstructionManagement.GetPositionResult> getSecurityAvalidPosition(PInstructionManagement.GetSecurityAvalidPositionReq.Builder req) throws MException {
        req.setOpUser(this.bmi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)req.build());
        this.action(this.insSD, "794", event);
        PInstructionManagement.GetAvalidPositionResp resp = (PInstructionManagement.GetAvalidPositionResp)event.getObj(PInstructionManagement.GetAvalidPositionResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getResultsList();
    }

    @Override
    public List<PInstructionManagement.GetPositionResult> getSubSecAccntAvalidPosition(PInstructionManagement.GetSubSecAccntAvalidPositionReq.Builder req) throws MException {
        req.setOpUser(this.bmi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)req.build());
        this.action(this.insSD, "795", event);
        PInstructionManagement.GetAvalidPositionResp resp = (PInstructionManagement.GetAvalidPositionResp)event.getObj(PInstructionManagement.GetAvalidPositionResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getResultsList();
    }
}

