/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.data.impl;

import cms.tmx.api.CallApi;
import cms.tmx.api.DataServiceDefines;
import cms.tmx.api.data.IRefApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.refdata.PRefDataService;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class RefApiImpl
extends CallApi
implements IRefApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private DataServiceDefines.RefServiceDefine rs;

    @Override
    public List<PRefData.SecListItem> loadRefData(int reqType, String market, String secType, String subType, List<PComponent.Instrument> listins) throws MException {
        PRefData.SecurityListRequest.Builder builder = PRefData.SecurityListRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketId(market);
        builder.setSecurityListRequestType(reqType);
        if (listins == null) {
            PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
            builderInst.setSecurityType(secType);
            builderInst.setSecuritySubType(subType);
            ArrayList<PComponent.Instrument> listc = new ArrayList<PComponent.Instrument>();
            listc.add(builderInst.build());
            if (reqType == 1 || reqType == 6) {
                builder.addAllInstrument(listc);
            }
        } else if (reqType == 12) {
            builder.addAllInstrument(listins);
        }
        PBase.Pager.Builder pagerBuilder = PBase.Pager.newBuilder();
        pagerBuilder.setStartRow(0);
        pagerBuilder.setPageSize(Integer.MAX_VALUE);
        String index = "1";
        PRefData.SecurityList listSec = null;
        LinkedList<PRefData.SecListItem> list = new LinkedList<PRefData.SecListItem>();
        do {
            pagerBuilder.setNextId(index);
            builder.setPager(pagerBuilder.build());
            MEvent event = new MEvent();
            event.setObj((Object)builder.build());
            this.action(this.rs, "250", event);
            listSec = (PRefData.SecurityList)event.takeObj(PRefData.SecurityList.class);
            this.checkStatus(listSec.getOpStatus());
            index = listSec.getPagination().getNextId();
            list.addAll(listSec.getSecListItemList());
        } while (listSec != null && listSec.getPagination().getHasMore());
        return list;
    }

    @Override
    public PRefData.SecurityList loadRefRate(int reqType, String market, String secType, String subType) throws MException {
        return this.loadRefRate(reqType, market, secType, subType, null, null);
    }

    @Override
    public PRefData.SecurityList loadRefRate(int reqType, String market, String secType, String subType, String date, String hkmarket) throws MException {
        PRefData.SecurityListRequest.Builder builder = PRefData.SecurityListRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketId(market);
        builder.setSecurityListRequestType(reqType);
        if (!StringUtils.isEmpty((String)date)) {
            builder.setStartDate(date);
        }
        PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
        builderInst.setSecurityType(secType);
        builderInst.setSecuritySubType(subType);
        if (!StringUtils.isEmpty((String)hkmarket)) {
            builderInst.setMarket(hkmarket);
        }
        ArrayList<PComponent.Instrument> listc = new ArrayList<PComponent.Instrument>();
        listc.add(builderInst.build());
        if (reqType == 1 || reqType == 6 || reqType == 10 && !StringUtils.isEmpty((String)hkmarket)) {
            builder.addAllInstrument(listc);
        }
        PRefData.SecurityList listSec = null;
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.rs, "250", event);
        listSec = (PRefData.SecurityList)event.takeObj(PRefData.SecurityList.class);
        this.checkStatus(listSec.getOpStatus());
        return listSec;
    }

    @Override
    public String getRefDataVersion() throws MException {
        PRefDataService.RefDataVersionReq.Builder build = PRefDataService.RefDataVersionReq.newBuilder();
        build.setOpUser(this.baseApi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)build.build());
        this.action(this.rs, "255", event);
        PRefDataService.RefDataVersionResp res = (PRefDataService.RefDataVersionResp)event.takeObj(PRefDataService.RefDataVersionResp.class);
        this.checkStatus(res.getOpStatus());
        return res.getUpdateVersion();
    }
}

