/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.data.impl;

import cms.tmx.api.CallApi;
import cms.tmx.api.DataServiceDefines;
import cms.tmx.api.IServiceDefine;
import cms.tmx.api.data.IGears;
import cms.tmx.api.data.IMarketApi;
import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMarketData;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class MarketApiImpl
extends CallApi
implements IMarketApi {
    private static Logger logger = LogManager.getLogger(MarketApiImpl.class);
    @Inject
    private IBaseApi baseApi;
    @Inject
    private DataServiceDefines.MarketServiceDefine msd;
    @Inject
    private DataServiceDefines.FuturesMarketServiceDefine fmsd;

    @Override
    public PMarketData.MarketDataResponse query(List<IRefItem> listQuery, IGears gears) throws MException {
        PMarketData.MarketDataResponse.Builder res = PMarketData.MarketDataResponse.newBuilder();
        List<MEvent> listEvent = this.shunt(listQuery, "202", gears);
        listEvent.forEach(event -> {
            PMarketData.MarketDataResponse mdr = (PMarketData.MarketDataResponse)event.getObj(PMarketData.MarketDataResponse.class);
            if (mdr.getStatus().getStatus() != 1) {
                logger.error("market query faild:" + mdr);
            }
            res.addAllMdSnapshot((Iterable)mdr.getMdSnapshotList());
        });
        return res.build();
    }

    @Override
    public PMarketData.MarketDataResponse sub(List<IRefItem> listSub) throws MException {
        logger.info("sub market , size:" + listSub.size());
        logger.debug("sub market , size:" + listSub);
        PMarketData.MarketDataResponse.Builder res = PMarketData.MarketDataResponse.newBuilder();
        List<MEvent> listEvent = this.shunt(listSub, "200", null);
        listEvent.forEach(event -> {
            PMarketData.MarketDataResponse mdr = (PMarketData.MarketDataResponse)event.getObj(PMarketData.MarketDataResponse.class);
            if (mdr.getStatus().getStatus() != 1) {
                logger.error("market sub faild:" + mdr);
            }
            res.addAllMdSnapshot((Iterable)mdr.getMdSnapshotList());
        });
        return res.build();
    }

    @Override
    public PBase.OpStatus unSub(List<IRefItem> listUnSub) throws MException {
        List<MEvent> listEvent = this.shunt(listUnSub, "201", null);
        if (listEvent.isEmpty()) {
            return null;
        }
        return (PBase.OpStatus)listEvent.get(0).getObj(PBase.OpStatus.class);
    }

    private List<MEvent> shunt(List<IRefItem> list, String method, IGears gears) throws MException {
        LinkedList<IRefItem> listCcs = new LinkedList<IRefItem>();
        LinkedList<IRefItem> listFut = new LinkedList<IRefItem>();
        list.forEach(item -> {
            if (item.getType().equals("FUT")) {
                listFut.add((IRefItem)item);
            } else {
                listCcs.add((IRefItem)item);
            }
        });
        LinkedList<MEvent> listEvent = new LinkedList<MEvent>();
        if (!listCcs.isEmpty()) {
            listEvent.add(this.subMarketReq(this.msd, method, listCcs, gears));
        }
        if (!listFut.isEmpty()) {
            listEvent.add(this.subMarketReq(this.fmsd, method, listFut, gears));
        }
        return listEvent;
    }

    private MEvent subMarketReq(IServiceDefine isd, String method, List<IRefItem> items, IGears gears) throws MException {
        PMarketData.InstrmtMDReqGrp.Builder grpBuilder = PMarketData.InstrmtMDReqGrp.newBuilder();
        for (IRefItem item : items) {
            PComponent.Instrument.Builder instBuilder = PComponent.Instrument.newBuilder();
            instBuilder.setSecurityId(item.getCode());
            instBuilder.setMarket(item.getMarket());
            PMarketData.InstrmtMDReq.Builder imdrBuilder = PMarketData.InstrmtMDReq.newBuilder();
            imdrBuilder.setInstrument(instBuilder.build());
            grpBuilder.addReq(imdrBuilder.build());
        }
        PMarketData.MarketDataRequest.Builder builder = PMarketData.MarketDataRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setInstrmtMdReqGrp(grpBuilder.build());
        if (gears != null) {
            builder.addAllMdBidLevel(gears.getBuys());
            builder.addAllMdOfferLevel(gears.getSells());
        }
        MEvent eCall = new MEvent();
        eCall.setObj((Object)builder.build());
        if ("200".equals(method)) {
            this.subscribe(isd, method, eCall);
            if (logger.isDebugEnabled()) {
                logger.debug("PMarketData.MarketDataRequest:" + eCall.getId() + " " + builder);
            }
        } else {
            this.action(isd, method, eCall);
        }
        return eCall;
    }

    @Override
    public PBase.OpStatus heartbeatReq() throws MException {
        PMarketData.MdHeartbeatReq.Builder builder = PMarketData.MdHeartbeatReq.newBuilder();
        builder.setUser(this.baseApi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.msd, "206", event);
        Object obj = event.getObj();
        if (obj instanceof PBase.OpStatus) {
            return (PBase.OpStatus)PBase.OpStatus.class.cast(obj);
        }
        return null;
    }

    @Override
    public PBase.OpStatus heartbeatFutureReq() throws MException {
        PMarketData.MdHeartbeatReq.Builder builder = PMarketData.MdHeartbeatReq.newBuilder();
        builder.setUser(this.baseApi.getOpUser());
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.fmsd, "206", event);
        Object obj = event.getObj();
        if (obj instanceof PBase.OpStatus) {
            return (PBase.OpStatus)PBase.OpStatus.class.cast(obj);
        }
        return null;
    }

    @Override
    public String getItemPushTopic() {
        return "uap.push." + this.msd.getServerCode() + "203";
    }
}

