/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.basket.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.basket.IQueryBasketOrderApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class QueryBasketOrderImpl
extends CallApi
implements IQueryBasketOrderApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;

    @Override
    public POrderService.ListOrder queryOrder(String listId) throws MException {
        LinkedList<POrderService.ListOrder> listOrderList = new LinkedList<POrderService.ListOrder>();
        int i = 0;
        PBase.Page defPage = this.baseApi.getDefPage();
        this.queryOrdersByPage(listOrderList, listId, null, null, null, defPage, i);
        return (POrderService.ListOrder)listOrderList.get(0);
    }

    @Override
    public List<POrderService.ListOrder> queryOrderByResource(List<String> resourceIds) throws MException {
        LinkedList<POrderService.ListOrder> listOrderList = new LinkedList<POrderService.ListOrder>();
        int i = 0;
        PBase.Page defPage = this.baseApi.getDefPage();
        this.queryOrdersByPage(listOrderList, null, null, null, resourceIds, defPage, i);
        return listOrderList;
    }

    @Override
    public List<POrderService.ListOrder> queryOrders(List<String> extAccntIds, List<String> subAccntIds) throws MException {
        LinkedList<POrderService.ListOrder> listOrderList = new LinkedList<POrderService.ListOrder>();
        if ((extAccntIds == null || extAccntIds.isEmpty()) && (subAccntIds == null || subAccntIds.isEmpty())) {
            return listOrderList;
        }
        int i = 0;
        PBase.Page defPage = this.baseApi.getDefPage();
        this.queryOrdersByPage(listOrderList, null, extAccntIds, subAccntIds, null, defPage, i);
        return listOrderList;
    }

    private void queryOrdersByPage(List<POrderService.ListOrder> listOrderList, String listId, List<String> extAccntIds, List<String> subAccntIds, List<String> resourceIds, PBase.Page defPage, int index) throws MException {
        MEvent event = new MEvent();
        POrderService.GetListOrdersReq.Builder builder = POrderService.GetListOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp("CCS");
        if (listId != null) {
            builder.setListId(listId);
        }
        if (extAccntIds != null) {
            builder.addAllExtAccntId(extAccntIds);
        }
        if (subAccntIds != null) {
            builder.addAllSubAccntId(subAccntIds);
        }
        if (resourceIds != null) {
            builder.addAllResourceId(resourceIds);
        }
        builder.setPage(defPage);
        event.setObj((Object)builder.build());
        this.action(this.queryService, "268", event);
        POrderService.GetListOrdersResp resp = (POrderService.GetListOrdersResp)event.getObj(POrderService.GetListOrdersResp.class);
        this.checkStatus(resp.getStatus());
        listOrderList.addAll(resp.getOrdersList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++index) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * index + 1);
            this.queryOrdersByPage(listOrderList, listId, extAccntIds, subAccntIds, resourceIds, pageBuilder.build(), index);
        }
    }

    @Override
    public void queryListOrderLegsByPage(IPageInTurn<Object, String, POrderService.ListOrderLeg> page) throws MException {
        List<POrderService.ListOrderLeg> listOrderLegsList = null;
        listOrderLegsList = page.getResList() == null ? new CopyOnWriteArrayList<POrderService.ListOrderLeg>() : page.getResList();
        MEvent event = new MEvent();
        POrderService.GetListOrdersReq.Builder builder = POrderService.GetListOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp("CCS");
        builder.setListId(page.getParam());
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        pageBuilder.setPageSize(page.getPageSize());
        pageBuilder.setStartRow(page.getStartRow());
        builder.setPage(pageBuilder.build());
        event.setObj((Object)builder.build());
        this.action(this.queryService, "268", event);
        POrderService.GetListOrdersResp resp = (POrderService.GetListOrdersResp)event.getObj(POrderService.GetListOrdersResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getOrdersList().size() > 0) {
            listOrderLegsList.addAll(((POrderService.ListOrder)resp.getOrdersList().get(0)).getLegsList());
        }
        page.setResList(listOrderLegsList);
        page.setTotalRow(resp.getPage().getTotalRow());
        int resSize = ((POrderService.ListOrder)resp.getOrdersList().get(0)).getLegsList().size();
        if (resSize == 0) {
            return;
        }
        if (resSize < page.getPageSize()) {
            page.setStartRow(page.getStartRow() + resSize);
            page.setPageSize(page.getPageSize() - resSize);
            this.queryListOrderLegsByPage(page);
        }
    }

    @Override
    public List<POrderService.ListOrderLeg> queryListOrderLegs(String listId, Set<String> legIdList) throws MException {
        LinkedList<POrderService.ListOrderLeg> listOrderLegsList = new LinkedList<POrderService.ListOrderLeg>();
        int i = 0;
        PBase.Page defPage = this.baseApi.getDefPage();
        this.queryListOrderLegsByPage(listOrderLegsList, defPage, i, listId, legIdList);
        return listOrderLegsList;
    }

    private void queryListOrderLegsByPage(List<POrderService.ListOrderLeg> listOrderLegsList, PBase.Page defPage, int index, String listId, Set<String> legIdList) throws MException {
        MEvent event = new MEvent();
        POrderService.GetListOrdersReq.Builder builder = POrderService.GetListOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp("CCS");
        builder.setListId(listId);
        builder.setPage(defPage);
        if (legIdList != null && !legIdList.isEmpty()) {
            builder.addAllLegId(legIdList);
        }
        event.setObj((Object)builder.build());
        this.action(this.queryService, "268", event);
        POrderService.GetListOrdersResp resp = (POrderService.GetListOrdersResp)event.getObj(POrderService.GetListOrdersResp.class);
        this.checkStatus(resp.getStatus());
        int respSize = 0;
        if (resp.getOrdersList().size() <= 0 || ((POrderService.ListOrder)resp.getOrdersList().get(0)).getLegsList().size() <= 0) {
            return;
        }
        respSize = ((POrderService.ListOrder)resp.getOrdersList().get(0)).getLegsList().size();
        listOrderLegsList.addAll(((POrderService.ListOrder)resp.getOrdersList().get(0)).getLegsList());
        if (resp.getPage().getTotalRow() > defPage.getStartRow() + respSize - 1) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getStartRow() + respSize);
            this.queryListOrderLegsByPage(listOrderLegsList, pageBuilder.build(), index, listId, legIdList);
        }
    }
}

