/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.basket.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.basket.INewOrderListApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NewOrderListApiImpl
extends CallApi
implements INewOrderListApi {
    private static final Logger logger = LogManager.getLogger(NewOrderListApiImpl.class);
    @Inject
    private TradeServiceDefines.OrderServiceDefine hs;
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private ExecutorService exe;
    private String subAccntId;
    private AtomicInteger packIndex;
    private AtomicInteger cfmPacks;
    private MException exception;
    private String uuid;
    private String batchId;
    private static long maxWaitTime = 10000L;

    @Override
    public synchronized String submit(List<PMessage.ListOrdGrpLeg> newOrderList, String basketId, String basketName, String portfolioId, String referenceId, String resourceId, String clListId) throws MException {
        long startTime = System.currentTimeMillis();
        Date time = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        logger.info("\u5f00\u59cb\u4e0b\u7bee\u5b50\u5355" + df.format(time));
        logger.info("\u7bee\u5b50\u7b14\u6570" + newOrderList.size());
        this.initPara();
        if (newOrderList == null || newOrderList.isEmpty()) {
            return "";
        }
        String extAccntId = newOrderList.get(0).getExtAccntId();
        if (!StringUtils.isEmpty((String)portfolioId)) {
            this.subAccntId = newOrderList.get(0).getSubAccntId();
        }
        PBase.Fragment fragment = this.baseApi.getFragment(newOrderList.size());
        int index = 0;
        while (this.packIndex.intValue() <= fragment.getTotalFragNum()) {
            int endIndex = index + 150 > fragment.getTotalDataNum() ? fragment.getTotalDataNum() - 1 : index + 150 - 1;
            List<PMessage.ListOrdGrpLeg> fragOrderList = newOrderList.subList(index, endIndex + 1);
            this.exe.execute(() -> {
                try {
                    this.fragmentSubmit(fragOrderList, basketId, basketName, portfolioId, extAccntId, this.subAccntId, fragment, referenceId, resourceId, clListId);
                }
                catch (MException e) {
                    this.exception = e;
                }
            });
            index += 150;
            this.packIndex.getAndIncrement();
        }
        while (this.cfmPacks.intValue() < fragment.getTotalFragNum()) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (System.currentTimeMillis() - startTime <= maxWaitTime) continue;
            throw new MException(-1, "\u8d85\u65f6");
        }
        long endTime = System.currentTimeMillis();
        float excTime = (float)(endTime - startTime) / 1000.0f;
        logger.info("\u7bee\u5b50\u63d0\u4ea4\u5b8c\u6210\u65f6\u95f4\uff1a" + excTime + "s");
        return this.batchId;
    }

    private PMessage.NewOrderListResp fragmentSubmit(List<PMessage.ListOrdGrpLeg> fragOrderList, String basketId, String basketName, String portfolioId, String extAccntId, String subAccntId, PBase.Fragment fragment, String referenceId, String resourceId, String clListId) throws MException {
        MEvent event = new MEvent();
        PMessage.NewOrderList.Builder builder = PMessage.NewOrderList.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setExtAccntId(extAccntId);
        if (!StringUtils.isEmpty((String)portfolioId)) {
            builder.setPortfolioId(portfolioId);
            builder.setSubAccntId(subAccntId);
        }
        if (!clListId.isEmpty()) {
            builder.setClListId(clListId);
        }
        builder.setBatchId(this.uuid);
        builder.setBasketId(basketId);
        builder.setBasketName(basketName);
        builder.setReference(referenceId);
        builder.setResourceId(resourceId);
        builder.setListOrdTypeValue(2);
        PMessage.ListOrdGrp.Builder builderGrp = PMessage.ListOrdGrp.newBuilder();
        builderGrp.addAllOrdLeg(fragOrderList);
        PMessage.ListOrdGrp listOrdGrp = builderGrp.build();
        builder.setOrders(listOrdGrp);
        builder.setMarketGrp("CCS");
        PBase.Fragment.Builder frageBuilder = fragment.toBuilder();
        frageBuilder.setIndex(this.packIndex.intValue());
        fragment = frageBuilder.build();
        builder.setFragment(fragment);
        builder.getExecModeBuilder().setEmId(1);
        PMessage.NewOrderList order = builder.build();
        event.setObj((Object)order);
        this.action(this.hs, "276", event);
        this.checkStatus(((PMessage.NewOrderListResp)PMessage.NewOrderListResp.class.cast(event.getObj())).getStatus());
        PMessage.NewOrderListResp resp = (PMessage.NewOrderListResp)event.getObj(PMessage.NewOrderListResp.class);
        this.batchId = resp.getBatchId();
        this.cfmPacks.getAndIncrement();
        return resp;
    }

    private void initPara() {
        this.subAccntId = "";
        this.packIndex = new AtomicInteger(1);
        this.cfmPacks = new AtomicInteger(0);
        this.exception = null;
        this.uuid = UUID.randomUUID().toString();
    }
}

